/*
 * Decompiled with CFR 0.152.
 */
package ambience.formula1.mongodb;

import ambience.formula1.Error$;
import ambience.formula1.ErrorType;
import ambience.formula1.Formula;
import ambience.formula1.Formula$;
import ambience.formula1.Formula$Bracketed$;
import ambience.formula1.Formula$FieldOperand$;
import ambience.formula1.Formula$Times$;
import ambience.formula1.Formula$UnaryMinus$;
import ambience.formula1.Formula$UnaryNot$;
import ambience.formula1.Formula$ValueOperand$;
import ambience.formula1.parser.Data;
import ambience.formula1.parser.Data$BooleanValue$;
import ambience.formula1.parser.Data$DoubleValue$;
import ambience.formula1.parser.Data$LongValue$;
import ambience.formula1.parser.Data$StringValue$;
import ambience.formula1.parser.Tokenizer;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class AggregationBuilder$
implements Serializable {
    public static final AggregationBuilder$ MODULE$ = new AggregationBuilder$();

    private AggregationBuilder$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AggregationBuilder$.class);
    }

    public Either<ErrorType, Json> generate(String expression) {
        Either<ErrorType, Formula.Expression> either = Formula$.MODULE$.parse(expression);
        if (either instanceof Left) {
            ErrorType err = (ErrorType)((Left)either).value();
            return package$.MODULE$.Left().apply((Object)err);
        }
        if (either instanceof Right) {
            Formula.Expression value = (Formula.Expression)((Right)either).value();
            return this.descend(value);
        }
        throw new MatchError(either);
    }

    public Either<ErrorType, Json> descend(Formula.Expression exp) {
        Formula.Expression expression;
        while (true) {
            Formula.Expression expression2;
            Formula.Expression exp2;
            if ((expression = exp) instanceof Formula.Divide) {
                Formula.Divide divide = (Formula.Divide)expression;
                return this.handleDivide(divide);
            }
            if (expression instanceof Formula.Operator) {
                Formula.Operator opr = (Formula.Operator)expression;
                return this.handleOperator(opr);
            }
            if (!(expression instanceof Formula.Bracketed)) break;
            Formula.Bracketed bracketed = Formula$Bracketed$.MODULE$.unapply((Formula.Bracketed)expression);
            exp = exp2 = (expression2 = bracketed._1());
        }
        if (expression instanceof Formula.FieldOperand) {
            Tokenizer.IdentifierToken identifierToken;
            Formula.FieldOperand fieldOperand = Formula$FieldOperand$.MODULE$.unapply((Formula.FieldOperand)expression);
            Tokenizer.IdentifierToken col = identifierToken = fieldOperand._1();
            return package$.MODULE$.Right().apply((Object)Json$.MODULE$.fromString("$" + col.s()));
        }
        if (expression instanceof Formula.ValueOperand) {
            Data.Value value;
            Formula.ValueOperand valueOperand = Formula$ValueOperand$.MODULE$.unapply((Formula.ValueOperand)expression);
            Data.Value value2 = value = valueOperand._1();
            return this.handleValueOperand(value2);
        }
        if (expression instanceof Formula.Unary) {
            Formula.Unary unary = (Formula.Unary)expression;
            return this.handleUnary(unary);
        }
        Formula.Expression other = expression;
        return package$.MODULE$.Left().apply((Object)Error$.MODULE$.apply("Unable to build agg: " + other));
    }

    public Either<ErrorType, Json> handleUnary(Formula.Unary unary) {
        Formula.Unary unary2 = unary;
        if (unary2 instanceof Formula.UnaryMinus) {
            Formula.Expression expression;
            Formula.UnaryMinus unaryMinus = Formula$UnaryMinus$.MODULE$.unapply((Formula.UnaryMinus)unary2);
            Formula.Expression exp = expression = unaryMinus._1();
            Formula.ValueOperand negativeMultiplier = Formula$ValueOperand$.MODULE$.apply(Data$LongValue$.MODULE$.apply(-1L));
            return this.descend(Formula$Times$.MODULE$.apply(negativeMultiplier, exp));
        }
        if (unary2 instanceof Formula.UnaryNot) {
            Formula.Expression expression;
            Formula.UnaryNot unaryNot = Formula$UnaryNot$.MODULE$.unapply((Formula.UnaryNot)unary2);
            Formula.Expression exp = expression = unaryNot._1();
            return this.descend(exp).map((Function1 & Serializable)json -> {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$not");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, json);
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            });
        }
        throw new MatchError((Object)unary2);
    }

    public Either<ErrorType, Json> handleDivide(Formula.Divide d) {
        String oprName = this.getOperatorName(d);
        return this.descend(d.lhs()).flatMap((Function1 & Serializable)lhs -> MODULE$.descend(d.rhs()).flatMap((Function1 & Serializable)rhs -> {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$cond");
            Object[] objectArray2 = new Tuple2[3];
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"if");
            Object[] objectArray3 = new Tuple2[1];
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"$eq");
            objectArray3[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Json$.MODULE$.arr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Json[]{rhs, Json$.MODULE$.fromInt(0)})));
            objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3)));
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"then");
            objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)Json$.MODULE$.Null());
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"else");
            Object[] objectArray4 = new Tuple2[1];
            String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)oprName);
            objectArray4[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)Json$.MODULE$.arr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Json[]{lhs, rhs})));
            objectArray2[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray4)));
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
            return package$.MODULE$.Right().apply((Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).map((Function1 & Serializable)agg -> agg);
        }));
    }

    public Either<ErrorType, Json> handleOperator(Formula.Operator opr) {
        String oprName = this.getOperatorName(opr);
        return this.descend(opr.lhs()).flatMap((Function1 & Serializable)lhs -> MODULE$.descend(opr.rhs()).flatMap((Function1 & Serializable)rhs -> {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)oprName);
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.arr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Json[]{lhs, rhs})));
            return package$.MODULE$.Right().apply((Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).map((Function1 & Serializable)agg -> agg);
        }));
    }

    public Either<ErrorType, Json> handleValueOperand(Data.Value data) {
        Data.Value value = data;
        if (value instanceof Data.StringValue) {
            String string;
            Data.StringValue stringValue = Data$StringValue$.MODULE$.unapply((Data.StringValue)value);
            String value2 = string = stringValue._1();
            return package$.MODULE$.Right().apply((Object)Json$.MODULE$.fromString(value2));
        }
        if (value instanceof Data.LongValue) {
            long l;
            Data.LongValue longValue = Data$LongValue$.MODULE$.unapply((Data.LongValue)value);
            long value3 = l = longValue._1();
            return package$.MODULE$.Right().apply((Object)Json$.MODULE$.fromLong(value3));
        }
        if (value instanceof Data.DoubleValue) {
            Data.DoubleValue doubleValue = Data$DoubleValue$.MODULE$.unapply((Data.DoubleValue)value);
            double d = doubleValue._1();
            double value4 = d;
            Option option = Json$.MODULE$.fromDouble(value4);
            if (option instanceof Some) {
                Json value5 = (Json)((Some)option).value();
                return package$.MODULE$.Right().apply((Object)value5);
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)Error$.MODULE$.apply("Double operands issue: " + value4));
            }
            throw new MatchError((Object)option);
        }
        if (value instanceof Data.BooleanValue) {
            boolean bl;
            Data.BooleanValue booleanValue = Data$BooleanValue$.MODULE$.unapply((Data.BooleanValue)value);
            boolean value6 = bl = booleanValue._1();
            return package$.MODULE$.Right().apply((Object)Json$.MODULE$.fromBoolean(value6));
        }
        throw new MatchError((Object)value);
    }

    public String getOperatorName(Formula.Operator opr) {
        String string = opr.symbol();
        switch (string == null ? 0 : string.hashCode()) {
            case 42: {
                if (!"*".equals(string)) break;
                return "$multiply";
            }
            case 43: {
                if (!"+".equals(string)) break;
                return "$add";
            }
            case 45: {
                if (!"-".equals(string)) break;
                return "$subtract";
            }
            case 47: {
                if (!"/".equals(string)) break;
                return "$divide";
            }
            case 60: {
                if (!"<".equals(string)) break;
                return "$lt";
            }
            case 61: {
                if (!"=".equals(string)) break;
                return "$eq";
            }
            case 62: {
                if (!">".equals(string)) break;
                return "$gt";
            }
            case 1921: {
                if (!"<=".equals(string)) break;
                return "$lte";
            }
            case 1983: {
                if (!">=".equals(string)) break;
                return "$gte";
            }
        }
        throw new MatchError((Object)string);
    }
}

