/*
 * Decompiled with CFR 0.152.
 */
package ambience.formula1.parser;

import ambience.formula1.parser.Tokenizer$CharToken$;
import ambience.formula1.parser.Tokenizer$IdentifierToken$;
import ambience.formula1.parser.Tokenizer$NumberToken$;
import ambience.formula1.parser.Tokenizer$StringToken$;
import java.io.Serializable;
import scala.Predef$;
import scala.Product;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class Tokenizer
implements Iterator<Token> {
    private final String textIn;
    private int idx;
    private final String text;
    private final int len;

    public Tokenizer(String textIn) {
        this.textIn = textIn;
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        Iterator.$init$((Iterator)this);
        this.idx = 0;
        this.text = textIn.trim();
        this.len = this.text().length();
    }

    public String textIn() {
        return this.textIn;
    }

    public int idx() {
        return this.idx;
    }

    public void idx_$eq(int x$1) {
        this.idx = x$1;
    }

    public String text() {
        return this.text;
    }

    public int len() {
        return this.len;
    }

    public boolean hasNext() {
        return this.idx() < this.len();
    }

    public Token next() {
        Product product;
        char ch = this.text().charAt(this.idx());
        if (Character.isWhitespace(ch)) {
            this.idx_$eq(this.idx() + 1);
            while (Character.isWhitespace(this.text().charAt(this.idx()))) {
                this.idx_$eq(this.idx() + 1);
            }
            return this.next();
        }
        if (ch == '\"') {
            int j = this.idx() + 1;
            StringBuilder sb = new StringBuilder();
            boolean stop = false;
            while (j < this.len() && !stop) {
                char ch2 = this.text().charAt(j);
                if (ch2 == '\"') {
                    stop = true;
                    continue;
                }
                if (ch2 == '\\') {
                    if (++j < this.len()) {
                        sb.append(this.text().charAt(j));
                    }
                    ++j;
                    continue;
                }
                sb.append(ch2);
                ++j;
            }
            String token = sb.toString();
            this.idx_$eq(j + 1);
            return Tokenizer$StringToken$.MODULE$.apply(token);
        }
        if (Character.isJavaIdentifierStart(ch)) {
            int j;
            for (j = this.idx() + 1; j < this.len() && Character.isJavaIdentifierPart(this.text().charAt(j)); ++j) {
            }
            String token = this.text().substring(this.idx(), j);
            this.idx_$eq(j);
            return Tokenizer$IdentifierToken$.MODULE$.apply(token);
        }
        if (Character.isDigit(ch)) {
            int j;
            for (j = this.idx() + 1; j < this.len() && this.isDigitOrDot(this.text().charAt(j)); ++j) {
            }
            String token = this.text().substring(this.idx(), j);
            this.idx_$eq(j);
            product = Tokenizer$NumberToken$.MODULE$.apply(token);
        } else {
            this.idx_$eq(this.idx() + 1);
            product = Tokenizer$CharToken$.MODULE$.apply(BoxesRunTime.boxToCharacter((char)ch).toString());
        }
        return product;
    }

    public String remainder() {
        return this.text().substring(this.idx());
    }

    private boolean isDigitOrDot(char ch) {
        return Character.isDigit(ch) || ch == '.';
    }

    public static class CharToken
    implements Token,
    Product,
    Serializable {
        private final String s;

        public static CharToken apply(String string) {
            return Tokenizer$CharToken$.MODULE$.apply(string);
        }

        public static CharToken fromProduct(Product product) {
            return Tokenizer$CharToken$.MODULE$.fromProduct(product);
        }

        public static CharToken unapply(CharToken charToken) {
            return Tokenizer$CharToken$.MODULE$.unapply(charToken);
        }

        public CharToken(String s) {
            this.s = s;
            Predef$.MODULE$.require(s.length() == 1, () -> this.$init$$$anonfun$1(s));
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CharToken)) return false;
            CharToken charToken = (CharToken)object;
            String string = this.s();
            String string2 = charToken.s();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!charToken.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CharToken;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "CharToken";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "s";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String s() {
            return this.s;
        }

        public CharToken copy(String s) {
            return new CharToken(s);
        }

        public String copy$default$1() {
            return this.s();
        }

        public String _1() {
            return this.s();
        }

        private final Object $init$$$anonfun$1(String s$1) {
            return "s is " + s$1;
        }
    }

    public static class IdentifierToken
    implements Token,
    Product,
    Serializable {
        private final String s;

        public static IdentifierToken apply(String string) {
            return Tokenizer$IdentifierToken$.MODULE$.apply(string);
        }

        public static IdentifierToken fromProduct(Product product) {
            return Tokenizer$IdentifierToken$.MODULE$.fromProduct(product);
        }

        public static IdentifierToken unapply(IdentifierToken identifierToken) {
            return Tokenizer$IdentifierToken$.MODULE$.unapply(identifierToken);
        }

        public IdentifierToken(String s) {
            this.s = s;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof IdentifierToken)) return false;
            IdentifierToken identifierToken = (IdentifierToken)object;
            String string = this.s();
            String string2 = identifierToken.s();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!identifierToken.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof IdentifierToken;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "IdentifierToken";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "s";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String s() {
            return this.s;
        }

        public IdentifierToken copy(String s) {
            return new IdentifierToken(s);
        }

        public String copy$default$1() {
            return this.s();
        }

        public String _1() {
            return this.s();
        }
    }

    public static class NumberToken
    implements Token,
    Product,
    Serializable {
        private final String s;

        public static NumberToken apply(String string) {
            return Tokenizer$NumberToken$.MODULE$.apply(string);
        }

        public static NumberToken fromProduct(Product product) {
            return Tokenizer$NumberToken$.MODULE$.fromProduct(product);
        }

        public static NumberToken unapply(NumberToken numberToken) {
            return Tokenizer$NumberToken$.MODULE$.unapply(numberToken);
        }

        public NumberToken(String s) {
            this.s = s;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NumberToken)) return false;
            NumberToken numberToken = (NumberToken)object;
            String string = this.s();
            String string2 = numberToken.s();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!numberToken.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof NumberToken;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "NumberToken";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "s";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String s() {
            return this.s;
        }

        public NumberToken copy(String s) {
            return new NumberToken(s);
        }

        public String copy$default$1() {
            return this.s();
        }

        public String _1() {
            return this.s();
        }
    }

    public static class StringToken
    implements Token,
    Product,
    Serializable {
        private final String s;

        public static StringToken apply(String string) {
            return Tokenizer$StringToken$.MODULE$.apply(string);
        }

        public static StringToken fromProduct(Product product) {
            return Tokenizer$StringToken$.MODULE$.fromProduct(product);
        }

        public static StringToken unapply(StringToken stringToken) {
            return Tokenizer$StringToken$.MODULE$.unapply(stringToken);
        }

        public StringToken(String s) {
            this.s = s;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StringToken)) return false;
            StringToken stringToken = (StringToken)object;
            String string = this.s();
            String string2 = stringToken.s();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!stringToken.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StringToken;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "StringToken";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "s";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String s() {
            return this.s;
        }

        public StringToken copy(String s) {
            return new StringToken(s);
        }

        public String copy$default$1() {
            return this.s();
        }

        public String _1() {
            return this.s();
        }
    }

    public static interface Token {
        public String s();
    }
}

