/*
 * Decompiled with CFR 0.152.
 */
package ambience.layout;

import ambience.layout.Cell;
import ambience.layout.CellType;
import ambience.layout.CellType$;
import com.elixirtech.coredata.JsonToString$;
import com.elixirtech.json.JsonLens$;
import io.circe.Json;
import io.circe.JsonObject;
import java.io.Serializable;
import monocle.POptional;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.owasp.encoder.Encode;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class CellUtil$
implements Serializable {
    private static final POptional CellTypeLens;
    private static final POptional CellStyleLens;
    private static final POptional LabelTextLens;
    private static final POptional FieldNameLens;
    private static final POptional ImageURLLens;
    private static final POptional ImageAltLens;
    private static final POptional RichTextLens;
    public static final CellUtil$ MODULE$;

    private CellUtil$() {
    }

    static {
        MODULE$ = new CellUtil$();
        CellTypeLens = JsonLens$.MODULE$.root().selectDynamic("cellType").string();
        CellStyleLens = JsonLens$.MODULE$.root().selectDynamic("style").obj();
        LabelTextLens = JsonLens$.MODULE$.root().selectDynamic("text").string();
        FieldNameLens = JsonLens$.MODULE$.root().selectDynamic("field").string();
        ImageURLLens = JsonLens$.MODULE$.root().selectDynamic("url").string();
        ImageAltLens = JsonLens$.MODULE$.root().selectDynamic("alt").string();
        RichTextLens = JsonLens$.MODULE$.root().selectDynamic("html").string();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CellUtil$.class);
    }

    public POptional<Json, Json, String, String> CellTypeLens() {
        return CellTypeLens;
    }

    public POptional<Json, Json, JsonObject, JsonObject> CellStyleLens() {
        return CellStyleLens;
    }

    public POptional<Json, Json, String, String> LabelTextLens() {
        return LabelTextLens;
    }

    public POptional<Json, Json, String, String> FieldNameLens() {
        return FieldNameLens;
    }

    public POptional<Json, Json, String, String> ImageURLLens() {
        return ImageURLLens;
    }

    public POptional<Json, Json, String, String> ImageAltLens() {
        return ImageAltLens;
    }

    public POptional<Json, Json, String, String> RichTextLens() {
        return RichTextLens;
    }

    public Option<CellType> getCellType(Cell c) {
        return this.CellTypeLens().getOption((Object)c.content().json()).map((Function1 & Serializable)value -> new CellType(CellType$.MODULE$.apply(value)));
    }

    public String getCellParentStyle(Cell c) {
        Function1<String, Object> function1 = this.parentStyle();
        return (String)this.CellStyleLens().getOption((Object)c.content().json()).map((Function1 & Serializable)obj -> MODULE$.extractStyle(function1, (JsonObject)obj)).getOrElse(CellUtil$::getCellParentStyle$$anonfun$2);
    }

    public String getCellStyle(Cell c) {
        Function1<String, Object> function1 = this.cellStyle();
        return (String)this.CellStyleLens().getOption((Object)c.content().json()).map((Function1 & Serializable)obj -> MODULE$.extractStyle(function1, (JsonObject)obj)).getOrElse(CellUtil$::getCellStyle$$anonfun$2);
    }

    public String getLabelText(Cell c) {
        return (String)this.LabelTextLens().getOption((Object)c.content().json()).getOrElse(CellUtil$::getLabelText$$anonfun$1);
    }

    public String getFieldName(Cell c) {
        return (String)this.FieldNameLens().getOption((Object)c.content().json()).getOrElse(CellUtil$::getFieldName$$anonfun$1);
    }

    public String getImageURL(Cell c) {
        return (String)this.ImageURLLens().getOption((Object)c.content().json()).getOrElse(CellUtil$::getImageURL$$anonfun$1);
    }

    public String getImageAlt(Cell c) {
        return (String)this.ImageAltLens().getOption((Object)c.content().json()).getOrElse(CellUtil$::getImageAlt$$anonfun$1);
    }

    public String getRichText(Cell c) {
        return (String)this.RichTextLens().getOption((Object)c.content().json()).getOrElse(CellUtil$::getRichText$$anonfun$1);
    }

    public String extractStyle(Function1<String, Object> filter, JsonObject obj) {
        return this.safeAttr(obj.toList().filter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                return BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)k));
            }
            throw new MatchError((Object)tuple2);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Json v = (Json)tuple2._2();
                return JsonToString$.MODULE$.apply(v).map((Function1 & Serializable)_$1 -> {
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)k);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, _$1);
                });
            }
            throw new MatchError((Object)tuple2);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return k + ": " + v + ";";
            }
            throw new MatchError((Object)tuple2);
        }).mkString(" "));
    }

    public String safeText(String s) {
        return Encode.forHtmlContent((String)s);
    }

    public String safeHtml(String s) {
        return Jsoup.clean((String)s, (Safelist)Safelist.relaxed());
    }

    public String safeAttr(String s) {
        return Encode.forHtmlAttribute((String)s);
    }

    public Function1<String, Object> parentStyle() {
        return (Function1 & Serializable)x$1 -> {
            String string = x$1;
            return "background-color".equals(string);
        };
    }

    public Function1<String, Object> cellStyle() {
        return (Function1 & Serializable)x$1 -> {
            String string = x$1;
            return !"background-color".equals(string);
        };
    }

    private static final String getCellParentStyle$$anonfun$2() {
        return "";
    }

    private static final String getCellStyle$$anonfun$2() {
        return "";
    }

    private static final String getLabelText$$anonfun$1() {
        return "";
    }

    private static final String getFieldName$$anonfun$1() {
        return "";
    }

    private static final String getImageURL$$anonfun$1() {
        return "";
    }

    private static final String getImageAlt$$anonfun$1() {
        return "";
    }

    private static final String getRichText$$anonfun$1() {
        return "";
    }
}

