/*
 * Decompiled with CFR 0.152.
 */
package ambience.layout;

import ambience.bson.BsonETL$;
import ambience.etl.Builder;
import ambience.layout.Band;
import ambience.layout.BsonFormat$;
import ambience.layout.Cell;
import ambience.layout.CellType;
import ambience.layout.CellType$;
import ambience.layout.Header;
import ambience.layout.LayoutUtil$;
import ambience.module.CalendarChoice$;
import com.elixirtech.arch.ARM$;
import com.elixirtech.arch.Crypt$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.MimeInfo$;
import com.elixirtech.coredata.Format;
import com.elixirtech.json.JsonLens$;
import com.elixirtech.mongodb.BsonTransform$;
import com.elixirtech.webserver.I18N;
import io.circe.Json;
import io.circe.Json$;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import monix.eval.Task;
import monix.reactive.Observable$;
import monocle.POptional;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class RenderLayout$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(RenderLayout$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final POptional CellTypeLens;
    private static final String FieldType;
    private static final POptional FieldLens;
    private static final POptional FormatLens;
    private static final String ImageType;
    private static final POptional URLLens;
    private static final String RichTextType;
    private static final POptional RichTextLens;
    public static final RenderLayout$ MODULE$;

    private RenderLayout$() {
    }

    static {
        MODULE$ = new RenderLayout$();
        CellTypeLens = JsonLens$.MODULE$.root().selectDynamic("cellType").string();
        FieldType = CellType$.MODULE$.apply("basic.field");
        FieldLens = JsonLens$.MODULE$.root().selectDynamic("field").string();
        FormatLens = JsonLens$.MODULE$.root().selectDynamic("format").string();
        ImageType = CellType$.MODULE$.apply("basic.image");
        URLLens = JsonLens$.MODULE$.root().selectDynamic("url").string();
        RichTextType = CellType$.MODULE$.apply("basic.rich");
        RichTextLens = JsonLens$.MODULE$.root().selectDynamic("html").string();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RenderLayout$.class);
    }

    public POptional<Json, Json, String, String> CellTypeLens() {
        return CellTypeLens;
    }

    public String FieldType() {
        return FieldType;
    }

    public POptional<Json, Json, String, String> FieldLens() {
        return FieldLens;
    }

    public POptional<Json, Json, String, String> FormatLens() {
        return FormatLens;
    }

    public String ImageType() {
        return ImageType;
    }

    public POptional<Json, Json, String, String> URLLens() {
        return URLLens;
    }

    public String RichTextType() {
        return RichTextType;
    }

    public POptional<Json, Json, String, String> RichTextLens() {
        return RichTextLens;
    }

    public Option<CellType> getCellType(Cell c) {
        return this.CellTypeLens().getOption((Object)c.content().json()).map((Function1 & Serializable)value -> new CellType(CellType$.MODULE$.apply(value)));
    }

    public Task<Band> renderBand(Builder.Context cxt, Band band, Document doc) {
        Json json = BsonTransform$.MODULE$.toJson((BsonValue)doc.toBsonDocument());
        Task newCells = Observable$.MODULE$.fromIterable((Iterable)band.cells()).flatMap((Function1 & Serializable)cell -> {
            Either<LogMessage, Cell> either = MODULE$.renderCell(cxt, (Cell)cell, doc, json);
            if (either instanceof Right) {
                Cell cell2 = (Cell)((Right)either).value();
                return Observable$.MODULE$.now((Object)cell2);
            }
            if (either instanceof Left) {
                LogMessage logMessage = (LogMessage)((Left)either).value();
                if (LogMessage.None$.MODULE$.equals(logMessage)) {
                    return Observable$.MODULE$.empty();
                }
                if (logMessage != null) {
                    LogMessage msg = logMessage;
                    return Observable$.MODULE$.fromTask(cxt.logT(msg)).ignoreElements();
                }
            }
            throw new MatchError(either);
        }).toListL();
        return newCells.map((Function1 & Serializable)cs -> {
            Vector vector = cs.toVector();
            String string = band.copy$default$1();
            int n = band.copy$default$2();
            Header header = band.copy$default$3();
            return band.copy(string, n, header, vector);
        });
    }

    public Either<LogMessage, Cell> renderCell(Builder.Context cxt, Cell cell, Document doc, Json json) {
        return (Either)this.getCellType(cell).map((Function1 & Serializable)x$1 -> RenderLayout$.renderCell$$anonfun$1(cxt, cell, doc, json, x$1 == null ? null : ((CellType)x$1).value())).getOrElse(() -> RenderLayout$.renderCell$$anonfun$2(cell));
    }

    public Either<LogMessage, Cell> renderField(Builder.Context cxt, Cell cell, Document doc) {
        Option ret = this.FieldLens().getOption((Object)cell.content().json()).flatMap((Function1 & Serializable)field -> MODULE$.FormatLens().getOption((Object)cell.content().json()).map((Function1 & Serializable)format -> {
            String calendar = (String)doc.get("i18nLanguage", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)bs -> new I18N.Language(I18N.Language$.MODULE$.apply(bs.getValue()))).map((Function1 & Serializable)lang -> CalendarChoice$.MODULE$.getCalendar(lang == null ? null : ((I18N.Language)lang).value())).getOrElse(RenderLayout$::$anonfun$5);
            BsonValue value = (BsonValue)BsonETL$.MODULE$.get(doc, field).getOrElse(RenderLayout$::$anonfun$6);
            String text = (String)BsonFormat$.MODULE$.apply((String)format, Format.Context$.MODULE$.apply(calendar)).apply((Object)value);
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"cellType");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString("basic.label"));
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"text");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromString(text));
            Json newValues = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            return cell.withContentJson(cell.content().json().deepMerge(newValues));
        }));
        return ret.toRight(RenderLayout$::renderField$$anonfun$1);
    }

    public Either<LogMessage, Cell> renderImage(Builder.Context cxt, Cell cell, Json json) {
        return this.URLLens().getOption((Object)cell.content().json()).toRight(RenderLayout$::renderImage$$anonfun$1).flatMap((Function1 & Serializable)rawUrl -> {
            String url = LayoutUtil$.MODULE$.substituteFromJson((String)rawUrl, json);
            return (url.startsWith("http:") || url.startsWith("https:") ? MODULE$.buildHttpData(cxt, cell, json, url) : (url.startsWith("file:") ? MODULE$.buildFileData(cxt, cell, json, url) : package$.MODULE$.Left().apply((Object)LogMessage.None$.MODULE$))).map((Function1 & Serializable)ret -> ret);
        });
    }

    public Either<LogMessage, Cell> renderRichText(Builder.Context cxt, Cell cell, Json json) {
        return this.RichTextLens().getOption((Object)cell.content().json()).map((Function1 & Serializable)rich -> {
            String html = LayoutUtil$.MODULE$.substituteFromJson((String)rich, json);
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"html");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(html));
            Json newValues = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            return cell.withContentJson(cell.content().json().deepMerge(newValues));
        }).toRight(RenderLayout$::renderRichText$$anonfun$2);
    }

    public Either<LogMessage, Cell> buildHttpData(Builder.Context cxt, Cell cell, Json json, String url) {
        Try try_ = Try$.MODULE$.apply(() -> RenderLayout$.buildHttpData$$anonfun$1(url, cell));
        if (try_ instanceof Success) {
            Cell newCell = (Cell)((Success)try_).value();
            return package$.MODULE$.Right().apply((Object)newCell);
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Can't read URL " + url + ": " + ex));
        }
        throw new MatchError((Object)try_);
    }

    public Either<LogMessage, Cell> buildFileData(Builder.Context cxt, Cell cell, Json json, String url) {
        Try try_ = Try$.MODULE$.apply(() -> RenderLayout$.buildFileData$$anonfun$1(url, cell));
        if (try_ instanceof Success) {
            Either newCell = (Either)((Success)try_).value();
            return newCell;
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Can't read URL " + url + ": " + ex));
        }
        throw new MatchError((Object)try_);
    }

    public boolean isAccessibleFile(File file) {
        String currentDir = new File(".").getCanonicalPath();
        return file.getCanonicalPath().startsWith(currentDir);
    }

    private static final /* synthetic */ Either renderCell$$anonfun$1(Builder.Context cxt$2, Cell cell$1, Document doc$2, Json json$2, String x$1) {
        String string = x$1;
        String string2 = MODULE$.FieldType();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return MODULE$.renderField(cxt$2, cell$1, doc$2);
        }
        String string4 = MODULE$.ImageType();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return MODULE$.renderImage(cxt$2, cell$1, json$2);
        }
        String string6 = MODULE$.RichTextType();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return MODULE$.renderRichText(cxt$2, cell$1, json$2);
        }
        return package$.MODULE$.Right().apply((Object)cell$1);
    }

    private static final Either renderCell$$anonfun$2(Cell cell$2) {
        return package$.MODULE$.Right().apply((Object)cell$2);
    }

    private static final String $anonfun$5() {
        return CalendarChoice$.MODULE$.Default();
    }

    private static final BsonValue $anonfun$6() {
        return BsonString$.MODULE$.apply("");
    }

    private static final LogMessage.None$ renderField$$anonfun$1() {
        return LogMessage.None$.MODULE$;
    }

    private static final LogMessage.None$ renderImage$$anonfun$1() {
        return LogMessage.None$.MODULE$;
    }

    private static final LogMessage.None$ renderRichText$$anonfun$2() {
        return LogMessage.None$.MODULE$;
    }

    private static final String $anonfun$8() {
        return "";
    }

    private static final Cell buildHttpData$$anonfun$1(String url$1, Cell cell$7) {
        return (Cell)ARM$.MODULE$.run((Function1 & Serializable)arm -> {
            byte[] bytes = com.elixirtech.arch.package$.MODULE$.enrichInputStream((InputStream)arm.manage((Object)new URL(url$1).openStream())).contents();
            String ext = url$1.substring(url$1.lastIndexOf(".") + 1);
            String mimeType = (String)MimeInfo$.MODULE$.extensions().get((Object)ext).map((Function1 & Serializable)_$1 -> _$1.value()).getOrElse(RenderLayout$::$anonfun$8);
            String newURL = "data:" + mimeType + ";base64," + Crypt$.MODULE$.encode(bytes).replace("\r", "").replace("\n", "");
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"url");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(newURL));
            Json newValues = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            return cell$7.withContentJson(cell$7.content().json().deepMerge(newValues));
        });
    }

    private static final String $anonfun$10() {
        return "";
    }

    private static final Either buildFileData$$anonfun$1(String url$3, Cell cell$9) {
        File file = new File(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(url$3), "file:"));
        if (MODULE$.isAccessibleFile(file)) {
            String ext = url$3.substring(url$3.lastIndexOf(".") + 1);
            String mimeType = (String)MimeInfo$.MODULE$.extensions().get((Object)ext).map((Function1 & Serializable)_$2 -> _$2.value()).getOrElse(RenderLayout$::$anonfun$10);
            String newURL = "data:" + mimeType + ";base64," + Crypt$.MODULE$.encode(com.elixirtech.arch.package$.MODULE$.enrichFile(file).data()).replace("\r", "").replace("\n", "");
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"url");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(newURL));
            Json newValues = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            return package$.MODULE$.Right().apply((Object)cell$9.withContentJson(cell$9.content().json().deepMerge(newValues)));
        }
        return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Can't read file " + url$3 + " from outside the Ambience subtree"));
    }
}

