/*
 * Decompiled with CFR 0.152.
 */
package ambience.layout.etl;

import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLStep;
import ambience.layout.Band;
import ambience.layout.Cell;
import ambience.layout.CellType;
import ambience.layout.CellType$;
import ambience.layout.CellUtil$;
import ambience.layout.HeaderId;
import ambience.layout.Layout;
import ambience.layout.etl.RenderDirectPDF$;
import com.elixirtech.arch.LoggingInterface;
import io.circe.DecodingFailure;
import java.io.Serializable;
import monix.eval.Task;
import monix.reactive.Observable;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;

public class RenderDirectPDF {
    private final PDDocument pdf;
    private final Layout layout;
    private final int DPI;
    private final PDRectangle PageSize;
    private final double HeaderHeight;
    private final double FooterHeight;
    private final double LeftMargin;
    private final double RightMargin;
    private final double UsableWidth;
    private final double ScaleFactor;
    private final PDType1Font DefaultFont;
    private final Vector colStarts;
    private PDPage page;
    private PDPageContentStream contents;
    private double ypos;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(RenderDirectPDF$.class.getDeclaredField("log$lzy1"));

    public static Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context context, ETLStep eTLStep) {
        return RenderDirectPDF$.MODULE$.build(context, eTLStep);
    }

    public static Task<Document> buildDocument(Builder.Context context, Document document) {
        return RenderDirectPDF$.MODULE$.buildDocument(context, document);
    }

    public static Document buildDocument(Builder.Context context, Document document, Layout layout) {
        return RenderDirectPDF$.MODULE$.buildDocument(context, document, layout);
    }

    public static BuildError error(ETLStep eTLStep, DecodingFailure decodingFailure) {
        return RenderDirectPDF$.MODULE$.error(eTLStep, decodingFailure);
    }

    public static Task<Option<String>> explain(ETLStep eTLStep) {
        return RenderDirectPDF$.MODULE$.explain(eTLStep);
    }

    public static LoggingInterface log() {
        return RenderDirectPDF$.MODULE$.log();
    }

    public static Observable<Document> run(Builder.Context context, Observable<Document> observable) {
        return RenderDirectPDF$.MODULE$.run(context, observable);
    }

    public static String stepType() {
        return RenderDirectPDF$.MODULE$.stepType();
    }

    public RenderDirectPDF(PDDocument pdf, Layout layout) {
        this.pdf = pdf;
        this.layout = layout;
        this.DPI = 72;
        this.PageSize = PDRectangle.A4;
        this.HeaderHeight = 1.0 * (double)this.DPI();
        this.FooterHeight = 1.0 * (double)this.DPI();
        this.LeftMargin = 0.5 * (double)this.DPI();
        this.RightMargin = 0.5 * (double)this.DPI();
        this.UsableWidth = (double)this.PageSize().getWidth() - this.LeftMargin() - this.RightMargin();
        this.ScaleFactor = this.UsableWidth() / (double)layout.colHeader().length();
        this.DefaultFont = new PDType1Font(Standard14Fonts.FontName.HELVETICA_BOLD);
        this.colStarts = layout.colStarts();
        this.page = new PDPage(this.PageSize());
        pdf.addPage(this.page());
        this.contents = new PDPageContentStream(pdf, this.page());
        this.ypos = (double)this.PageSize().getHeight() - this.HeaderHeight() - this.FooterHeight();
        layout.bands().foreach((Function1)(JProcedure1 & Serializable)band -> this.renderBand((Band)band));
        this.contents().close();
    }

    public int DPI() {
        return this.DPI;
    }

    public PDRectangle PageSize() {
        return this.PageSize;
    }

    public double HeaderHeight() {
        return this.HeaderHeight;
    }

    public double FooterHeight() {
        return this.FooterHeight;
    }

    public double LeftMargin() {
        return this.LeftMargin;
    }

    public double RightMargin() {
        return this.RightMargin;
    }

    public double UsableWidth() {
        return this.UsableWidth;
    }

    public double ScaleFactor() {
        return this.ScaleFactor;
    }

    public PDType1Font DefaultFont() {
        return this.DefaultFont;
    }

    public Vector<Object> colStarts() {
        return this.colStarts;
    }

    public PDPage page() {
        return this.page;
    }

    public void page_$eq(PDPage x$1) {
        this.page = x$1;
    }

    public PDPageContentStream contents() {
        return this.contents;
    }

    public void contents_$eq(PDPageContentStream x$1) {
        this.contents = x$1;
    }

    public double ypos() {
        return this.ypos;
    }

    public void ypos_$eq(double x$1) {
        this.ypos = x$1;
    }

    public void renderBand(Band band) {
        Map cellMap = band.cells().groupBy((Function1 & Serializable)_$1 -> new HeaderId(_$1.yFrom()));
        band.rowHeader().items().foreach((Function1)(JProcedure1 & Serializable)row -> {
            double height = (double)row.length() * this.ScaleFactor();
            if (this.ypos() - height < this.FooterHeight()) {
                this.contents().close();
                this.page_$eq(new PDPage(this.PageSize()));
                this.pdf.addPage(this.page());
                this.contents_$eq(new PDPageContentStream(this.pdf, this.page()));
                this.ypos_$eq((double)this.PageSize().getHeight() - this.HeaderHeight() - this.FooterHeight());
            }
            this.ypos_$eq(this.ypos() - height);
            cellMap.get((Object)new HeaderId(row.id())).foreach((Function1)(JProcedure1 & Serializable)cells -> cells.foreach((Function1)(JProcedure1 & Serializable)cell -> {
                int xpos = BoxesRunTime.unboxToInt((Object)this.colStarts().apply(this.layout.colHeader().indexOf(cell.xFrom())));
                Option<CellType> option = CellUtil$.MODULE$.getCellType((Cell)cell);
                if (option instanceof Some) {
                    Object object = ((Some)option).value();
                    String string = CellType$.MODULE$.unapply(object == null ? null : ((CellType)object).value());
                    String string2 = CellType$.MODULE$._1$extension(string);
                    if ("basic.label".equals(string2)) {
                        this.contents().beginText();
                        this.contents().setFont((PDFont)this.DefaultFont(), 12.0f);
                        this.contents().newLineAtOffset((float)xpos, (float)this.ypos());
                        this.contents().showText(CellUtil$.MODULE$.getLabelText((Cell)cell));
                        this.contents().endText();
                        return;
                    }
                    if ("basic.field".equals(string2)) {
                        this.contents().beginText();
                        this.contents().setFont((PDFont)this.DefaultFont(), 12.0f);
                        this.contents().newLineAtOffset((float)xpos, (float)this.ypos());
                        this.contents().showText("[" + CellUtil$.MODULE$.getFieldName((Cell)cell) + "]");
                        this.contents().endText();
                        return;
                    }
                }
            }));
        });
    }

    public void positionText(PDType1Font font, int fontSize, String txt) {
    }
}

