/*
 * Decompiled with CFR 0.152.
 */
package ambience.layout.pdf;

import ambience.layout.text.Color;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.util.Matrix;

public class ContentStream {
    private final PDPageContentStream cs;
    private final float height;

    public ContentStream(PDPageContentStream cs, float height) {
        this.cs = cs;
        this.height = height;
    }

    public void addRect(float x, float y, float w, float h) {
        this.cs.addRect(x, this.height - y, w, -h);
    }

    public void stroke() {
        this.cs.stroke();
    }

    public void beginText() {
        this.cs.beginText();
    }

    public void endText() {
        this.cs.endText();
    }

    public void setFont(PDFont f, float size) {
        this.cs.setFont(f, size);
    }

    public void setColor(Color color) {
        this.cs.setStrokingColor(color.r(), color.g(), color.b());
        this.cs.setNonStrokingColor(color.r(), color.g(), color.b());
    }

    public void setTextTranslation(float x, float y) {
        this.cs.setTextMatrix(Matrix.getTranslateInstance((float)x, (float)(this.height - y)));
    }

    public void showText(String s) {
        this.cs.showText(s);
    }

    public void close() {
        this.cs.close();
    }
}

