/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.util.ArmorUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00032\u00020\u0001:\u0002\u0003\u0004B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lorg/pgpainless/decryption_verification/MessageInspector;", "", "()V", "Companion", "EncryptionInfo", "pgpainless-core"})
public final class MessageInspector {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final EncryptionInfo determineEncryptionInfoForMessage(@NotNull String message) throws PGPException, IOException {
        return Companion.determineEncryptionInfoForMessage(message);
    }

    @JvmStatic
    @NotNull
    public static final EncryptionInfo determineEncryptionInfoForMessage(@NotNull InputStream inputStream) throws PGPException, IOException {
        return Companion.determineEncryptionInfoForMessage(inputStream);
    }

    @JvmStatic
    private static final EncryptionInfo processMessage(InputStream inputStream) throws PGPException, IOException {
        return MessageInspector.Companion.processMessage(inputStream);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0003\u00a8\u0006\n"}, d2={"Lorg/pgpainless/decryption_verification/MessageInspector$Companion;", "", "()V", "determineEncryptionInfoForMessage", "Lorg/pgpainless/decryption_verification/MessageInspector$EncryptionInfo;", "inputStream", "Ljava/io/InputStream;", "message", "", "processMessage", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nMessageInspector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageInspector.kt\norg/pgpainless/decryption_verification/MessageInspector$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final EncryptionInfo determineEncryptionInfoForMessage(@NotNull String message) throws PGPException, IOException {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            String string = message;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            return this.determineEncryptionInfoForMessage(new ByteArrayInputStream(byArray));
        }

        @JvmStatic
        @NotNull
        public final EncryptionInfo determineEncryptionInfoForMessage(@NotNull InputStream inputStream) throws PGPException, IOException {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            return this.processMessage(ArmorUtils.Companion.getDecoderStream(inputStream));
        }

        @JvmStatic
        private final EncryptionInfo processMessage(InputStream inputStream) throws PGPException, IOException {
            PGPObjectFactory objectFactory = ImplementationFactory.Companion.getInstance().getPGPObjectFactory(inputStream);
            Object n = null;
            while (true) {
                Object next;
                Object object;
                Object it = object = objectFactory.nextObject();
                boolean bl = false;
                n = it;
                if (object == null) break;
                Intrinsics.checkNotNull((Object)n);
                if (next instanceof PGPOnePassSignatureList) {
                    if (((PGPOnePassSignatureList)next).isEmpty()) continue;
                    return new EncryptionInfo(CollectionsKt.emptyList(), false, true);
                }
                if (next instanceof PGPEncryptedDataList) {
                    boolean isPassphraseEncrypted = false;
                    List keyIds = new ArrayList();
                    for (PGPEncryptedData encryptedData : (PGPEncryptedDataList)next) {
                        if (encryptedData instanceof PGPPublicKeyEncryptedData) {
                            keyIds.add(((PGPPublicKeyEncryptedData)encryptedData).getKeyID());
                            continue;
                        }
                        if (!(encryptedData instanceof PGPPBEEncryptedData)) continue;
                        isPassphraseEncrypted = true;
                    }
                    return new EncryptionInfo(keyIds, isPassphraseEncrypted, false);
                }
                if (next instanceof PGPCompressedData) {
                    ImplementationFactory implementationFactory = ImplementationFactory.Companion.getInstance();
                    InputStream inputStream2 = PGPUtil.getDecoderStream((InputStream)((PGPCompressedData)next).getDataStream());
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getDecoderStream(next.dataStream)");
                    objectFactory = implementationFactory.getPGPObjectFactory(inputStream2);
                    continue;
                }
                if (next instanceof PGPLiteralData) break;
            }
            return new EncryptionInfo(CollectionsKt.emptyList(), false, false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J-\u0010\u0010\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/pgpainless/decryption_verification/MessageInspector$EncryptionInfo;", "", "keyIds", "", "", "isPassphraseEncrypted", "", "isSignedOnly", "(Ljava/util/List;ZZ)V", "isEncrypted", "()Z", "getKeyIds", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "pgpainless-core"})
    public static final class EncryptionInfo {
        @NotNull
        private final List<Long> keyIds;
        private final boolean isPassphraseEncrypted;
        private final boolean isSignedOnly;

        public EncryptionInfo(@NotNull List<Long> keyIds, boolean isPassphraseEncrypted, boolean isSignedOnly) {
            Intrinsics.checkNotNullParameter(keyIds, (String)"keyIds");
            this.keyIds = keyIds;
            this.isPassphraseEncrypted = isPassphraseEncrypted;
            this.isSignedOnly = isSignedOnly;
        }

        @NotNull
        public final List<Long> getKeyIds() {
            return this.keyIds;
        }

        public final boolean isPassphraseEncrypted() {
            return this.isPassphraseEncrypted;
        }

        public final boolean isSignedOnly() {
            return this.isSignedOnly;
        }

        public final boolean isEncrypted() {
            return this.isPassphraseEncrypted || !((Collection)this.keyIds).isEmpty();
        }

        @NotNull
        public final List<Long> component1() {
            return this.keyIds;
        }

        public final boolean component2() {
            return this.isPassphraseEncrypted;
        }

        public final boolean component3() {
            return this.isSignedOnly;
        }

        @NotNull
        public final EncryptionInfo copy(@NotNull List<Long> keyIds, boolean isPassphraseEncrypted, boolean isSignedOnly) {
            Intrinsics.checkNotNullParameter(keyIds, (String)"keyIds");
            return new EncryptionInfo(keyIds, isPassphraseEncrypted, isSignedOnly);
        }

        public static /* synthetic */ EncryptionInfo copy$default(EncryptionInfo encryptionInfo, List list, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                list = encryptionInfo.keyIds;
            }
            if ((n & 2) != 0) {
                bl = encryptionInfo.isPassphraseEncrypted;
            }
            if ((n & 4) != 0) {
                bl2 = encryptionInfo.isSignedOnly;
            }
            return encryptionInfo.copy(list, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "EncryptionInfo(keyIds=" + this.keyIds + ", isPassphraseEncrypted=" + this.isPassphraseEncrypted + ", isSignedOnly=" + this.isSignedOnly + ')';
        }

        public int hashCode() {
            int result = ((Object)this.keyIds).hashCode();
            int n = this.isPassphraseEncrypted ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n2 = this.isSignedOnly ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EncryptionInfo)) {
                return false;
            }
            EncryptionInfo encryptionInfo = (EncryptionInfo)other;
            if (!Intrinsics.areEqual(this.keyIds, encryptionInfo.keyIds)) {
                return false;
            }
            if (this.isPassphraseEncrypted != encryptionInfo.isPassphraseEncrypted) {
                return false;
            }
            return this.isSignedOnly == encryptionInfo.isSignedOnly;
        }
    }
}

