/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.builder;

import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.builder.AbstractSignatureBuilder;
import org.pgpainless.signature.subpackets.BaseSignatureSubpackets;
import org.pgpainless.signature.subpackets.CertificationSubpackets;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006\u001d"}, d2={"Lorg/pgpainless/signature/builder/ThirdPartyDirectKeySignatureBuilder;", "Lorg/pgpainless/signature/builder/AbstractSignatureBuilder;", "signingKey", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "protector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "(Lorg/bouncycastle/openpgp/PGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;)V", "archetypeSignature", "Lorg/bouncycastle/openpgp/PGPSignature;", "(Lorg/bouncycastle/openpgp/PGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;Lorg/bouncycastle/openpgp/PGPSignature;)V", "hashedSubpackets", "Lorg/pgpainless/signature/subpackets/CertificationSubpackets;", "getHashedSubpackets", "()Lorg/pgpainless/signature/subpackets/CertificationSubpackets;", "signatureTypePredicate", "Ljava/util/function/Predicate;", "Lorg/pgpainless/algorithm/SignatureType;", "getSignatureTypePredicate", "()Ljava/util/function/Predicate;", "unhashedSubpackets", "getUnhashedSubpackets", "applyCallback", "callback", "Lorg/pgpainless/signature/subpackets/CertificationSubpackets$Callback;", "build", "certifiedKey", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "certificate", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "pgpainless-core"})
public final class ThirdPartyDirectKeySignatureBuilder
extends AbstractSignatureBuilder<ThirdPartyDirectKeySignatureBuilder> {
    @NotNull
    private final CertificationSubpackets hashedSubpackets;
    @NotNull
    private final CertificationSubpackets unhashedSubpackets;

    @Override
    @NotNull
    protected Predicate<SignatureType> getSignatureTypePredicate() {
        return ThirdPartyDirectKeySignatureBuilder::_get_signatureTypePredicate_$lambda$0;
    }

    public ThirdPartyDirectKeySignatureBuilder(@NotNull PGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
        super(SignatureType.DIRECT_KEY, signingKey, protector);
        this.hashedSubpackets = this.get_hashedSubpackets();
        this.unhashedSubpackets = this.get_unhashedSubpackets();
    }

    public ThirdPartyDirectKeySignatureBuilder(@NotNull PGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector, @NotNull PGPSignature archetypeSignature) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
        Intrinsics.checkNotNullParameter((Object)archetypeSignature, (String)"archetypeSignature");
        super(signingKey, protector, archetypeSignature);
        this.hashedSubpackets = this.get_hashedSubpackets();
        this.unhashedSubpackets = this.get_unhashedSubpackets();
    }

    @NotNull
    public final CertificationSubpackets getHashedSubpackets() {
        return this.hashedSubpackets;
    }

    @NotNull
    public final CertificationSubpackets getUnhashedSubpackets() {
        return this.unhashedSubpackets;
    }

    @NotNull
    public final ThirdPartyDirectKeySignatureBuilder applyCallback(@Nullable CertificationSubpackets.Callback callback2) {
        ThirdPartyDirectKeySignatureBuilder thirdPartyDirectKeySignatureBuilder;
        block0: {
            ThirdPartyDirectKeySignatureBuilder $this$applyCallback_u24lambda_u242 = thirdPartyDirectKeySignatureBuilder = this;
            boolean bl = false;
            CertificationSubpackets.Callback callback3 = callback2;
            if (callback3 == null) break block0;
            CertificationSubpackets.Callback it = callback3;
            boolean bl2 = false;
            it.modifyHashedSubpackets((BaseSignatureSubpackets)$this$applyCallback_u24lambda_u242.hashedSubpackets);
            it.modifyUnhashedSubpackets((BaseSignatureSubpackets)$this$applyCallback_u24lambda_u242.unhashedSubpackets);
        }
        return thirdPartyDirectKeySignatureBuilder;
    }

    @NotNull
    public final PGPSignature build(@NotNull PGPPublicKeyRing certificate) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        PGPPublicKey pGPPublicKey = certificate.getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"certificate.publicKey");
        return this.build(pGPPublicKey);
    }

    @NotNull
    public final PGPSignature build(@NotNull PGPPublicKey certifiedKey) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)certifiedKey, (String)"certifiedKey");
        PGPSignature pGPSignature = this.buildAndInitSignatureGenerator().generateCertification(certifiedKey);
        Intrinsics.checkNotNullExpressionValue((Object)pGPSignature, (String)"buildAndInitSignatureGen\u2026rtification(certifiedKey)");
        return pGPSignature;
    }

    private static final boolean _get_signatureTypePredicate_$lambda$0(SignatureType it) {
        return it == SignatureType.DIRECT_KEY;
    }
}

