/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.consumer;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import openpgp.LongExtensionsKt;
import org.bouncycastle.bcpg.sig.KeyFlags;
import org.bouncycastle.bcpg.sig.SignerUserID;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.bouncycastle.extensions.PGPSignatureExtensionsKt;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.consumer.OnePassSignatureCheck;
import org.pgpainless.signature.consumer.SignatureCreationDateComparator;
import org.pgpainless.signature.consumer.SignatureValidityComparator;
import org.pgpainless.signature.consumer.SignatureVerifier;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/pgpainless/signature/consumer/CertificateValidator;", "", "()V", "Companion", "pgpainless-core"})
public final class CertificateValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateValidator.class);

    @JvmStatic
    public static final boolean validateCertificate(@NotNull PGPSignature signature, @NotNull PGPPublicKeyRing signingKeyRing, @NotNull Policy policy) throws SignatureValidationException {
        return Companion.validateCertificate(signature, signingKeyRing, policy);
    }

    @JvmStatic
    public static final boolean validateCertificateAndVerifyUninitializedSignature(@NotNull PGPSignature signature, @NotNull InputStream signedData, @NotNull PGPPublicKeyRing signingKeyRing, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
        return Companion.validateCertificateAndVerifyUninitializedSignature(signature, signedData, signingKeyRing, policy, referenceTime);
    }

    @JvmStatic
    public static final boolean validateCertificateAndVerifyInitializedSignature(@NotNull PGPSignature signature, @NotNull PGPPublicKeyRing verificationKeys, @NotNull Policy policy) throws SignatureValidationException {
        return Companion.validateCertificateAndVerifyInitializedSignature(signature, verificationKeys, policy);
    }

    @JvmStatic
    public static final boolean validateCertificateAndVerifyOnePassSignature(@NotNull OnePassSignatureCheck onePassSignature, @NotNull Policy policy) throws SignatureValidationException {
        return Companion.validateCertificateAndVerifyOnePassSignature(onePassSignature, policy);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007J \u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0007J2\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0007R\u001e\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\u0019"}, d2={"Lorg/pgpainless/signature/consumer/CertificateValidator$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOGGER$annotations", "validateCertificate", "", "signature", "Lorg/bouncycastle/openpgp/PGPSignature;", "signingKeyRing", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "policy", "Lorg/pgpainless/policy/Policy;", "validateCertificateAndVerifyInitializedSignature", "verificationKeys", "validateCertificateAndVerifyOnePassSignature", "onePassSignature", "Lorg/pgpainless/signature/consumer/OnePassSignatureCheck;", "validateCertificateAndVerifyUninitializedSignature", "signedData", "Ljava/io/InputStream;", "referenceTime", "Ljava/util/Date;", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nCertificateValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificateValidator.kt\norg/pgpainless/signature/consumer/CertificateValidator$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,316:1\n1295#2,2:317\n1295#2,2:319\n1295#2,2:322\n1295#2,2:335\n1295#2,2:337\n1855#3:321\n1856#3:325\n1747#3,3:331\n1#4:324\n187#5,3:326\n553#5,2:329\n555#5:334\n*S KotlinDebug\n*F\n+ 1 CertificateValidator.kt\norg/pgpainless/signature/consumer/CertificateValidator$Companion\n*L\n69#1:317,2\n86#1:319,2\n114#1:322,2\n189#1:335,2\n204#1:337,2\n108#1:321\n108#1:325\n174#1:331,3\n138#1:326,3\n173#1:329,2\n173#1:334\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLOGGER$annotations() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final boolean validateCertificate(@NotNull PGPSignature signature, @NotNull PGPPublicKeyRing signingKeyRing, @NotNull Policy policy) throws SignatureValidationException {
            Map.Entry entry;
            Map userIdSignatures;
            Map rejections;
            List directKeyAndRevSigs;
            PGPPublicKey primaryKey;
            PGPPublicKey signingSubkey;
            block47: {
                SignerUserID it;
                block49: {
                    block48: {
                        boolean isAnyUserIdValid;
                        boolean hasAnyUserIds;
                        block44: {
                            boolean bl;
                            PGPSignature it2;
                            Sequence $this$forEach$iv;
                            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                            Intrinsics.checkNotNullParameter((Object)signingKeyRing, (String)"signingKeyRing");
                            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
                            PGPPublicKey pGPPublicKey = signingKeyRing.getPublicKey(PGPSignatureExtensionsKt.getIssuerKeyId(signature));
                            if (pGPPublicKey == null) {
                                throw new SignatureValidationException("Provided key ring does not contain a subkey with id " + LongExtensionsKt.openPgpKeyId(PGPSignatureExtensionsKt.getIssuerKeyId(signature)) + '.');
                            }
                            signingSubkey = pGPPublicKey;
                            PGPPublicKey pGPPublicKey2 = signingKeyRing.getPublicKey();
                            Intrinsics.checkNotNull((Object)pGPPublicKey2);
                            primaryKey = pGPPublicKey2;
                            directKeyAndRevSigs = new ArrayList();
                            rejections = new LinkedHashMap();
                            Iterator iterator = primaryKey.getSignaturesOfType(SignatureType.KEY_REVOCATION.getCode());
                            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"primaryKey\n             \u2026Type.KEY_REVOCATION.code)");
                            Sequence sequence = SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)((Function1)new Function1<PGPSignature, Boolean>(primaryKey){
                                final /* synthetic */ PGPPublicKey $primaryKey;
                                {
                                    this.$primaryKey = $primaryKey;
                                    super(1);
                                }

                                @NotNull
                                public final Boolean invoke(PGPSignature it) {
                                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                    return PGPSignatureExtensionsKt.getIssuerKeyId(it) == this.$primaryKey.getKeyID();
                                }
                            }));
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                it2 = (PGPSignature)element$iv;
                                boolean bl2 = false;
                                try {
                                    Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                                    Date date = signature.getCreationTime();
                                    Intrinsics.checkNotNullExpressionValue((Object)date, (String)"signature.creationTime");
                                    if (!SignatureVerifier.Companion.verifyKeyRevocationSignature(it2, primaryKey, policy, date)) continue;
                                    directKeyAndRevSigs.add(it2);
                                }
                                catch (SignatureValidationException e) {
                                    Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                                    rejections.put(it2, e);
                                    LOGGER.debug("Rejecting key revocation signature: " + e.getMessage(), (Throwable)((Object)e));
                                }
                            }
                            Iterator iterator2 = primaryKey.getSignaturesOfType(SignatureType.DIRECT_KEY.getCode());
                            Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"primaryKey\n             \u2026tureType.DIRECT_KEY.code)");
                            $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)iterator2), (Function1)((Function1)new Function1<PGPSignature, Boolean>(primaryKey){
                                final /* synthetic */ PGPPublicKey $primaryKey;
                                {
                                    this.$primaryKey = $primaryKey;
                                    super(1);
                                }

                                @NotNull
                                public final Boolean invoke(PGPSignature it) {
                                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                    return PGPSignatureExtensionsKt.getIssuerKeyId(it) == this.$primaryKey.getKeyID();
                                }
                            }));
                            $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                it2 = (PGPSignature)element$iv;
                                boolean bl3 = false;
                                try {
                                    Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                                    Date date = signature.getCreationTime();
                                    Intrinsics.checkNotNullExpressionValue((Object)date, (String)"signature.creationTime");
                                    if (!SignatureVerifier.Companion.verifyDirectKeySignature(it2, primaryKey, policy, date)) continue;
                                    directKeyAndRevSigs.add(it2);
                                }
                                catch (SignatureValidationException e) {
                                    Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                                    rejections.put(it2, e);
                                    LOGGER.debug("Rejecting key signature: " + e.getMessage() + ", e");
                                }
                            }
                            CollectionsKt.sortWith((List)directKeyAndRevSigs, (Comparator)new SignatureValidityComparator(SignatureCreationDateComparator.Order.NEW_TO_OLD));
                            if (!((Collection)directKeyAndRevSigs).isEmpty() && ((PGPSignature)directKeyAndRevSigs.get(0)).getSignatureType() == SignatureType.KEY_REVOCATION.getCode()) {
                                throw new SignatureValidationException("Primary key has been revoked.");
                            }
                            userIdSignatures = new LinkedHashMap();
                            Iterable $this$forEach$iv2 = KeyRingUtils.Companion.getUserIdsIgnoringInvalidUTF8(primaryKey);
                            boolean $i$f$forEach2 = false;
                            for (Object element$iv : $this$forEach$iv2) {
                                void $this$forEach$iv3;
                                List list;
                                String userId = (String)element$iv;
                                boolean bl4 = false;
                                List $this$validateCertificate_u24lambda_u245_u24lambda_u243 = list = CollectionsKt.createListBuilder();
                                boolean bl5 = false;
                                Iterator iterator3 = primaryKey.getSignaturesForID(userId);
                                Intrinsics.checkNotNullExpressionValue((Object)iterator3, (String)"primaryKey\n             \u2026etSignaturesForID(userId)");
                                Sequence sequence2 = SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)iterator3), (Function1)((Function1)new Function1<PGPSignature, Boolean>(primaryKey){
                                    final /* synthetic */ PGPPublicKey $primaryKey;
                                    {
                                        this.$primaryKey = $primaryKey;
                                        super(1);
                                    }

                                    @NotNull
                                    public final Boolean invoke(PGPSignature it) {
                                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                        return PGPSignatureExtensionsKt.getIssuerKeyId(it) == this.$primaryKey.getKeyID();
                                    }
                                }));
                                boolean $i$f$forEach3 = false;
                                for (Object element$iv2 : $this$forEach$iv3) {
                                    PGPSignature uidSig = (PGPSignature)element$iv2;
                                    boolean bl6 = false;
                                    try {
                                        CharSequence charSequence = userId;
                                        Intrinsics.checkNotNullExpressionValue((Object)uidSig, (String)"uidSig");
                                        Date date = signature.getCreationTime();
                                        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"signature.creationTime");
                                        if (!SignatureVerifier.Companion.verifySignatureOverUserId(charSequence, uidSig, primaryKey, policy, date)) continue;
                                        $this$validateCertificate_u24lambda_u245_u24lambda_u243.add(uidSig);
                                    }
                                    catch (SignatureValidationException e) {
                                        Intrinsics.checkNotNullExpressionValue((Object)uidSig, (String)"uidSig");
                                        rejections.put(uidSig, e);
                                        LOGGER.debug("Rejecting user-id signature: " + e.getMessage(), (Throwable)((Object)e));
                                    }
                                }
                                List it3 = CollectionsKt.sortedWith((Iterable)CollectionsKt.build((List)list), (Comparator)new SignatureValidityComparator(SignatureCreationDateComparator.Order.NEW_TO_OLD));
                                boolean bl7 = false;
                                userIdSignatures.put(userId, it3);
                            }
                            hasAnyUserIds = !userIdSignatures.isEmpty();
                            Map $this$any$iv = userIdSignatures;
                            boolean $i$f$any = false;
                            if ($this$any$iv.isEmpty()) {
                                bl = false;
                            } else {
                                Iterator userId = $this$any$iv.entrySet().iterator();
                                while (userId.hasNext()) {
                                    Map.Entry element$iv;
                                    entry = element$iv = userId.next();
                                    boolean bl8 = false;
                                    boolean bl9 = !((Collection)entry.getValue()).isEmpty() && ((PGPSignature)((List)entry.getValue()).get(0)).getSignatureType() != SignatureType.CERTIFICATION_REVOCATION.getCode();
                                    if (!bl9) continue;
                                    bl = true;
                                    break block44;
                                }
                                bl = isAnyUserIdValid = false;
                            }
                        }
                        if (hasAnyUserIds && !isAnyUserIdValid) {
                            throw new SignatureValidationException("No valid user-id found.", rejections);
                        }
                        if (policy.getSignerUserIdValidationLevel() != Policy.SignerUserIdValidationLevel.STRICT) break block47;
                        SignerUserID signerUserID = SignatureSubpacketsUtil.Companion.getSignerUserID(signature);
                        if (signerUserID == null) break block47;
                        it = signerUserID;
                        boolean bl = false;
                        if (userIdSignatures.get(it.getID()) == null) break block48;
                        Object v = userIdSignatures.get(it.getID());
                        Intrinsics.checkNotNull(v);
                        if (!((List)v).isEmpty()) break block49;
                    }
                    throw new SignatureValidationException("Signature was allegedly made by user-id '" + it.getID() + "', but we have no valid signatures for that on the certificate.");
                }
                Object v = userIdSignatures.get(it.getID());
                Intrinsics.checkNotNull(v);
                if (((PGPSignature)((List)v).get(0)).getSignatureType() == SignatureType.CERTIFICATION_REVOCATION.getCode()) {
                    throw new SignatureValidationException("Signature was made with user-id '" + it.getID() + "' which is revoked.");
                }
            }
            if (signingSubkey.getKeyID() == primaryKey.getKeyID()) {
                boolean bl;
                block46: {
                    if (!((Collection)directKeyAndRevSigs).isEmpty()) {
                        Object e = directKeyAndRevSigs.get(0);
                        Intrinsics.checkNotNull(e);
                        PGPSignature directKeySig = (PGPSignature)e;
                        KeyFlags flags = SignatureSubpacketsUtil.Companion.getKeyFlags(directKeySig);
                        if (flags != null && KeyFlag.Companion.hasKeyFlag(flags.getFlags(), KeyFlag.SIGN_DATA)) {
                            return true;
                        }
                    }
                    Map $this$none$iv = userIdSignatures;
                    boolean $i$f$none = false;
                    if ($this$none$iv.isEmpty()) {
                        bl = true;
                    } else {
                        for (Map.Entry element$iv : $this$none$iv.entrySet()) {
                            boolean bl10;
                            block45: {
                                entry = element$iv;
                                boolean bl11 = false;
                                List sigs = (List)entry.getValue();
                                Iterable $this$any$iv = sigs;
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl10 = false;
                                } else {
                                    for (Object element$iv2 : $this$any$iv) {
                                        boolean bl12;
                                        PGPSignature it = (PGPSignature)element$iv2;
                                        boolean bl13 = false;
                                        if (SignatureSubpacketsUtil.Companion.getKeyFlags(it) != null) {
                                            KeyFlags f;
                                            boolean bl14 = false;
                                            bl12 = KeyFlag.Companion.hasKeyFlag(f.getFlags(), KeyFlag.SIGN_DATA);
                                        } else {
                                            bl12 = false;
                                        }
                                        if (!bl12) continue;
                                        bl10 = true;
                                        break block45;
                                    }
                                    bl10 = false;
                                }
                            }
                            if (!bl10) continue;
                            bl = false;
                            break block46;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    throw new SignatureValidationException("Signature was generated by non-signing key.");
                }
            } else {
                Sequence $this$forEach$iv;
                List subkeySigs = new ArrayList();
                Iterator iterator = signingSubkey.getSignaturesOfType(SignatureType.SUBKEY_REVOCATION.getCode());
                Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"signingSubkey\n          \u2026e.SUBKEY_REVOCATION.code)");
                Sequence $i$f$none = SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)((Function1)new Function1<PGPSignature, Boolean>(primaryKey){
                    final /* synthetic */ PGPPublicKey $primaryKey;
                    {
                        this.$primaryKey = $primaryKey;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(PGPSignature it) {
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        return PGPSignatureExtensionsKt.getIssuerKeyId(it) == this.$primaryKey.getKeyID();
                    }
                }));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PGPSignature it = (PGPSignature)element$iv;
                    boolean bl = false;
                    try {
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        Date date = signature.getCreationTime();
                        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"signature.creationTime");
                        if (!SignatureVerifier.Companion.verifySubkeyBindingRevocation(it, primaryKey, signingSubkey, policy, date)) continue;
                        subkeySigs.add(it);
                    }
                    catch (SignatureValidationException e) {
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        rejections.put(it, e);
                        LOGGER.debug("Rejecting subkey revocation signature: " + e.getMessage(), (Throwable)((Object)e));
                    }
                }
                Iterator iterator4 = signingSubkey.getSignaturesOfType(SignatureType.SUBKEY_BINDING.getCode());
                Intrinsics.checkNotNullExpressionValue((Object)iterator4, (String)"signingSubkey\n          \u2026Type.SUBKEY_BINDING.code)");
                $this$forEach$iv = SequencesKt.asSequence((Iterator)iterator4);
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PGPSignature it = (PGPSignature)element$iv;
                    boolean bl = false;
                    try {
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        Date date = signature.getCreationTime();
                        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"signature.creationTime");
                        if (!SignatureVerifier.Companion.verifySubkeyBindingSignature(it, primaryKey, signingSubkey, policy, date)) continue;
                        subkeySigs.add(it);
                    }
                    catch (SignatureValidationException e) {
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        rejections.put(it, e);
                        LOGGER.debug("Rejecting subkey binding signature: " + e.getMessage(), (Throwable)((Object)e));
                    }
                }
                CollectionsKt.sortWith((List)subkeySigs, (Comparator)new SignatureValidityComparator(SignatureCreationDateComparator.Order.NEW_TO_OLD));
                if (subkeySigs.isEmpty()) {
                    throw new SignatureValidationException("Subkey is not bound.", rejections);
                }
                if (((PGPSignature)subkeySigs.get(0)).getSignatureType() == SignatureType.SUBKEY_REVOCATION.getCode()) {
                    throw new SignatureValidationException("Subkey is revoked.");
                }
                KeyFlags keyFlags = SignatureSubpacketsUtil.Companion.getKeyFlags((PGPSignature)subkeySigs.get(0));
                if (keyFlags == null || !KeyFlag.Companion.hasKeyFlag(keyFlags.getFlags(), KeyFlag.SIGN_DATA)) {
                    throw new SignatureValidationException("Signature was made by key which is not capable of signing (no keyflag).");
                }
            }
            return true;
        }

        public static /* synthetic */ boolean validateCertificate$default(Companion companion, PGPSignature pGPSignature, PGPPublicKeyRing pGPPublicKeyRing, Policy policy, int n, Object object) throws SignatureValidationException {
            if ((n & 4) != 0) {
                policy = PGPainless.Companion.getPolicy();
            }
            return companion.validateCertificate(pGPSignature, pGPPublicKeyRing, policy);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean validateCertificateAndVerifyUninitializedSignature(@NotNull PGPSignature signature, @NotNull InputStream signedData, @NotNull PGPPublicKeyRing signingKeyRing, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)signedData, (String)"signedData");
            Intrinsics.checkNotNullParameter((Object)signingKeyRing, (String)"signingKeyRing");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            if (!this.validateCertificate(signature, signingKeyRing, policy)) return false;
            PGPPublicKey pGPPublicKey = signingKeyRing.getPublicKey(PGPSignatureExtensionsKt.getIssuerKeyId(signature));
            Intrinsics.checkNotNull((Object)pGPPublicKey);
            if (!SignatureVerifier.Companion.verifyUninitializedSignature(signature, signedData, pGPPublicKey, policy, referenceTime)) return false;
            return true;
        }

        public static /* synthetic */ boolean validateCertificateAndVerifyUninitializedSignature$default(Companion companion, PGPSignature pGPSignature, InputStream inputStream, PGPPublicKeyRing pGPPublicKeyRing, Policy policy, Date date, int n, Object object) throws SignatureValidationException {
            if ((n & 0x10) != 0) {
                Date date2 = pGPSignature.getCreationTime();
                Intrinsics.checkNotNullExpressionValue((Object)date2, (String)"signature.creationTime");
                date = date2;
            }
            return companion.validateCertificateAndVerifyUninitializedSignature(pGPSignature, inputStream, pGPPublicKeyRing, policy, date);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean validateCertificateAndVerifyInitializedSignature(@NotNull PGPSignature signature, @NotNull PGPPublicKeyRing verificationKeys, @NotNull Policy policy) throws SignatureValidationException {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)verificationKeys, (String)"verificationKeys");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            if (!this.validateCertificate(signature, verificationKeys, policy)) return false;
            PGPPublicKey pGPPublicKey = verificationKeys.getPublicKey(PGPSignatureExtensionsKt.getIssuerKeyId(signature));
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"verificationKeys.getPubl\u2026ey(signature.issuerKeyId)");
            Date date = signature.getCreationTime();
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"signature.creationTime");
            if (!SignatureVerifier.Companion.verifyInitializedSignature(signature, pGPPublicKey, policy, date)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean validateCertificateAndVerifyOnePassSignature(@NotNull OnePassSignatureCheck onePassSignature, @NotNull Policy policy) throws SignatureValidationException {
            Intrinsics.checkNotNullParameter((Object)onePassSignature, (String)"onePassSignature");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            PGPSignature pGPSignature = onePassSignature.getSignature();
            Intrinsics.checkNotNull((Object)pGPSignature);
            if (!this.validateCertificate(pGPSignature, onePassSignature.getVerificationKeys(), policy)) return false;
            PGPSignature pGPSignature2 = onePassSignature.getSignature();
            Intrinsics.checkNotNull((Object)pGPSignature2);
            PGPPublicKeyRing pGPPublicKeyRing = onePassSignature.getVerificationKeys();
            PGPSignature pGPSignature3 = onePassSignature.getSignature();
            Intrinsics.checkNotNull((Object)pGPSignature3);
            PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey(PGPSignatureExtensionsKt.getIssuerKeyId(pGPSignature3));
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"onePassSignature.verific\u2026.signature!!.issuerKeyId)");
            if (!SignatureVerifier.Companion.verifyOnePassSignature(pGPSignature2, pGPPublicKey, onePassSignature, policy)) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

