/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.consumer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import openpgp.LongExtensionsKt;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.consumer.OnePassSignatureCheck;
import org.pgpainless.signature.consumer.SignatureValidator;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/pgpainless/signature/consumer/SignatureVerifier;", "", "()V", "Companion", "pgpainless-core"})
public final class SignatureVerifier {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    public static final boolean verifySignatureOverUserId(@NotNull CharSequence userId, @NotNull PGPSignature signature, @NotNull PGPPublicKey signingKey, @NotNull PGPPublicKey keyWithUserId, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
        return Companion.verifySignatureOverUserId(userId, signature, signingKey, keyWithUserId, policy, referenceTime);
    }

    @JvmStatic
    public static final boolean verifyUserIdCertification(@NotNull CharSequence userId, @NotNull PGPSignature signature, @NotNull PGPPublicKey primaryKey, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
        return Companion.verifyUserIdCertification(userId, signature, primaryKey, policy, referenceTime);
    }

    @JvmStatic
    public static final boolean verifyUserIdCertification(@NotNull CharSequence userId, @NotNull PGPSignature signature, @NotNull PGPPublicKey signingKey, @NotNull PGPPublicKey keyWithUserId, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
        return Companion.verifyUserIdCertification(userId, signature, signingKey, keyWithUserId, policy, referenceTime);
    }

    @JvmStatic
    public static final boolean verifyUserIdRevocation(@NotNull CharSequence userId, @NotNull PGPSignature signature, @NotNull PGPPublicKey primaryKey, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
        return Companion.verifyUserIdRevocation(userId, signature, primaryKey, policy, referenceTime);
    }

    @JvmStatic
    public static final boolean verifyUserIdRevocation(@NotNull CharSequence userId, @NotNull PGPSignature signature, @NotNull PGPPublicKey signingKey, @NotNull PGPPublicKey keyWithUserId, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
        return Companion.verifyUserIdRevocation(userId, signature, signingKey, keyWithUserId, policy, referenceTime);
    }

    @JvmStatic
    public static final boolean verifyUserAttributesCertification(@NotNull PGPUserAttributeSubpacketVector userAttributes, @NotNull PGPSignature signature, @NotNull PGPPublicKey primaryKey, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
        return Companion.verifyUserAttributesCertification(userAttributes, signature, primaryKey, policy, referenceTime);
    }

    @JvmStatic
    public static final boolean verifyUserAttributesCertification(@NotNull PGPUserAttributeSubpacketVector userAttributes, @NotNull PGPSignature signature, @NotNull PGPPublicKey signingKey, @NotNull PGPPublicKey keyWithAttributes, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
        return Companion.verifyUserAttributesCertification(userAttributes, signature, signingKey, keyWithAttributes, policy, referenceTime);
    }

    @JvmStatic
    public static final boolean verifyUserAttributesRevocation(@NotNull PGPUserAttributeSubpacketVector userAttributes, @NotNull PGPSignature signature, @NotNull PGPPublicKey primaryKey, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
        return Companion.verifyUserAttributesRevocation(userAttributes, signature, primaryKey, policy, referenceTime);
    }

    @JvmStatic
    public static final boolean verifyUserAttributesRevocation(@NotNull PGPUserAttributeSubpacketVector userAttributes, @NotNull PGPSignature signature, @NotNull PGPPublicKey signingKey, @NotNull PGPPublicKey keyWithAttributes, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
        return Companion.verifyUserAttributesRevocation(userAttributes, signature, signingKey, keyWithAttributes, policy, referenceTime);
    }

    @JvmStatic
    public static final boolean verifySubkeyBindingSignature(@NotNull PGPSignature signature, @NotNull PGPPublicKey primaryKey, @NotNull PGPPublicKey subkey, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
        return Companion.verifySubkeyBindingSignature(signature, primaryKey, subkey, policy, referenceTime);
    }

    @JvmStatic
    public static final boolean verifySubkeyBindingRevocation(@NotNull PGPSignature signature, @NotNull PGPPublicKey primaryKey, @NotNull PGPPublicKey subkey, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
        return Companion.verifySubkeyBindingRevocation(signature, primaryKey, subkey, policy, referenceTime);
    }

    @JvmStatic
    public static final boolean verifyDirectKeySignature(@NotNull PGPSignature signature, @NotNull PGPPublicKey primaryKey, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
        return Companion.verifyDirectKeySignature(signature, primaryKey, policy, referenceTime);
    }

    @JvmStatic
    public static final boolean verifyDirectKeySignature(@NotNull PGPSignature signature, @NotNull PGPPublicKey signingKey, @NotNull PGPPublicKey signedKey, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
        return Companion.verifyDirectKeySignature(signature, signingKey, signedKey, policy, referenceTime);
    }

    @JvmStatic
    public static final boolean verifyKeyRevocationSignature(@NotNull PGPSignature signature, @NotNull PGPPublicKey primaryKey, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
        return Companion.verifyKeyRevocationSignature(signature, primaryKey, policy, referenceTime);
    }

    @JvmStatic
    public static final boolean verifyUninitializedSignature(@NotNull PGPSignature signature, @NotNull InputStream signedData, @NotNull PGPPublicKey signingKey, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
        return Companion.verifyUninitializedSignature(signature, signedData, signingKey, policy, referenceTime);
    }

    @JvmStatic
    public static final void initializeSignatureAndUpdateWithSignedData(@NotNull PGPSignature signature, @NotNull InputStream signedData, @NotNull PGPPublicKey signingKey) throws SignatureValidationException {
        Companion.initializeSignatureAndUpdateWithSignedData(signature, signedData, signingKey);
    }

    @JvmStatic
    public static final boolean verifyInitializedSignature(@NotNull PGPSignature signature, @NotNull PGPPublicKey signingKey, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
        return Companion.verifyInitializedSignature(signature, signingKey, policy, referenceTime);
    }

    @JvmStatic
    public static final boolean verifyOnePassSignature(@NotNull PGPSignature signature, @NotNull PGPPublicKey signingKey, @NotNull OnePassSignatureCheck onePassSignature, @NotNull Policy policy) throws SignatureValidationException {
        return Companion.verifyOnePassSignature(signature, signingKey, onePassSignature, policy);
    }

    @JvmStatic
    public static final boolean verifySignatureOverUserId(@NotNull CharSequence userId, @NotNull PGPSignature signature, @NotNull PGPPublicKey primaryKey, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
        return Companion.verifySignatureOverUserId(userId, signature, primaryKey, policy, referenceTime);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J(\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J(\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J(\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J8\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J0\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J0\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J0\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J0\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J8\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J0\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J8\u0010$\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J0\u0010$\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J8\u0010%\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J0\u0010%\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J8\u0010&\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J0\u0010&\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u00a8\u0006'"}, d2={"Lorg/pgpainless/signature/consumer/SignatureVerifier$Companion;", "", "()V", "initializeSignatureAndUpdateWithSignedData", "", "signature", "Lorg/bouncycastle/openpgp/PGPSignature;", "signedData", "Ljava/io/InputStream;", "signingKey", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "verifyDirectKeySignature", "", "signedKey", "policy", "Lorg/pgpainless/policy/Policy;", "referenceTime", "Ljava/util/Date;", "primaryKey", "verifyInitializedSignature", "verifyKeyRevocationSignature", "verifyOnePassSignature", "onePassSignature", "Lorg/pgpainless/signature/consumer/OnePassSignatureCheck;", "verifySignatureOverUserId", "userId", "", "keyWithUserId", "verifySubkeyBindingRevocation", "subkey", "verifySubkeyBindingSignature", "verifyUninitializedSignature", "verifyUserAttributesCertification", "userAttributes", "Lorg/bouncycastle/openpgp/PGPUserAttributeSubpacketVector;", "keyWithAttributes", "verifyUserAttributesRevocation", "verifyUserIdCertification", "verifyUserIdRevocation", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nSignatureVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignatureVerifier.kt\norg/pgpainless/signature/consumer/SignatureVerifier$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,597:1\n1#2:598\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean verifySignatureOverUserId(@NotNull CharSequence userId, @NotNull PGPSignature signature, @NotNull PGPPublicKey signingKey, @NotNull PGPPublicKey keyWithUserId, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
            Intrinsics.checkNotNullParameter((Object)keyWithUserId, (String)"keyWithUserId");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            SignatureType type = SignatureType.Companion.requireFromCode(signature.getSignatureType());
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    bl = this.verifyUserIdCertification(userId, signature, signingKey, keyWithUserId, policy, referenceTime);
                    break;
                }
                case 5: {
                    bl = this.verifyUserIdRevocation(userId, signature, signingKey, keyWithUserId, policy, referenceTime);
                    break;
                }
                default: {
                    throw new SignatureValidationException("Signature is not a valid user-id certification/revocation signature: " + (Object)((Object)type));
                }
            }
            return bl;
        }

        @JvmStatic
        public final boolean verifyUserIdCertification(@NotNull CharSequence userId, @NotNull PGPSignature signature, @NotNull PGPPublicKey primaryKey, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)primaryKey, (String)"primaryKey");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            return this.verifyUserIdCertification(userId, signature, primaryKey, primaryKey, policy, referenceTime);
        }

        @JvmStatic
        public final boolean verifyUserIdCertification(@NotNull CharSequence userId, @NotNull PGPSignature signature, @NotNull PGPPublicKey signingKey, @NotNull PGPPublicKey keyWithUserId, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
            Intrinsics.checkNotNullParameter((Object)keyWithUserId, (String)"keyWithUserId");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            SignatureValidator.Companion.wasPossiblyMadeByKey(signingKey).verify(signature);
            SignatureValidator.Companion.signatureIsCertification().verify(signature);
            SignatureValidator.Companion.signatureStructureIsAcceptable(signingKey, policy).verify(signature);
            SignatureValidator.Companion.signatureIsEffective(referenceTime).verify(signature);
            SignatureValidator.Companion.correctSignatureOverUserId(userId, keyWithUserId, signingKey).verify(signature);
            return true;
        }

        @JvmStatic
        public final boolean verifyUserIdRevocation(@NotNull CharSequence userId, @NotNull PGPSignature signature, @NotNull PGPPublicKey primaryKey, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)primaryKey, (String)"primaryKey");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            return this.verifyUserIdRevocation(userId, signature, primaryKey, primaryKey, policy, referenceTime);
        }

        @JvmStatic
        public final boolean verifyUserIdRevocation(@NotNull CharSequence userId, @NotNull PGPSignature signature, @NotNull PGPPublicKey signingKey, @NotNull PGPPublicKey keyWithUserId, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
            Intrinsics.checkNotNullParameter((Object)keyWithUserId, (String)"keyWithUserId");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            SignatureValidator.Companion.wasPossiblyMadeByKey(signingKey).verify(signature);
            SignatureType[] signatureTypeArray = new SignatureType[]{SignatureType.CERTIFICATION_REVOCATION};
            SignatureValidator.Companion.signatureIsOfType(signatureTypeArray).verify(signature);
            SignatureValidator.Companion.signatureStructureIsAcceptable(signingKey, policy).verify(signature);
            SignatureValidator.Companion.signatureIsEffective(referenceTime).verify(signature);
            SignatureValidator.Companion.correctSignatureOverUserId(userId, keyWithUserId, signingKey).verify(signature);
            return true;
        }

        @JvmStatic
        public final boolean verifyUserAttributesCertification(@NotNull PGPUserAttributeSubpacketVector userAttributes, @NotNull PGPSignature signature, @NotNull PGPPublicKey primaryKey, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
            Intrinsics.checkNotNullParameter((Object)userAttributes, (String)"userAttributes");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)primaryKey, (String)"primaryKey");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            return this.verifyUserAttributesCertification(userAttributes, signature, primaryKey, primaryKey, policy, referenceTime);
        }

        @JvmStatic
        public final boolean verifyUserAttributesCertification(@NotNull PGPUserAttributeSubpacketVector userAttributes, @NotNull PGPSignature signature, @NotNull PGPPublicKey signingKey, @NotNull PGPPublicKey keyWithAttributes, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
            Intrinsics.checkNotNullParameter((Object)userAttributes, (String)"userAttributes");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
            Intrinsics.checkNotNullParameter((Object)keyWithAttributes, (String)"keyWithAttributes");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            SignatureValidator.Companion.wasPossiblyMadeByKey(signingKey).verify(signature);
            SignatureValidator.Companion.signatureIsCertification().verify(signature);
            SignatureValidator.Companion.signatureStructureIsAcceptable(signingKey, policy).verify(signature);
            SignatureValidator.Companion.signatureIsEffective(referenceTime).verify(signature);
            SignatureValidator.Companion.correctSignatureOverUserAttributes(userAttributes, keyWithAttributes, signingKey).verify(signature);
            return true;
        }

        @JvmStatic
        public final boolean verifyUserAttributesRevocation(@NotNull PGPUserAttributeSubpacketVector userAttributes, @NotNull PGPSignature signature, @NotNull PGPPublicKey primaryKey, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
            Intrinsics.checkNotNullParameter((Object)userAttributes, (String)"userAttributes");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)primaryKey, (String)"primaryKey");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            return this.verifyUserAttributesRevocation(userAttributes, signature, primaryKey, primaryKey, policy, referenceTime);
        }

        @JvmStatic
        public final boolean verifyUserAttributesRevocation(@NotNull PGPUserAttributeSubpacketVector userAttributes, @NotNull PGPSignature signature, @NotNull PGPPublicKey signingKey, @NotNull PGPPublicKey keyWithAttributes, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
            Intrinsics.checkNotNullParameter((Object)userAttributes, (String)"userAttributes");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
            Intrinsics.checkNotNullParameter((Object)keyWithAttributes, (String)"keyWithAttributes");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            SignatureValidator.Companion.wasPossiblyMadeByKey(signingKey).verify(signature);
            SignatureType[] signatureTypeArray = new SignatureType[]{SignatureType.CERTIFICATION_REVOCATION};
            SignatureValidator.Companion.signatureIsOfType(signatureTypeArray).verify(signature);
            SignatureValidator.Companion.signatureStructureIsAcceptable(signingKey, policy).verify(signature);
            SignatureValidator.Companion.signatureIsEffective(referenceTime).verify(signature);
            SignatureValidator.Companion.correctSignatureOverUserAttributes(userAttributes, keyWithAttributes, signingKey).verify(signature);
            return true;
        }

        @JvmStatic
        public final boolean verifySubkeyBindingSignature(@NotNull PGPSignature signature, @NotNull PGPPublicKey primaryKey, @NotNull PGPPublicKey subkey, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)primaryKey, (String)"primaryKey");
            Intrinsics.checkNotNullParameter((Object)subkey, (String)"subkey");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            SignatureType[] signatureTypeArray = new SignatureType[]{SignatureType.SUBKEY_BINDING};
            SignatureValidator.Companion.signatureIsOfType(signatureTypeArray).verify(signature);
            SignatureValidator.Companion.signatureStructureIsAcceptable(primaryKey, policy).verify(signature);
            SignatureValidator.Companion.signatureDoesNotPredateSignee(subkey).verify(signature);
            SignatureValidator.Companion.signatureIsEffective(referenceTime).verify(signature);
            SignatureValidator.Companion.hasValidPrimaryKeyBindingSignatureIfRequired(primaryKey, subkey, policy, referenceTime).verify(signature);
            SignatureValidator.Companion.correctSubkeyBindingSignature(primaryKey, subkey).verify(signature);
            return true;
        }

        @JvmStatic
        public final boolean verifySubkeyBindingRevocation(@NotNull PGPSignature signature, @NotNull PGPPublicKey primaryKey, @NotNull PGPPublicKey subkey, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)primaryKey, (String)"primaryKey");
            Intrinsics.checkNotNullParameter((Object)subkey, (String)"subkey");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            SignatureType[] signatureTypeArray = new SignatureType[]{SignatureType.SUBKEY_REVOCATION};
            SignatureValidator.Companion.signatureIsOfType(signatureTypeArray).verify(signature);
            SignatureValidator.Companion.signatureStructureIsAcceptable(primaryKey, policy).verify(signature);
            SignatureValidator.Companion.signatureDoesNotPredateSignee(subkey).verify(signature);
            SignatureValidator.Companion.signatureIsEffective(referenceTime).verify(signature);
            SignatureValidator.Companion.correctSignatureOverKey(primaryKey, subkey).verify(signature);
            return true;
        }

        @JvmStatic
        public final boolean verifyDirectKeySignature(@NotNull PGPSignature signature, @NotNull PGPPublicKey primaryKey, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)primaryKey, (String)"primaryKey");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            return this.verifyDirectKeySignature(signature, primaryKey, primaryKey, policy, referenceTime);
        }

        @JvmStatic
        public final boolean verifyDirectKeySignature(@NotNull PGPSignature signature, @NotNull PGPPublicKey signingKey, @NotNull PGPPublicKey signedKey, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
            Intrinsics.checkNotNullParameter((Object)signedKey, (String)"signedKey");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            SignatureType[] signatureTypeArray = new SignatureType[]{SignatureType.DIRECT_KEY};
            SignatureValidator.Companion.signatureIsOfType(signatureTypeArray).verify(signature);
            SignatureValidator.Companion.signatureStructureIsAcceptable(signingKey, policy).verify(signature);
            SignatureValidator.Companion.signatureDoesNotPredateSignee(signedKey).verify(signature);
            SignatureValidator.Companion.signatureIsEffective(referenceTime).verify(signature);
            SignatureValidator.Companion.correctSignatureOverKey(signingKey, signedKey).verify(signature);
            return true;
        }

        @JvmStatic
        public final boolean verifyKeyRevocationSignature(@NotNull PGPSignature signature, @NotNull PGPPublicKey primaryKey, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)primaryKey, (String)"primaryKey");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            SignatureType[] signatureTypeArray = new SignatureType[]{SignatureType.KEY_REVOCATION};
            SignatureValidator.Companion.signatureIsOfType(signatureTypeArray).verify(signature);
            SignatureValidator.Companion.signatureStructureIsAcceptable(primaryKey, policy).verify(signature);
            SignatureValidator.Companion.signatureIsEffective(referenceTime).verify(signature);
            SignatureValidator.Companion.correctSignatureOverKey(primaryKey, primaryKey).verify(signature);
            return true;
        }

        @JvmStatic
        public final boolean verifyUninitializedSignature(@NotNull PGPSignature signature, @NotNull InputStream signedData, @NotNull PGPPublicKey signingKey, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)signedData, (String)"signedData");
            Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            this.initializeSignatureAndUpdateWithSignedData(signature, signedData, signingKey);
            return this.verifyInitializedSignature(signature, signingKey, policy, referenceTime);
        }

        @JvmStatic
        public final void initializeSignatureAndUpdateWithSignedData(@NotNull PGPSignature signature, @NotNull InputStream signedData, @NotNull PGPPublicKey signingKey) throws SignatureValidationException {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)signedData, (String)"signedData");
            Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
            try {
                signature.init(ImplementationFactory.Companion.getInstance().getPgpContentVerifierBuilderProvider(), signingKey);
                int read = 0;
                byte[] buf = new byte[8192];
                byte lastByte = -1;
                while (true) {
                    int n;
                    int it = n = signedData.read(buf);
                    boolean bl = false;
                    read = it;
                    if (n != -1) {
                        if (lastByte == 10) {
                            signature.update(lastByte);
                        }
                        if ((lastByte = buf[read - 1]) == 10) {
                            signature.update(buf, 0, read - 1);
                            continue;
                        }
                        signature.update(buf, 0, read);
                        continue;
                    }
                    break;
                }
            }
            catch (PGPException e) {
                throw new SignatureValidationException("Cannot init signature.", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new SignatureValidationException("Cannot update signature.", e);
            }
        }

        @JvmStatic
        public final boolean verifyInitializedSignature(@NotNull PGPSignature signature, @NotNull PGPPublicKey signingKey, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            SignatureValidator.Companion.wasPossiblyMadeByKey(signingKey).verify(signature);
            SignatureValidator.Companion.signatureStructureIsAcceptable(signingKey, policy).verify(signature);
            SignatureValidator.Companion.signatureIsEffective(referenceTime).verify(signature);
            try {
                if (!signature.verify()) {
                    throw new SignatureValidationException("Signature is not correct.");
                }
                bl = true;
            }
            catch (PGPException e) {
                throw new SignatureValidationException("Could not verify signature correctness.", (Exception)((Object)e));
            }
            return bl;
        }

        @JvmStatic
        public final boolean verifyOnePassSignature(@NotNull PGPSignature signature, @NotNull PGPPublicKey signingKey, @NotNull OnePassSignatureCheck onePassSignature, @NotNull Policy policy) throws SignatureValidationException {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
            Intrinsics.checkNotNullParameter((Object)onePassSignature, (String)"onePassSignature");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            try {
                SignatureValidator.Companion.wasPossiblyMadeByKey(signingKey).verify(signature);
                SignatureValidator.Companion.signatureStructureIsAcceptable(signingKey, policy).verify(signature);
                SignatureValidator.Companion.signatureIsEffective$default(SignatureValidator.Companion, null, 1, null).verify(signature);
            }
            catch (SignatureValidationException e) {
                throw new SignatureValidationException("Signature is not valid: " + e.getMessage(), (Exception)((Object)e));
            }
            try {
                if (onePassSignature.getSignature() == null) {
                    boolean bl = false;
                    String string = "No comparison signature provided.";
                    throw new IllegalStateException(string.toString());
                }
                if (!onePassSignature.getOnePassSignature().verify(signature)) {
                    throw new SignatureValidationException("Bad signature of key " + LongExtensionsKt.openPgpKeyId(signingKey.getKeyID()));
                }
            }
            catch (PGPException e) {
                throw new SignatureValidationException("Could not verify correctness of One-Pass-Signature: " + e.getMessage(), (Exception)((Object)e));
            }
            return true;
        }

        @JvmStatic
        public final boolean verifySignatureOverUserId(@NotNull CharSequence userId, @NotNull PGPSignature signature, @NotNull PGPPublicKey primaryKey, @NotNull Policy policy, @NotNull Date referenceTime) throws SignatureValidationException {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)primaryKey, (String)"primaryKey");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            return this.verifySignatureOverUserId(userId, signature, primaryKey, primaryKey, policy, referenceTime);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SignatureType.values().length];
                try {
                    nArray[SignatureType.GENERIC_CERTIFICATION.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignatureType.NO_CERTIFICATION.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignatureType.CASUAL_CERTIFICATION.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignatureType.POSITIVE_CERTIFICATION.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignatureType.CERTIFICATION_REVOCATION.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

