/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util.selection.keyring.impl;

import java.util.List;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.util.selection.keyring.PublicKeyRingSelectionStrategy;
import org.pgpainless.util.selection.keyring.SecretKeyRingSelectionStrategy;

public final class ExactUserId {
    private ExactUserId() {
    }

    public static class SecRingSelectionStrategy
    extends SecretKeyRingSelectionStrategy<String> {
        @Override
        public boolean accept(String identifier, PGPSecretKeyRing keyRing) {
            List<String> userIds = KeyRingUtils.getUserIdsIgnoringInvalidUTF8(keyRing.getPublicKey());
            for (String userId : userIds) {
                if (!userId.equals(identifier)) continue;
                return true;
            }
            return false;
        }
    }

    public static class PubRingSelectionStrategy
    extends PublicKeyRingSelectionStrategy<String> {
        @Override
        public boolean accept(String identifier, PGPPublicKeyRing keyRing) {
            List<String> userIds = KeyRingUtils.getUserIdsIgnoringInvalidUTF8(keyRing.getPublicKey());
            for (String userId : userIds) {
                if (!userId.equals(identifier)) continue;
                return true;
            }
            return false;
        }
    }
}

