/*
 * Decompiled with CFR 0.152.
 */
package ambience.lifecycle;

import ambience.api.Lifecycle;
import ambience.lifecycle.SessionId$;
import ambience.lifecycle.restarter.UnixRestarter;
import ambience.module.UserDB;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBoolean$;
import monix.execution.atomic.AtomicInt;
import monix.execution.atomic.AtomicInt$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.duration.FiniteDuration$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class LifecycleAPI$
implements Lifecycle,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(LifecycleAPI$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final AtomicBoolean inShutdown;
    private static final AtomicInt jobCount;
    private static final ListBuffer<Task<BoxedUnit>> taskBuffer;
    private static final boolean isRestartSupported;
    private static final Task incJobCount;
    private static final Task decJobCount;
    public static final LifecycleAPI$ MODULE$;

    private LifecycleAPI$() {
    }

    static {
        MODULE$ = new LifecycleAPI$();
        inShutdown = AtomicBoolean$.MODULE$.apply(false);
        jobCount = AtomicInt$.MODULE$.apply(0);
        taskBuffer = new ListBuffer();
        isRestartSupported = true;
        incJobCount = Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$init$$$anonfun$1();
            return BoxedUnit.UNIT;
        });
        decJobCount = Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$init$$$anonfun$2();
            return BoxedUnit.UNIT;
        });
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LifecycleAPI$.class);
    }

    public boolean isRestartSupported() {
        return isRestartSupported;
    }

    public Task<BoxedUnit> incJobCount() {
        return incJobCount;
    }

    public Task<BoxedUnit> decJobCount() {
        return decJobCount;
    }

    public Task<String> restart(UserDB.User user) {
        if (user.privileges().contains((Object)"mod-lifecycle")) {
            this.log().info(() -> LifecycleAPI$.restart$$anonfun$1(user), Line$.MODULE$.apply(33), FullName$.MODULE$.apply("ambience.lifecycle.LifecycleAPI.restart"));
            return SessionId$.MODULE$.forceNewSessionId().as((Object)"New session requested");
        }
        return Task$.MODULE$.now((Object)"User does not have restart privileges");
    }

    public Task<String> monitorRestart(long timeoutSecs) {
        return Task$.MODULE$.apply(LifecycleAPI$::monitorRestart$$anonfun$1).flatMap((Function1 & Serializable)changed -> LifecycleAPI$.monitorRestart$$anonfun$2(timeoutSecs, BoxesRunTime.unboxToBoolean((Object)changed)));
    }

    public <T> Task<T> runJob(Task<T> task) {
        if (!inShutdown.get()) {
            return this.incJobCount().flatMap((Function1 & Serializable)_$1 -> task).doOnFinish((Function1 & Serializable)_$2 -> MODULE$.decJobCount()).doOnCancel(this.decJobCount());
        }
        this.log().warn(LifecycleAPI$::runJob$$anonfun$3, Line$.MODULE$.apply(49), FullName$.MODULE$.apply("ambience.lifecycle.LifecycleAPI.runJob"));
        return Task$.MODULE$.raiseError((Throwable)new RuntimeException("Cannot start task as system is shutting down"));
    }

    public Task<Object> currentJobCount() {
        return Task$.MODULE$.now((Object)BoxesRunTime.boxToInteger((int)jobCount.get()));
    }

    public void onRestartRequest(Task<BoxedUnit> task) {
        taskBuffer.$plus$eq(task);
    }

    private Task<String> restartWhenPossible(long secs) {
        return Task$.MODULE$.apply(LifecycleAPI$::restartWhenPossible$$anonfun$1).flatMap((Function1 & Serializable)tasks -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
            LifecycleAPI$.restartWhenPossible$$anonfun$2$$anonfun$1(tasks);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return MODULE$.runShutdownTasks((List<Task<BoxedUnit>>)tasks).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return MODULE$.doRestartWhenPossible(secs).map((Function1 & Serializable)s -> s);
            });
        }));
    }

    private Task<BoxedUnit> runShutdownTasks(List<Task<BoxedUnit>> list) {
        List<Task<BoxedUnit>> list2 = list;
        Nil$ nil$ = scala.package$.MODULE$.Nil();
        List<Task<BoxedUnit>> list3 = list2;
        if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
            return Task$.MODULE$.unit();
        }
        if (list2 instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list2;
            List list4 = colon2.next$access$1();
            Task head = (Task)colon2.head();
            List tail = list4;
            return head.onErrorRecover((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    if (throwable != null) {
                        Throwable ex = throwable;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    if (throwable != null) {
                        Throwable ex = throwable;
                        LifecycleAPI$.MODULE$.log().error(() -> LifecycleAPI$.ambience$lifecycle$LifecycleAPI$$anon$1$$_$applyOrElse$$anonfun$1(ex), ex, Line$.MODULE$.apply(75), FullName$.MODULE$.apply("ambience.lifecycle.LifecycleAPI.runShutdownTasks"));
                        return BoxedUnit.UNIT;
                    }
                    return function1.apply((Object)x);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{ambience$lifecycle$LifecycleAPI$$anon$1$$_$applyOrElse$$anonfun$1(java.lang.Throwable )}, serializedLambda);
                }
            }).flatMap((Function1 & Serializable)_$3 -> MODULE$.runShutdownTasks((List<Task<BoxedUnit>>)tail));
        }
        throw new MatchError(list2);
    }

    private Task<String> doRestartWhenPossible(long secs) {
        return Task$.MODULE$.apply(LifecycleAPI$::doRestartWhenPossible$$anonfun$1).flatMap((Function1 & Serializable)count -> LifecycleAPI$.doRestartWhenPossible$$anonfun$2(secs, BoxesRunTime.unboxToInt((Object)count)));
    }

    private Task<String> restartNow() {
        return Task$.MODULE$.apply(LifecycleAPI$::restartNow$$anonfun$1);
    }

    private final Object $init$$$anonfun$1$$anonfun$1() {
        return "incJobCount to " + jobCount.get();
    }

    private final void $init$$$anonfun$1() {
        jobCount.increment(jobCount.increment$default$1());
        this.log().debug(this::$init$$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(23), FullName$.MODULE$.apply("ambience.lifecycle.LifecycleAPI.incJobCount"));
    }

    private final Object $init$$$anonfun$2$$anonfun$1() {
        return "decJobCount to " + jobCount.get();
    }

    private final void $init$$$anonfun$2() {
        jobCount.decrement(jobCount.decrement$default$1());
        this.log().debug(this::$init$$$anonfun$2$$anonfun$1, Line$.MODULE$.apply(28), FullName$.MODULE$.apply("ambience.lifecycle.LifecycleAPI.decJobCount"));
    }

    private static final Object restart$$anonfun$1(UserDB.User user$1) {
        return "New session requested by " + user$1.name();
    }

    private static final boolean monitorRestart$$anonfun$1() {
        return inShutdown.compareAndSet(false, true);
    }

    private static final /* synthetic */ Task monitorRestart$$anonfun$2(long timeoutSecs$1, boolean changed) {
        return (changed ? MODULE$.restartWhenPossible(timeoutSecs$1) : Task$.MODULE$.now((Object)"Shutdown already in progress")).map((Function1 & Serializable)s -> s);
    }

    private static final Object runJob$$anonfun$3() {
        return "Cannot start task as system is shutting down";
    }

    private static final List restartWhenPossible$$anonfun$1() {
        return taskBuffer.toList();
    }

    private static final Object restartWhenPossible$$anonfun$2$$anonfun$1$$anonfun$1(List tasks$2) {
        return "Running " + tasks$2.size() + " shutdown tasks";
    }

    private static final void restartWhenPossible$$anonfun$2$$anonfun$1(List tasks$1) {
        MODULE$.log().info(() -> LifecycleAPI$.restartWhenPossible$$anonfun$2$$anonfun$1$$anonfun$1(tasks$1), Line$.MODULE$.apply(63), FullName$.MODULE$.apply("ambience.lifecycle.LifecycleAPI.restartWhenPossible"));
    }

    public static final Object ambience$lifecycle$LifecycleAPI$$anon$1$$_$applyOrElse$$anonfun$1(Throwable ex$1) {
        return "Shutdown task failed: " + ex$1;
    }

    private static final int doRestartWhenPossible$$anonfun$1() {
        return jobCount.get();
    }

    private static final Object doRestartWhenPossible$$anonfun$2$$anonfun$1$$anonfun$1(long secs$6, int count$2) {
        return "Restart when possible (" + secs$6 + " secs) has " + count$2 + " jobs";
    }

    private static final void doRestartWhenPossible$$anonfun$2$$anonfun$1(long secs$5, int count$1) {
        MODULE$.log().info(() -> LifecycleAPI$.doRestartWhenPossible$$anonfun$2$$anonfun$1$$anonfun$1(secs$5, count$1), Line$.MODULE$.apply(84), FullName$.MODULE$.apply("ambience.lifecycle.LifecycleAPI.doRestartWhenPossible"));
    }

    private static final Object doRestartWhenPossible$$anonfun$2$$anonfun$2$$anonfun$1(int count$4) {
        return "Cannot restart. Job count = " + count$4;
    }

    private static final /* synthetic */ Task doRestartWhenPossible$$anonfun$2(long secs$4, int count) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            LifecycleAPI$.doRestartWhenPossible$$anonfun$2$$anonfun$1(secs$4, count);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            Task task;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            if (count == 0) {
                task = MODULE$.restartNow();
            } else if (secs$4 > 0L) {
                long reduceBy = package$.MODULE$.min(60L, secs$4);
                task = MODULE$.doRestartWhenPossible(secs$4 - reduceBy).delayExecution(FiniteDuration$.MODULE$.apply(reduceBy, scala.concurrent.duration.package$.MODULE$.SECONDS()));
            } else {
                MODULE$.log().info(() -> LifecycleAPI$.doRestartWhenPossible$$anonfun$2$$anonfun$2$$anonfun$1(count), Line$.MODULE$.apply(92), FullName$.MODULE$.apply("ambience.lifecycle.LifecycleAPI.doRestartWhenPossible"));
                task = Task$.MODULE$.now((Object)("Restart timeout expired (count=" + count + ")"));
            }
            return task.map((Function1 & Serializable)reply -> reply);
        });
    }

    private static final Object restartNow$$anonfun$1$$anonfun$1() {
        return "restartNow";
    }

    private static final String restartNow$$anonfun$1() {
        MODULE$.log().info(LifecycleAPI$::restartNow$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(99), FullName$.MODULE$.apply("ambience.lifecycle.LifecycleAPI.restartNow"));
        UnixRestarter restarter = new UnixRestarter();
        restarter.restart();
        return "Restarted already, so this is never seen";
    }
}

