/*
 * Decompiled with CFR 0.152.
 */
package ambience.lifecycle;

import ambience.lifecycle.LifecycleAPI$;
import ambience.lifecycle.LifecycleModule;
import ambience.lifecycle.SessionId;
import ambience.lifecycle.SessionId$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler$;
import scala.Function0;
import scala.Function1;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class SessionIdMonitor
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SessionIdMonitor.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final LifecycleModule module;
    private final long StartAfterMillis;
    private final long IntervalMillis;
    private final long RestartTimeoutSecs;
    private final FiniteDuration StartAfter;
    private final FiniteDuration Interval;

    public SessionIdMonitor(LifecycleModule module) {
        this.module = module;
        this.StartAfterMillis = module.projectConfig().pc().getDuration("lifecycle.monitor.start-after", package$.MODULE$.MILLISECONDS());
        this.IntervalMillis = module.projectConfig().pc().getDuration("lifecycle.monitor.interval", package$.MODULE$.MILLISECONDS());
        this.RestartTimeoutSecs = module.projectConfig().pc().getDuration("lifecycle.monitor.restart-timeout", package$.MODULE$.SECONDS());
        this.StartAfter = FiniteDuration$.MODULE$.apply(this.StartAfterMillis(), package$.MODULE$.MILLISECONDS());
        this.Interval = FiniteDuration$.MODULE$.apply(this.IntervalMillis(), package$.MODULE$.MILLISECONDS());
        this.run().runAsyncAndForget(module.scheduler());
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public long StartAfterMillis() {
        return this.StartAfterMillis;
    }

    public long IntervalMillis() {
        return this.IntervalMillis;
    }

    public long RestartTimeoutSecs() {
        return this.RestartTimeoutSecs;
    }

    public FiniteDuration StartAfter() {
        return this.StartAfter;
    }

    public FiniteDuration Interval() {
        return this.Interval;
    }

    public Task<BoxedUnit> run() {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.run$$anonfun$1();
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)_$1 -> {
            if (this.module.isRestartable()) {
                return this.runTask().delayExecution(this.StartAfter());
            }
            return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                this.run$$anonfun$2$$anonfun$1();
                return BoxedUnit.UNIT;
            });
        }).onErrorHandle((Function1)(JProcedure1 & Serializable)x$1 -> {
            Throwable throwable;
            Throwable ex = throwable = x$1;
            this.log().error(() -> SessionIdMonitor.run$$anonfun$3$$anonfun$1(ex), ex, Line$.MODULE$.apply(28), FullName$.MODULE$.apply("ambience.lifecycle.SessionIdMonitor.run"));
        });
    }

    public Task<BoxedUnit> runTask() {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.runTask$$anonfun$1();
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.module.tSessionId().flatMap((Function1 & Serializable)sessionId -> this.runTask$$anonfun$2$$anonfun$1(sessionId == null ? null : ((SessionId)sessionId).value()));
        });
    }

    public Task<BoxedUnit> onSessionChanged() {
        this.log().info(SessionIdMonitor::onSessionChanged$$anonfun$1, Line$.MODULE$.apply(42), FullName$.MODULE$.apply("ambience.lifecycle.SessionIdMonitor.onSessionChanged"));
        LifecycleAPI$.MODULE$.monitorRestart(this.RestartTimeoutSecs()).map((Function1)(JProcedure1 & Serializable)msg -> this.log().info(() -> SessionIdMonitor.onSessionChanged$$anonfun$2$$anonfun$1(msg), Line$.MODULE$.apply(45), FullName$.MODULE$.apply("ambience.lifecycle.SessionIdMonitor.onSessionChanged"))).runAsyncAndForget(Scheduler$.MODULE$.global());
        return Task$.MODULE$.unit();
    }

    public Task<BoxedUnit> scheduleNext() {
        this.log().debug(this::scheduleNext$$anonfun$1, Line$.MODULE$.apply(51), FullName$.MODULE$.apply("ambience.lifecycle.SessionIdMonitor.scheduleNext"));
        return this.runTask().delayExecution(this.Interval());
    }

    private static final Object run$$anonfun$1$$anonfun$1() {
        return "run";
    }

    private final void run$$anonfun$1() {
        this.log().info(SessionIdMonitor::run$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(20), FullName$.MODULE$.apply("ambience.lifecycle.SessionIdMonitor.run"));
    }

    private static final Object run$$anonfun$2$$anonfun$1$$anonfun$1() {
        return "Lifecycle is not restartable, so monitoring is stopping";
    }

    private final void run$$anonfun$2$$anonfun$1() {
        this.log().info(SessionIdMonitor::run$$anonfun$2$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(24), FullName$.MODULE$.apply("ambience.lifecycle.SessionIdMonitor.run"));
    }

    private static final Object run$$anonfun$3$$anonfun$1(Throwable ex$1) {
        return "Unable to start monitor: " + ex$1;
    }

    private static final Object runTask$$anonfun$1$$anonfun$1() {
        return "Running";
    }

    private final void runTask$$anonfun$1() {
        this.log().debug(SessionIdMonitor::runTask$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(34), FullName$.MODULE$.apply("ambience.lifecycle.SessionIdMonitor.runTask"));
    }

    private final /* synthetic */ Task runTask$$anonfun$2$$anonfun$1$$anonfun$1(boolean changed) {
        return (changed ? this.onSessionChanged() : this.scheduleNext()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
    }

    private final /* synthetic */ Task runTask$$anonfun$2$$anonfun$1(String sessionId) {
        return SessionId$.MODULE$.hasSessionIdChanged(sessionId).flatMap((Function1 & Serializable)changed -> this.runTask$$anonfun$2$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)changed)));
    }

    private static final Object onSessionChanged$$anonfun$1() {
        return "session id changed, attempting restart";
    }

    private static final Object onSessionChanged$$anonfun$2$$anonfun$1(String msg$1) {
        return "monitorRestart: " + msg$1;
    }

    private final Object scheduleNext$$anonfun$1() {
        return "scheduleNext for " + (double)this.IntervalMillis() / 60000.0 + " mins";
    }
}

