/*
 * Decompiled with CFR 0.152.
 */
package com.sun.akuma;

import com.sun.akuma.CLibrary;
import com.sun.akuma.JavaVMArguments;
import com.sun.jna.StringArray;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class Daemon {
    public void all(boolean bl) throws Exception {
        if (this.isDaemonized()) {
            this.init();
        } else if (bl) {
            this.daemonize();
            System.exit(0);
        }
    }

    public boolean isDaemonized() {
        return System.getProperty(Daemon.class.getName()) != null;
    }

    public void daemonize() throws IOException {
        this.daemonize(JavaVMArguments.current());
    }

    public void daemonize(JavaVMArguments javaVMArguments) {
        if (this.isDaemonized()) {
            throw new IllegalStateException("Already running as a daemon");
        }
        javaVMArguments.setSystemProperty(Daemon.class.getName(), "daemonized");
        String string = Daemon.getCurrentExecutable();
        StringArray stringArray = javaVMArguments.toStringArray();
        int n = CLibrary.LIBC.fork();
        if (n < 0) {
            CLibrary.LIBC.perror("initial fork failed");
            System.exit(-1);
        }
        if (n == 0) {
            CLibrary.LIBC.execv(string, stringArray);
            System.err.println("exec failed");
            CLibrary.LIBC.perror("initial exec failed");
            System.exit(-1);
        }
    }

    public static void selfExec(JavaVMArguments javaVMArguments) {
        CLibrary.LIBC.execv(Daemon.getCurrentExecutable(), javaVMArguments.toStringArray());
    }

    public void init() throws Exception {
        this.init("/var/run/daemon.pid");
    }

    public void init(String string) throws Exception {
        CLibrary.LIBC.setsid();
        this.closeDescriptors();
        this.chdirToRoot();
        if (string != null) {
            this.writePidFile(string);
        }
    }

    protected void closeDescriptors() throws IOException {
        if (!Boolean.getBoolean(Daemon.class.getName() + ".keepDescriptors")) {
            System.out.close();
            System.err.close();
            System.in.close();
        }
    }

    protected void chdirToRoot() {
        CLibrary.LIBC.chdir("/");
        System.setProperty("user.dir", "/");
    }

    protected void writePidFile(String string) throws IOException {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(String.valueOf(CLibrary.LIBC.getpid()));
            fileWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getCurrentExecutable() {
        int n = CLibrary.LIBC.getpid();
        String string = "/proc/" + n + "/exe";
        if (new File(string).exists()) {
            return string;
        }
        return System.getProperty("java.home") + "/bin/java";
    }
}

