/*
 * Decompiled with CFR 0.152.
 */
package com.sun.akuma;

import com.sun.akuma.CLibrary;
import com.sun.akuma.Daemon;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.ptr.IntByReference;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaVMArguments
extends ArrayList<String> {
    private static final boolean IS_LITTLE_ENDIAN = "little".equals(System.getProperty("sun.cpu.endian"));
    private static final Logger LOGGER = Logger.getLogger(JavaVMArguments.class.getName());

    public JavaVMArguments() {
    }

    public JavaVMArguments(Collection<? extends String> collection) {
        super(collection);
    }

    public void removeSystemProperty(String object) {
        object = "-D" + (String)object;
        String string = (String)object + "=";
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.equals(object) && !string2.startsWith(string)) continue;
            iterator.remove();
        }
    }

    public void setSystemProperty(String string, String string2) {
        this.removeSystemProperty(string);
        this.add(1, "-D" + string + "=" + string2);
    }

    public void removeTail(int n) {
        this.removeAll(this.subList(this.size() - n, this.size()));
    }

    StringArray toStringArray() {
        return new StringArray(this.toArray(new String[this.size()]));
    }

    public static JavaVMArguments current() throws IOException {
        return JavaVMArguments.of(-1);
    }

    public static JavaVMArguments of(int n) throws IOException {
        String string = System.getProperty("os.name");
        if ("Linux".equals(string)) {
            return JavaVMArguments.ofLinux(n);
        }
        if ("SunOS".equals(string)) {
            return JavaVMArguments.ofSolaris(n);
        }
        if ("Mac OS X".equals(string)) {
            return JavaVMArguments.ofMac(n);
        }
        throw new UnsupportedOperationException("Unsupported Operating System " + string);
    }

    private static JavaVMArguments ofLinux(int n) throws IOException {
        n = JavaVMArguments.resolvePID(n);
        String string = JavaVMArguments.readFile(new File("/proc/" + n + "/cmdline"));
        JavaVMArguments javaVMArguments = new JavaVMArguments((Collection<? extends String>)Arrays.asList(string.split("\u0000")));
        javaVMArguments.removeSystemProperty(Daemon.class.getName());
        return javaVMArguments;
    }

    private static int resolvePID(int n) {
        if (n == -1) {
            n = CLibrary.LIBC.getpid();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JavaVMArguments ofSolaris(int n) throws IOException {
        JavaVMArguments javaVMArguments;
        boolean bl = "64".equals(System.getProperty("sun.arch.data.model"));
        n = JavaVMArguments.resolvePID(n);
        RandomAccessFile randomAccessFile = new RandomAccessFile(new File("/proc/" + n + "/psinfo"), "r");
        randomAccessFile.seek(8L);
        if (JavaVMArguments.adjust(randomAccessFile.readInt()) != n) {
            throw new IOException("psinfo PID mismatch");
        }
        randomAccessFile.seek(bl ? 236L : 188L);
        int n2 = JavaVMArguments.adjust(randomAccessFile.readInt());
        long l = JavaVMArguments.adjust(bl ? randomAccessFile.readLong() : JavaVMArguments.to64(randomAccessFile.readInt()));
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(String.format("argc=%d,argp=%X", n2, l));
        }
        File file = new File("/proc/" + n + "/as");
        if (bl) {
            CLibrary.FILE fILE = CLibrary.LIBC.fopen(file.getPath(), "r");
            try {
                JavaVMArguments javaVMArguments2 = new JavaVMArguments();
                Memory memory = new Memory(8L);
                for (int i = 0; i < n2; ++i) {
                    JavaVMArguments.seek64(fILE, l + (long)(i * 8));
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest(String.format("Seeked to %X", CLibrary.LIBC.ftell(fILE)));
                    }
                    memory.setLong(0L, 0L);
                    CLibrary.LIBC.fread((Pointer)memory, 1, 8, fILE);
                    long l2 = memory.getLong(0L);
                    javaVMArguments2.add(JavaVMArguments.readLine(fILE, l2, "argv[" + i + "]"));
                }
                JavaVMArguments javaVMArguments3 = javaVMArguments2;
                return javaVMArguments3;
            }
            finally {
                CLibrary.LIBC.fclose(fILE);
            }
        }
        RandomAccessFile randomAccessFile2 = new RandomAccessFile(file, "r");
        try {
            JavaVMArguments javaVMArguments4 = new JavaVMArguments();
            for (int i = 0; i < n2; ++i) {
                randomAccessFile2.seek(l + (long)(i * 4));
                int n3 = JavaVMArguments.adjust(randomAccessFile2.readInt());
                javaVMArguments4.add(JavaVMArguments.readLine(randomAccessFile2, n3, "argv[" + i + "]"));
            }
            javaVMArguments = javaVMArguments4;
        }
        catch (Throwable throwable) {
            randomAccessFile2.close();
            throw throwable;
        }
        randomAccessFile2.close();
        return javaVMArguments;
        finally {
            randomAccessFile.close();
        }
    }

    private static void seek64(CLibrary.FILE fILE, long l) {
        CLibrary.LIBC.fseek(fILE, 0L, 0);
        while (l < 0L) {
            long l2 = Long.MAX_VALUE;
            l -= l2;
            CLibrary.LIBC.fseek(fILE, l2, 1);
        }
        CLibrary.LIBC.fseek(fILE, l, 1);
    }

    private static int adjust(int n) {
        if (IS_LITTLE_ENDIAN) {
            return n << 24 | n << 8 & 0xFF0000 | n >> 8 & 0xFF00 | n >>> 24;
        }
        return n;
    }

    private static long adjust(long l) {
        if (IS_LITTLE_ENDIAN) {
            return l << 56 | l << 40 & 0xFF000000000000L | l << 24 & 0xFF0000000000L | l << 8 & 0xFF00000000L | l >> 8 & 0xFF000000L | l >> 24 & 0xFF0000L | l >> 40 & 0xFF00L | l >> 56;
        }
        return l;
    }

    private static long to64(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    private static String readLine(RandomAccessFile randomAccessFile, int n, String string) throws IOException {
        int n2;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(String.format("Reading %s at %X", string, n));
        }
        randomAccessFile.seek(JavaVMArguments.to64(n));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        while ((n2 = randomAccessFile.read()) > 0) {
            if (++n3 % 100 == 0 && LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest(string + " is so far " + byteArrayOutputStream.toString());
            }
            byteArrayOutputStream.write(n2);
        }
        String string2 = byteArrayOutputStream.toString();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(string + " was " + string2);
        }
        return string2;
    }

    private static String readLine(CLibrary.FILE fILE, long l, String string) throws IOException {
        byte by;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(String.format("Reading %s at %X", string, l));
        }
        JavaVMArguments.seek64(fILE, l);
        Memory memory = new Memory(1L);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (CLibrary.LIBC.fread((Pointer)memory, 1, 1, fILE) != 0 && (by = memory.getByte(0L)) != 0) {
            if (++n % 100 == 0 && LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest(string + " is so far " + byteArrayOutputStream.toString());
            }
            byteArrayOutputStream.write(by);
        }
        String string2 = byteArrayOutputStream.toString();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(string + " was " + string2);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(File file) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            int n;
            byte[] byArray = new byte[1024];
            while ((n = fileInputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            String string = byteArrayOutputStream.toString();
            return string;
        }
    }

    private static JavaVMArguments ofMac(int n) {
        final int n2 = Native.getNativeSize(Integer.TYPE);
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference(0);
        IntByReference intByReference3 = new IntByReference(n2);
        if (CLibrary.LIBC.sysctl(new int[]{1, 8}, 2, intByReference2.getPointer(), intByReference3, Pointer.NULL, intByReference) != 0) {
            throw new UnsupportedOperationException("Failed to get kernl.argmax: " + CLibrary.LIBC.strerror(Native.getLastError()));
        }
        int n3 = intByReference2.getValue();
        LOGGER.fine("argmax=" + n3);
        class StringArrayMemory
        extends Memory {
            private long offset;

            StringArrayMemory(long l) {
                super(l);
                this.offset = 0L;
            }

            int readInt() {
                int n = this.getInt(this.offset);
                this.offset += (long)n2;
                return n;
            }

            byte peek() {
                return this.getByte(this.offset);
            }

            String readString() {
                byte by;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((by = this.getByte(this.offset++)) != 0) {
                    byteArrayOutputStream.write(by);
                }
                return byteArrayOutputStream.toString();
            }

            void skip0() {
                while (this.getByte(this.offset) == 0) {
                    ++this.offset;
                }
            }
        }
        StringArrayMemory stringArrayMemory = new StringArrayMemory((long)n3);
        intByReference3.setValue(n3);
        if (CLibrary.LIBC.sysctl(new int[]{1, 49, JavaVMArguments.resolvePID(n)}, 3, (Pointer)stringArrayMemory, intByReference3, Pointer.NULL, intByReference) != 0) {
            throw new UnsupportedOperationException("Failed to obtain ken.procargs2: " + CLibrary.LIBC.strerror(Native.getLastError()));
        }
        JavaVMArguments javaVMArguments = new JavaVMArguments();
        int n4 = stringArrayMemory.readInt();
        stringArrayMemory.readString();
        for (int i = 0; i < n4; ++i) {
            stringArrayMemory.skip0();
            javaVMArguments.add(stringArrayMemory.readString());
        }
        return javaVMArguments;
    }
}

