/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.builders;

import java.io.Reader;
import java.io.Serializable;
import java.util.Arrays;
import monix.execution.Ack;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.ExecutionModel;
import monix.execution.Scheduler;
import monix.execution.UncaughtExceptionReporter;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.cancelables.BooleanCancelable;
import monix.execution.cancelables.BooleanCancelable$;
import monix.execution.exceptions.APIContractViolationException$;
import monix.execution.internal.Platform$;
import monix.reactive.Observable;
import monix.reactive.observers.Subscriber;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.package$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class CharsReaderObservable
extends Observable<char[]> {
    private final Reader in;
    private final int chunkSize;
    private final AtomicBoolean wasSubscribed;

    public CharsReaderObservable(Reader in, int chunkSize) {
        this.in = in;
        this.chunkSize = chunkSize;
        Predef$.MODULE$.require(chunkSize > 0, CharsReaderObservable::$init$$$anonfun$1);
        this.wasSubscribed = AtomicBuilder.AtomicBooleanBuilder$.MODULE$.buildInstance(false, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<char[]> out) {
        Cancelable cancelable;
        if (!this.wasSubscribed.compareAndSet(false, true)) {
            out.onError((Throwable)APIContractViolationException$.MODULE$.apply("ReaderObservable does not support multiple subscribers"));
            cancelable = Cancelable$.MODULE$.empty();
        } else {
            void var3_3;
            char[] buffer = new char[this.chunkSize];
            BooleanCancelable cancelable2 = BooleanCancelable$.MODULE$.apply();
            ExecutionModel em = out.scheduler().executionModel();
            this.reschedule((Future<Ack>)Ack.Continue$.MODULE$, buffer, out, cancelable2, em, out.scheduler());
            cancelable = var3_3;
        }
        return cancelable;
    }

    private void reschedule(Future<Ack> ack, char[] b, Subscriber<char[]> out, BooleanCancelable c, ExecutionModel em, Scheduler s) {
        ack.onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                Ack next;
                Ack ack = next = (Ack)((Success)try_).value();
                Ack.Continue$ continue$ = Ack.Continue$.MODULE$;
                if (!(ack != null ? !ack.equals(continue$) : continue$ != null) && !c.isCanceled()) {
                    package$.MODULE$.blocking((Function0)((JFunction0.mcV.sp & Serializable)() -> this.reschedule$$anonfun$1$$anonfun$1(b, out, c, em, s)));
                }
            } else if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                this.reportFailure(ex, (UncaughtExceptionReporter)s);
            } else {
                throw new MatchError((Object)try_);
            }
        }, (ExecutionContext)s);
    }

    private void fastLoop(char[] buffer, Subscriber<char[]> out, BooleanCancelable c, ExecutionModel em, int syncIndex, Scheduler s) {
        block12: {
            boolean streamErrors;
            Throwable errorThrown;
            CharsReaderObservable charsReaderObservable;
            block11: {
                int nextIndex;
                Ack.Continue$ ack;
                charsReaderObservable = this;
                int n = syncIndex;
                while (true) {
                    int n2;
                    errorThrown = null;
                    ack = Ack.Continue$.MODULE$;
                    streamErrors = true;
                    try {
                        Future<Ack> future;
                        int length = charsReaderObservable.fillBuffer(charsReaderObservable.in, buffer, charsReaderObservable.fillBuffer$default$3());
                        streamErrors = false;
                        if (length >= 0) {
                            char[] next = Arrays.copyOf(buffer, length);
                            future = out.onNext(next);
                        } else {
                            out.onComplete();
                            future = Ack.Stop$.MODULE$;
                        }
                        ack = future;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable ex = throwable2 = throwable;
                        if (NonFatal$.MODULE$.apply(ex)) {
                            errorThrown = ex;
                        }
                        throw throwable;
                    }
                    if (errorThrown != null) break block11;
                    Ack.Continue$ continue$ = ack;
                    Ack.Continue$ continue$2 = Ack.Continue$.MODULE$;
                    if (!(continue$ != null ? !continue$.equals(continue$2) : continue$2 != null)) {
                        n2 = em.nextFrameIndex(n);
                    } else {
                        Ack.Continue$ continue$3 = ack;
                        Ack.Stop$ stop$ = Ack.Stop$.MODULE$;
                        n2 = !(continue$3 != null ? !continue$3.equals(stop$) : stop$ != null) ? -1 : (nextIndex = 0);
                    }
                    if (c.isCanceled()) break block12;
                    if (nextIndex <= 0) break;
                    CharsReaderObservable charsReaderObservable2 = charsReaderObservable;
                    int n3 = nextIndex;
                    charsReaderObservable = charsReaderObservable2;
                    n = n3;
                }
                if (nextIndex == 0) {
                    charsReaderObservable.reschedule((Future<Ack>)ack, buffer, out, c, em, s);
                }
                break block12;
            }
            if (streamErrors) {
                charsReaderObservable.sendError(out, errorThrown, (UncaughtExceptionReporter)s);
            } else {
                charsReaderObservable.reportFailure(errorThrown, (UncaughtExceptionReporter)s);
            }
        }
    }

    private int fillBuffer(Reader in, char[] buffer, int nTotalCharsRead) {
        int n;
        block2: {
            int nCharsRead;
            CharsReaderObservable charsReaderObservable = this;
            int n2 = nTotalCharsRead;
            while (true) {
                if (n2 >= buffer.length) {
                    n = n2;
                    break block2;
                }
                nCharsRead = in.read(buffer, n2, buffer.length - n2);
                if (nCharsRead < 0) break;
                CharsReaderObservable charsReaderObservable2 = charsReaderObservable;
                int n3 = n2 + nCharsRead;
                charsReaderObservable = charsReaderObservable2;
                n2 = n3;
            }
            n = n2 <= 0 ? nCharsRead : n2;
        }
        return n;
    }

    private int fillBuffer$default$3() {
        return 0;
    }

    private void sendError(Subscriber<Nothing$> out, Throwable e, UncaughtExceptionReporter s) {
        try {
            out.onError(e);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e2 = throwable3 = (Throwable)option.get();
                this.reportFailure(Platform$.MODULE$.composeErrors(e, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Throwable[]{e2})), s);
            }
            throw throwable;
        }
    }

    private void reportFailure(Throwable e, UncaughtExceptionReporter s) {
        s.reportFailure(e);
        try {
            this.in.close();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = (Throwable)option.get();
            }
            throw throwable;
        }
    }

    private static final String $init$$$anonfun$1() {
        return "chunkSize > 0";
    }

    private final void reschedule$$anonfun$1$$anonfun$1(char[] b$2, Subscriber out$2, BooleanCancelable c$2, ExecutionModel em$2, Scheduler s$2) {
        this.fastLoop(b$2, out$2, c$2, em$2, 0, s$2);
    }
}

