/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.subjects;

import java.io.Serializable;
import monix.execution.Ack;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.atomic.AtomicAny;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.AtomicBuilder$;
import monix.execution.atomic.PaddingStrategy;
import monix.reactive.observers.Subscriber;
import monix.reactive.subjects.AsyncSubject$;
import monix.reactive.subjects.PublishSubject;
import monix.reactive.subjects.PublishSubject$State$;
import monix.reactive.subjects.Subject;
import scala.Function0;
import scala.collection.immutable.Set;
import scala.runtime.java8.JFunction0;

public final class AsyncSubject<A>
extends Subject<A, A> {
    private final AtomicAny<PublishSubject.State<A>> stateRef;
    private boolean onNextHappened;
    private A cachedElem;

    public static <A> AsyncSubject<A> apply() {
        return AsyncSubject$.MODULE$.apply();
    }

    public AsyncSubject() {
        PublishSubject.State initialValue$proxy1 = PublishSubject$State$.MODULE$.apply(PublishSubject$State$.MODULE$.$lessinit$greater$default$1(), (Subscriber[])PublishSubject$State$.MODULE$.$lessinit$greater$default$2(), PublishSubject$State$.MODULE$.$lessinit$greater$default$3());
        AtomicBuilder builder$proxy1 = AtomicBuilder$.MODULE$.AtomicRefBuilder();
        this.stateRef = (AtomicAny)builder$proxy1.buildInstance(initialValue$proxy1, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
        this.onNextHappened = false;
    }

    @Override
    public int size() {
        return ((PublishSubject.State)this.stateRef.get()).subscribers().size();
    }

    public Ack onNext(A elem) {
        Ack.Stop$ stop$;
        if (((PublishSubject.State)this.stateRef.get()).isDone()) {
            stop$ = Ack.Stop$.MODULE$;
        } else {
            if (!this.onNextHappened) {
                this.onNextHappened = true;
            }
            this.cachedElem = elem;
            stop$ = Ack.Continue$.MODULE$;
        }
        return (Ack)stop$;
    }

    @Override
    public void onError(Throwable ex) {
        this.onCompleteOrError(ex);
    }

    @Override
    public void onComplete() {
        this.onCompleteOrError(null);
    }

    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<A> subscriber) {
        Cancelable cancelable;
        block5: {
            Set subscribers;
            PublishSubject.State update;
            PublishSubject.State state;
            AsyncSubject asyncSubject = this;
            do {
                if ((subscribers = (state = (PublishSubject.State)asyncSubject.stateRef.get()).subscribers()) != null) continue;
                Throwable errorThrown = state.errorThrown();
                if (errorThrown != null) {
                    subscriber.onError(errorThrown);
                    cancelable = Cancelable$.MODULE$.empty();
                } else if (asyncSubject.onNextHappened) {
                    subscriber.onNext(asyncSubject.cachedElem);
                    subscriber.onComplete();
                    cancelable = Cancelable$.MODULE$.empty();
                } else {
                    subscriber.onComplete();
                    cancelable = Cancelable$.MODULE$.empty();
                }
                break block5;
            } while (!asyncSubject.stateRef.compareAndSet((Object)state, update = PublishSubject$State$.MODULE$.apply((Set)subscribers.$plus(subscriber), (Subscriber[])PublishSubject$State$.MODULE$.$lessinit$greater$default$2(), PublishSubject$State$.MODULE$.$lessinit$greater$default$3())));
            cancelable = Cancelable$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> asyncSubject.unsubscribe(subscriber));
        }
        return cancelable;
    }

    private void onCompleteOrError(Throwable ex) {
        block4: {
            Set subscribers;
            PublishSubject.State state;
            AsyncSubject asyncSubject = this;
            do {
                boolean isDone;
                boolean bl = isDone = (subscribers = (state = (PublishSubject.State)asyncSubject.stateRef.get()).subscribers()) == null;
                if (isDone) break block4;
            } while (!asyncSubject.stateRef.compareAndSet((Object)state, state.complete(ex)));
            for (Subscriber ref : subscribers) {
                if (ex != null) {
                    ref.onError(ex);
                    continue;
                }
                if (asyncSubject.onNextHappened) {
                    ref.onNext(asyncSubject.cachedElem);
                    ref.onComplete();
                    continue;
                }
                ref.onComplete();
            }
        }
    }

    private void unsubscribe(Subscriber<A> s) {
        PublishSubject.State update;
        PublishSubject.State current;
        AsyncSubject asyncSubject = this;
        while ((current = (PublishSubject.State)asyncSubject.stateRef.get()).subscribers() != null && !asyncSubject.stateRef.compareAndSet((Object)current, update = current.copy((Set)current.subscribers().$minus(s), current.copy$default$2(), current.copy$default$3()))) {
        }
    }
}

