/*
 * Decompiled with CFR 0.152.
 */
package ambience.themes.designer;

import ambience.theme.FileId;
import ambience.theme.FileId$;
import ambience.theme.FilePath$;
import ambience.themes.designer.FileHelper$;
import com.elixirtech.codex.CodexFilter;
import com.elixirtech.codex.CodexUpdate;
import com.elixirtech.webserver.ETag$;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.UUID;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonBoolean$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class DBUtil$
implements Serializable {
    private static final String DeleteSuffix;
    public static final DBUtil$ MODULE$;

    private DBUtil$() {
    }

    static {
        MODULE$ = new DBUtil$();
        DeleteSuffix = "-deleted";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DBUtil$.class);
    }

    public String DeleteSuffix() {
        return DeleteSuffix;
    }

    public String newId() {
        return FileId$.MODULE$.apply(UUID.randomUUID().toString());
    }

    public long now() {
        return Calendar.getInstance().getTimeInMillis();
    }

    public CodexFilter withFileId(String id) {
        return this.withId(id);
    }

    public CodexFilter withFileIds(Set<FileId> ids) {
        return CodexFilter.In$.MODULE$.apply("_id", (Set)((IterableOps)ids.map((Function1 & Serializable)_$1 -> _$1 == null ? null : ((FileId)_$1).value())).map((Function1 & Serializable)_$2 -> BsonString$.MODULE$.apply(_$2)));
    }

    public CodexFilter withThemeId(String id) {
        return this.withId(id);
    }

    public CodexFilter withThemeThemeId(String id) {
        return CodexFilter.Eq$.MODULE$.apply("themeId", (BsonValue)BsonString$.MODULE$.apply(id));
    }

    public CodexFilter withId(String id) {
        return CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(id));
    }

    public CodexFilter active() {
        return CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.Eq$.MODULE$.apply("active", (BsonValue)BsonBoolean$.MODULE$.apply(true)), CodexFilter.Eq$.MODULE$.apply("enabled", (BsonValue)BsonBoolean$.MODULE$.apply(true))}));
    }

    public String buildHash(byte[] bytes) {
        return ETag$.MODULE$.computeETag(bytes);
    }

    public CodexUpdate deleteAction(String uniqueKey) {
        return CodexUpdate.Rename$.MODULE$.apply(uniqueKey, uniqueKey + this.DeleteSuffix());
    }

    public CodexUpdate undeleteAction(String uniqueKey) {
        return CodexUpdate.Rename$.MODULE$.apply(uniqueKey + this.DeleteSuffix(), uniqueKey);
    }

    public CodexFilter withPath(String path) {
        return CodexFilter.Eq$.MODULE$.apply("path", (BsonValue)BsonString$.MODULE$.apply(path));
    }

    public Document toDoc(String themeId, Path path, boolean inWebFolder) {
        String relativePath = FileHelper$.MODULE$.normalisePath(FileHelper$.MODULE$.toRelativePath(path).toString());
        return this.toDoc(themeId, this.newId(), FilePath$.MODULE$.apply(relativePath), FileHelper$.MODULE$.readBytes(path), inWebFolder, (Option<Object>)None$.MODULE$);
    }

    public Document toDoc(String themeId, String id, String path, byte[] bytes, boolean inWebFolder, Option<Object> updated) {
        BsonDocument doc = new BsonDocument();
        doc.append("_id", (BsonValue)new BsonString(id));
        doc.append("themeId", (BsonValue)new BsonString(themeId));
        doc.append("path", (BsonValue)new BsonString(FileHelper$.MODULE$.normalisePath(path)));
        doc.append("bytes", (BsonValue)new BsonBinary(bytes));
        doc.append("inWebFolder", (BsonValue)new BsonBoolean(inWebFolder));
        updated.foreach((Function1 & Serializable)ts -> doc.append("updated", (BsonValue)new BsonDateTime(BoxesRunTime.unboxToLong((Object)ts))));
        return Document$.MODULE$.apply(doc);
    }
}

