/*
 * Decompiled with CFR 0.152.
 */
package ambience.themes.management;

import ambience.module.UserDB;
import ambience.themes.designer.DBUtil$;
import ambience.themes.management.DocManager$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LogMessage$None$;
import com.elixirtech.arch.LoggingMixin;
import com.elixirtech.codex.CodexCollection;
import com.elixirtech.codex.CodexFilter;
import com.elixirtech.codex.CodexFindOptions;
import com.elixirtech.codex.CodexFindOptions$;
import com.elixirtech.codex.CodexIndex;
import com.elixirtech.codex.CodexUpdate;
import com.mongodb.DuplicateKeyException;
import io.circe.Json;
import io.circe.Json$;
import io.circe.ParsingFailure;
import java.io.Serializable;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler$;
import monocle.POptional;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public abstract class DocManager {
    public static POptional<Json, Json, Object, Object> ActiveLens() {
        return DocManager$.MODULE$.ActiveLens();
    }

    public static String DeleteSuffix() {
        return DocManager$.MODULE$.DeleteSuffix();
    }

    public static POptional<Json, Json, Object, Object> EnabledLens() {
        return DocManager$.MODULE$.EnabledLens();
    }

    public static POptional<Json, Json, String, String> IdLens() {
        return DocManager$.MODULE$.IdLens();
    }

    public static CodexUpdate deleteAction() {
        return DocManager$.MODULE$.deleteAction();
    }

    public static String extension() {
        return DocManager$.MODULE$.extension();
    }

    public static CodexFilter themeExists() {
        return DocManager$.MODULE$.themeExists();
    }

    public static CodexUpdate undeleteAction() {
        return DocManager$.MODULE$.undeleteAction();
    }

    public static String uniqueKey() {
        return DocManager$.MODULE$.uniqueKey();
    }

    public static CodexFilter withId(BsonString bsonString) {
        return DocManager$.MODULE$.withId(bsonString);
    }

    public static CodexFilter withId(String string) {
        return DocManager$.MODULE$.withId(string);
    }

    public static CodexFilter withName(String string) {
        return DocManager$.MODULE$.withName(string);
    }

    public static CodexFilter withThemeId(String string) {
        return DocManager$.MODULE$.withThemeId(string);
    }

    public DocManager() {
        this.cltnT().flatMap((Function1 & Serializable)cltn -> this.setupUniqueColumn((CodexCollection)cltn, DocManager$.MODULE$.uniqueKey()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        })).runToFuture(Scheduler$.MODULE$.global());
    }

    public abstract Task<CodexCollection> cltnT();

    public Task<BoxedUnit> setupUniqueColumn(CodexCollection cltn, String uniqueKey) {
        return cltn.createIndexT((CodexIndex)CodexIndex.Ascending$.MODULE$.apply(uniqueKey, CodexIndex.Ascending$.MODULE$.$lessinit$greater$default$2(), CodexIndex.Ascending$.MODULE$.$lessinit$greater$default$3())).onErrorHandle((Function1)(JProcedure1 & Serializable)x$1 -> {
            Throwable throwable = x$1;
            if (throwable instanceof DuplicateKeyException) {
                return;
            }
            Throwable ex = throwable;
            throw ex;
        });
    }

    public Task<Json> get() {
        Some some = Some$.MODULE$.apply((Object)CodexFindOptions.Ascending$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{DocManager$.MODULE$.uniqueKey()})));
        Option option = CodexFindOptions$.MODULE$.$lessinit$greater$default$1();
        Option option2 = CodexFindOptions$.MODULE$.$lessinit$greater$default$3();
        Option option3 = CodexFindOptions$.MODULE$.$lessinit$greater$default$4();
        CodexFindOptions opts = CodexFindOptions$.MODULE$.apply(option, (Option)some, option2, option3);
        return this.cltnT().flatMap((Function1 & Serializable)cltn -> cltn.findO(DocManager$.MODULE$.themeExists(), opts).toListL().map((Function1 & Serializable)reply -> {
            Either either = io.circe.parser.package$.MODULE$.parse(reply.map((Function1 & Serializable)_$1 -> _$1.toJson()).mkString("[", ",", "]"));
            if (either instanceof Left) {
                ParsingFailure err = (ParsingFailure)((Left)either).value();
                ((LoggingMixin)this).log().error(() -> DocManager.get$$anonfun$1$$anonfun$1$$anonfun$2(err), Line$.MODULE$.apply(68), FullName$.MODULE$.apply("ambience.themes.management.DocManager.get"));
                return Json$.MODULE$.fromValues((Iterable)package$.MODULE$.Nil());
            }
            if (either instanceof Right) {
                Json json = (Json)((Right)either).value();
                return json;
            }
            throw new MatchError((Object)either);
        }).map((Function1 & Serializable)json -> json));
    }

    public Task<Option<Json>> get(String uuid) {
        return this.cltnT().flatMap((Function1 & Serializable)cltn -> cltn.findOneO((CodexFilter)CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(uuid))).toListL().map((Function1 & Serializable)doc2 -> doc2.headOption().flatMap((Function1 & Serializable)doc -> io.circe.parser.package$.MODULE$.parse(doc.toJson()).toOption())).map((Function1 & Serializable)json -> json));
    }

    public Task<Either<LogMessage, Json>> save(UserDB.User user, Json json) {
        Tuple2 tuple2;
        Document doc = Document$.MODULE$.apply(json.noSpaces());
        Either unpacked = this.extractId(doc).flatMap((Function1 & Serializable)optId -> this.extractKey(doc).map((Function1 & Serializable)key -> Tuple2$.MODULE$.apply(optId, key)));
        Either either = unpacked;
        if (either instanceof Left) {
            LogMessage msg2 = (LogMessage)((Left)either).value();
            return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)msg2));
        }
        if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
            Option optId2 = (Option)tuple2._1();
            BsonValue key = (BsonValue)tuple2._2();
            Option option = optId2;
            if (option instanceof Some) {
                BsonString id = (BsonString)((Some)option).value();
                return this.update(user, id, key, doc).map((Function1 & Serializable)msg -> package$.MODULE$.Left().apply(msg));
            }
            if (None$.MODULE$.equals(option)) {
                return this.add(user, key, doc).map((Function1 & Serializable)reply -> reply.map((Function1 & Serializable)doc -> this.docToJson((Document)doc)));
            }
            throw new MatchError((Object)option);
        }
        throw new MatchError((Object)either);
    }

    public Json docToJson(Document doc) {
        Either either = io.circe.parser.package$.MODULE$.parse(doc.toJson());
        if (either instanceof Left) {
            ParsingFailure err = (ParsingFailure)((Left)either).value();
            throw new IllegalStateException("Unable to parse Bson as Json: " + err);
        }
        if (either instanceof Right) {
            Json json = (Json)((Right)either).value();
            return json;
        }
        throw new MatchError((Object)either);
    }

    public Task<LogMessage> delete(String uuid) {
        ((LoggingMixin)this).log().info(() -> DocManager.delete$$anonfun$1(uuid), Line$.MODULE$.apply(109), FullName$.MODULE$.apply("ambience.themes.management.DocManager.delete"));
        return this.cltnT().flatMap((Function1 & Serializable)cltn -> cltn.updateOneT(DocManager$.MODULE$.withId(uuid), DocManager$.MODULE$.deleteAction()).map((Function1 & Serializable)_$2 -> LogMessage$None$.MODULE$).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return LogMessage.ErrorEx$.MODULE$.apply("Delete failed", ex);
            }
        }).map((Function1 & Serializable)json -> json));
    }

    public Task<LogMessage> undelete(String uuid) {
        ((LoggingMixin)this).log().info(() -> DocManager.undelete$$anonfun$1(uuid), Line$.MODULE$.apply(120), FullName$.MODULE$.apply("ambience.themes.management.DocManager.undelete"));
        return this.cltnT().flatMap((Function1 & Serializable)cltn -> cltn.updateOneT(DocManager$.MODULE$.withId(uuid), DocManager$.MODULE$.undeleteAction()).map((Function1 & Serializable)_$3 -> LogMessage$None$.MODULE$).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return LogMessage.ErrorEx$.MODULE$.apply("Undelete failed", ex);
            }
        }).map((Function1 & Serializable)json -> json));
    }

    public Task<Either<LogMessage, Document>> add(UserDB.User user, BsonValue key, Document doc) {
        ((LoggingMixin)this).log().info(() -> DocManager.add$$anonfun$1(key), Line$.MODULE$.apply(131), FullName$.MODULE$.apply("ambience.themes.management.DocManager.add"));
        BsonString id = BsonString$.MODULE$.apply(UUID.randomUUID().toString());
        long ts = DBUtil$.MODULE$.now();
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)id), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"lastModifiedBy");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonString$.MODULE$.apply(user.name())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"lastModified");
        objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonDateTime$.MODULE$.apply(ts)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        Document finalDoc = (Document)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return this.cltnT().flatMap((Function1 & Serializable)cltn -> cltn.insertOneT(finalDoc).map((Function1 & Serializable)_$4 -> package$.MODULE$.Right().apply((Object)finalDoc)).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply("Add failed", ex));
            }
        }).map((Function1 & Serializable)json -> json));
    }

    public Task<LogMessage> update(UserDB.User user, BsonString id, BsonValue key, Document doc) {
        ((LoggingMixin)this).log().info(() -> DocManager.update$$anonfun$1(key), Line$.MODULE$.apply(145), FullName$.MODULE$.apply("ambience.themes.management.DocManager.update"));
        long ts = DBUtil$.MODULE$.now();
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)id), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"lastModifiedBy");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonString$.MODULE$.apply(user.name())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"lastModified");
        objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonDateTime$.MODULE$.apply(ts)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        Document finalDoc = (Document)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return this.cltnT().flatMap((Function1 & Serializable)cltn -> cltn.replaceOneT((CodexFilter)CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{DocManager$.MODULE$.withId(id), DocManager$.MODULE$.themeExists()})), finalDoc).map((Function1 & Serializable)_$5 -> LogMessage$None$.MODULE$).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return LogMessage.ErrorEx$.MODULE$.apply("Update failed", ex);
            }
        }).map((Function1 & Serializable)json -> json));
    }

    public Either<LogMessage, Option<BsonString>> extractId(Document doc) {
        Option option = doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonString) {
                BsonString s = (BsonString)bsonValue;
                return package$.MODULE$.Right().apply((Object)Some$.MODULE$.apply((Object)s));
            }
            return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Invalid id"));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Right().apply((Object)None$.MODULE$);
        }
        throw new MatchError((Object)option);
    }

    public Either<LogMessage, BsonValue> extractKey(Document doc) {
        Option option = doc.get(DocManager$.MODULE$.uniqueKey(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonString) {
                BsonString bs = (BsonString)bsonValue;
                String s = bs.getValue().trim();
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s))) {
                    return package$.MODULE$.Right().apply((Object)BsonString$.MODULE$.apply(s));
                }
                return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Empty key field"));
            }
            BsonValue x = bsonValue;
            return package$.MODULE$.Right().apply((Object)x);
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Missing key field"));
        }
        throw new MatchError((Object)option);
    }

    public String filenameExtractor(Json json) {
        String name = (String)json.hcursor().downField(DocManager$.MODULE$.uniqueKey()).focus().flatMap((Function1 & Serializable)_$6 -> _$6.asString()).getOrElse(DocManager::$anonfun$3);
        return name + DocManager$.MODULE$.extension();
    }

    private static final Object get$$anonfun$1$$anonfun$1$$anonfun$2(ParsingFailure err$1) {
        return "Error parsing BSON json output: " + err$1;
    }

    private static final Object delete$$anonfun$1(String uuid$2) {
        return "deleting " + uuid$2;
    }

    private static final Object undelete$$anonfun$1(String uuid$4) {
        return "undeleting " + uuid$4;
    }

    private static final Object add$$anonfun$1(BsonValue key$1) {
        return "inserting " + key$1;
    }

    private static final Object update$$anonfun$1(BsonValue key$2) {
        return "updating " + key$2;
    }

    private static final String $anonfun$3() {
        return "unknown";
    }
}

