/*
 * Decompiled with CFR 0.152.
 */
package ambience.themes.management;

import ambience.api.ThemeAPI;
import ambience.gravity.GravityHelper$;
import ambience.module.Module;
import ambience.module.ProjectConfig;
import ambience.module.RouteHelper$;
import ambience.module.UserDB;
import ambience.theme.ThemeId;
import ambience.theme.ThemeId$;
import ambience.theme.ThemeName;
import ambience.theme.ThemeName$;
import ambience.themes.designer.ThemeAPI$;
import ambience.themes.designer.ThemeCache$;
import ambience.themes.management.DocManager$;
import ambience.themes.management.DownloadHelper;
import ambience.themes.management.DownloadHelper$;
import ambience.themes.management.DownloadInfo;
import ambience.themes.management.DownloadInfo$;
import ambience.themes.management.ManagementUtil$;
import ambience.themes.management.ThemeManager;
import ambience.themes.management.ThemeSetEnabled$;
import ambience.themes.management.ThemesModule$;
import ambience.themes.management.UploadHelper;
import cats.Functor;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import com.elixirtech.api.AuditAPI;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LogMessage$None$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.SyncDataBytes;
import com.elixirtech.arch.param.Template;
import com.elixirtech.codex.CodexDB;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.elixirtech.gravity.GravityRoute;
import com.elixirtech.gravity.GravityRoute$;
import com.elixirtech.gravity.GravitySystem$;
import com.elixirtech.webserver.CodeLoader;
import com.elixirtech.webserver.DefaultCodeLoader;
import com.elixirtech.webserver.WebReply;
import io.circe.Decoder$;
import io.circe.Json;
import java.io.File;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonBoolean;
import org.bson.BsonString;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class ThemesModule
implements Module,
LoggingHelper2 {
    public static final long OFFSET$6 = LazyVals$.MODULE$.getOffsetStatic(ThemesModule.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$5 = LazyVals$.MODULE$.getOffsetStatic(ThemesModule.class.getDeclaredField("routes$lzy1"));
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(ThemesModule.class.getDeclaredField("route$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(ThemesModule.class.getDeclaredField("codeLoader$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(ThemesModule.class.getDeclaredField("codeLoaderOptions$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(ThemesModule.class.getDeclaredField("uploadHelper$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ThemesModule.class.getDeclaredField("themeManager$lzy1"));
    private volatile Object log$lzy1;
    private final ProjectConfig projectConfig;
    private final AuditAPI.AuditAppender auditAppender;
    private final WebReply webReply;
    private final String id;
    private final String name;
    private final String url;
    private volatile Object themeManager$lzy1;
    private volatile Object uploadHelper$lzy1;
    private volatile Object codeLoaderOptions$lzy1;
    private volatile Object codeLoader$lzy1;
    private volatile Object route$lzy1;
    private volatile Object routes$lzy1;
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(ThemesModule$.class.getDeclaredField("themeAPI$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(ThemesModule$.class.getDeclaredField("codexDB$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ThemesModule$.class.getDeclaredField("AuditComponent$lzy1"));

    public static AuditAPI.Component AuditComponent() {
        return ThemesModule$.MODULE$.AuditComponent();
    }

    public static Template Logic() {
        return ThemesModule$.MODULE$.Logic();
    }

    public static CodexDB codexDB() {
        return ThemesModule$.MODULE$.codexDB();
    }

    public static ambience.themes.designer.ThemeAPI themeAPI() {
        return ThemesModule$.MODULE$.themeAPI();
    }

    public ThemesModule(ProjectConfig projectConfig, AuditAPI.AuditAppender auditAppender, WebReply webReply) {
        this.projectConfig = projectConfig;
        this.auditAppender = auditAppender;
        this.webReply = webReply;
        this.id = "themes";
        this.name = "Themes";
        this.url = this.id() + "/index.html";
        Elixir$.MODULE$.registerInstance((Object)ThemesModule$.MODULE$.themeAPI(), ClassTag$.MODULE$.apply(ThemeAPI.class));
        webReply.addSupplier((WebReply.Supplier)ThemeCache$.MODULE$);
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ProjectConfig projectConfig() {
        return this.projectConfig;
    }

    public AuditAPI.AuditAppender auditAppender() {
        return this.auditAppender;
    }

    public WebReply webReply() {
        return this.webReply;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String url() {
        return this.url;
    }

    public ThemeManager themeManager() {
        Object object = this.themeManager$lzy1;
        if (object instanceof ThemeManager) {
            return (ThemeManager)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ThemeManager)this.themeManager$lzyINIT1();
    }

    private Object themeManager$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.themeManager$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ThemeManager themeManager = null;
                    try {
                        themeManager = new ThemeManager();
                        object2 = themeManager == null ? LazyVals.NullValue$.MODULE$ : themeManager;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.themeManager$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return themeManager;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public UploadHelper uploadHelper() {
        Object object = this.uploadHelper$lzy1;
        if (object instanceof UploadHelper) {
            return (UploadHelper)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (UploadHelper)this.uploadHelper$lzyINIT1();
    }

    private Object uploadHelper$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.uploadHelper$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    UploadHelper uploadHelper = null;
                    try {
                        uploadHelper = new UploadHelper(this.projectConfig());
                        object2 = uploadHelper == null ? LazyVals.NullValue$.MODULE$ : uploadHelper;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.uploadHelper$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return uploadHelper;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public CodeLoader.Options codeLoaderOptions() {
        Object object = this.codeLoaderOptions$lzy1;
        if (object instanceof CodeLoader.Options) {
            return (CodeLoader.Options)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CodeLoader.Options)this.codeLoaderOptions$lzyINIT1();
    }

    private Object codeLoaderOptions$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.codeLoaderOptions$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    CodeLoader.Options options = null;
                    try {
                        options = new CodeLoader.Options(this){
                            private final /* synthetic */ ThemesModule $outer;
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }

                            public String WebScript() {
                                return "js/elx-theme-client-fastopt.js";
                            }

                            public File WebRootDir() {
                                return this.$outer.projectConfig().WebRootDir();
                            }
                        };
                        object2 = options == null ? LazyVals.NullValue$.MODULE$ : options;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.codeLoaderOptions$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return options;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public DefaultCodeLoader codeLoader() {
        Object object = this.codeLoader$lzy1;
        if (object instanceof DefaultCodeLoader) {
            return (DefaultCodeLoader)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DefaultCodeLoader)this.codeLoader$lzyINIT1();
    }

    private Object codeLoader$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.codeLoader$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DefaultCodeLoader defaultCodeLoader = null;
                    try {
                        defaultCodeLoader = new DefaultCodeLoader(this.codeLoaderOptions());
                        object2 = defaultCodeLoader == null ? LazyVals.NullValue$.MODULE$ : defaultCodeLoader;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.codeLoader$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return defaultCodeLoader;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Function1<GravityRequest, Task<GravityResponse>> route() {
        Object object = this.route$lzy1;
        if (object instanceof Function1) {
            return (Function1)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Function1)this.route$lzyINIT1();
    }

    private Object route$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.route$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Function1 function1 = null;
                    try {
                        function1 = GravitySystem$.MODULE$.fromRoutes(this.routes(), GravitySystem$.MODULE$.fromRoutes$default$2());
                        object2 = function1 == null ? LazyVals.NullValue$.MODULE$ : function1;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.route$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return function1;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<GravityRoute> routes() {
        Object object = this.routes$lzy1;
        if (object instanceof List) {
            return (List)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (List)this.routes$lzyINIT1();
    }

    private Object routes$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.routes$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    List list = null;
                    try {
                        Object[] objectArray = new GravityRoute[14];
                        objectArray[0] = GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "index.html", RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> this.buildIndexHtml((UserDB.User)user)));
                        Template template = ThemesModule$.MODULE$.Logic();
                        objectArray[1] = GravityRoute$.MODULE$.pathOnly(Gravity$.MODULE$.GET(), "elx-launcher.js", RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> this.indexLauncher(template, (UserDB.User)user)));
                        objectArray[2] = GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "data/*", RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> this.getDataSeg((UserDB.User)user)));
                        objectArray[3] = GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "activate/*", RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> this.postActivateSeg((UserDB.User)user)));
                        objectArray[4] = GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "download/*", RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> this.getDownloadSeg((UserDB.User)user)));
                        objectArray[5] = GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "reload-cache", RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> this.getReloadCache((UserDB.User)user)));
                        objectArray[6] = GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "add", RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> this.postAdd((UserDB.User)user)));
                        objectArray[7] = GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "upload", RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> this.postUpload((UserDB.User)user)));
                        objectArray[8] = GravityRoute$.MODULE$.pathOnly(Gravity$.MODULE$.POST(), "set-enabled", RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> ThemeSetEnabled$.MODULE$.apply((UserDB.User)user)));
                        objectArray[9] = this.codeLoader().route();
                        objectArray[10] = GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "data", RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> this.all((UserDB.User)user)));
                        objectArray[11] = GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "data", RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> this.save((UserDB.User)user)));
                        objectArray[12] = GravityRoute$.MODULE$.pathPrefix(Gravity$.MODULE$.POST(), "data-delete", RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> this.delete((UserDB.User)user)));
                        objectArray[13] = GravityRoute$.MODULE$.pathPrefix(Gravity$.MODULE$.POST(), "data-undelete", RouteHelper$.MODULE$.withModUser(this.id(), (Function1 & Serializable)user -> this.undelete((UserDB.User)user)));
                        list = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                        object2 = list == null ? LazyVals.NullValue$.MODULE$ : list;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.routes$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.routes$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return list;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Function1<GravityRequest, Task<GravityResponse>> buildIndexHtml(UserDB.User user) {
        return (Function1 & Serializable)request -> (Task)RouteHelper$.MODULE$.buildIndexHtml((CodeLoader)this.codeLoader(), this.id(), (PartialFunction)Predef$.MODULE$.Map().empty(), user).apply(request);
    }

    public Function1<GravityRequest, Task<GravityResponse>> indexLauncher(Template template, UserDB.User user) {
        return (Function1 & Serializable)request -> {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"themeEnabled");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToBoolean((boolean)ThemeAPI$.MODULE$.ThemeEnabled()).toString());
            Map extras = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            PartialFunction lookup = extras.orElse(RouteHelper$.MODULE$.lookup((CodeLoader)this.codeLoader(), user, request));
            return Task$.MODULE$.apply(() -> ThemesModule.indexLauncher$$anonfun$1$$anonfun$1(template, lookup));
        };
    }

    public Function1<GravityRequest, Task<GravityResponse>> getDataSeg(UserDB.User user) {
        return GravityHelper$.MODULE$.seg1((Function1 & Serializable)uuid -> (Function1 & Serializable)_$1 -> this.themeManager().get(uuid.value()).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Json json = (Json)((Some)option).value();
                return GravityResponse$.MODULE$.json(json);
            }
            if (None$.MODULE$.equals(option)) {
                return Gravity$.MODULE$.NotFoundResponse();
            }
            throw new MatchError((Object)option);
        }));
    }

    public Function1<GravityRequest, Task<GravityResponse>> postActivateSeg(UserDB.User user) {
        return GravityHelper$.MODULE$.seg1((Function1 & Serializable)uuid -> (Function1 & Serializable)request -> {
            Option option = request.parameter("active").map((Function1 & Serializable)_$2 -> {
                String string = _$2;
                String string2 = "true";
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            if (option instanceof Some) {
                boolean active = BoxesRunTime.unboxToBoolean((Object)((Some)option).value());
                return this.themeManager().activate(user, uuid.value(), active).map((Function1 & Serializable)x$1 -> {
                    Either either = x$1;
                    if (either instanceof Left) {
                        LogMessage msg = (LogMessage)((Left)either).value();
                        return Gravity$.MODULE$.BadRequestResponse(msg.msg());
                    }
                    if (either instanceof Right) {
                        this.log().info(() -> ThemesModule.postActivateSeg$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(active, uuid), Line$.MODULE$.apply(109), FullName$.MODULE$.apply("ambience.themes.management.ThemesModule.postActivateSeg"));
                        return GravityResponse$.MODULE$.apply(GravityResponse$.MODULE$.$lessinit$greater$default$1(), GravityResponse$.MODULE$.$lessinit$greater$default$2(), GravityResponse$.MODULE$.$lessinit$greater$default$3());
                    }
                    throw new MatchError((Object)either);
                });
            }
            if (None$.MODULE$.equals(option)) {
                return Gravity$.MODULE$.BadRequestResponseT("Missing parameter 'active'");
            }
            throw new MatchError((Object)option);
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> postAdd(UserDB.User user) {
        return GravityHelper$.MODULE$.withJsonBody((Function1 & Serializable)json -> (Function1 & Serializable)_$3 -> {
            Tuple2 tuple2;
            Option params = this.getName((Json)json).flatMap((Function1 & Serializable)name -> this.$anonfun$1((Json)json, name == null ? null : ((ThemeName)name).value()));
            Option option = params;
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                String name2 = tuple2._1() == null ? null : ((ThemeName)tuple2._1()).value();
                String copyFrom = tuple2._2() == null ? null : ((ThemeId)tuple2._2()).value();
                return this.doAdd(user, name2, copyFrom);
            }
            if (None$.MODULE$.equals(option)) {
                this.log().warn(() -> ThemesModule.postAdd$$anonfun$1$$anonfun$1$$anonfun$1(json), Line$.MODULE$.apply(126), FullName$.MODULE$.apply("ambience.themes.management.ThemesModule.postAdd"));
                return Gravity$.MODULE$.BadRequestResponseT();
            }
            throw new MatchError((Object)option);
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> postUpload(UserDB.User user) {
        return (Function1 & Serializable)request -> {
            Option option = request.formParameter("name");
            if (option instanceof Some) {
                Gravity.FormItem formItem;
                String name = (String)((Some)option).value();
                Object object = request.formParameter("overwrite").getOrElse(ThemesModule::$anonfun$2);
                String string = "true";
                boolean isOverwrite = !(object != null ? !object.equals(string) : string != null);
                this.log().info(() -> ThemesModule.postUpload$$anonfun$1$$anonfun$1(user, name, isOverwrite), Line$.MODULE$.apply(136), FullName$.MODULE$.apply("ambience.themes.management.ThemesModule.postUpload"));
                Option option2 = request.formItems().get("file");
                if (option2 instanceof Some && (formItem = (Gravity.FormItem)((Some)option2).value()) instanceof Gravity.FileUploadItem) {
                    Gravity.FileUploadItem zipFile = (Gravity.FileUploadItem)formItem;
                    String themeName = ThemeName$.MODULE$.apply(name);
                    return this.upload(user, zipFile.data(), themeName, isOverwrite).map((Function1 & Serializable)x$1 -> {
                        Either either = x$1;
                        if (either instanceof Left) {
                            String msg = (String)((Left)either).value();
                            return Gravity$.MODULE$.BadRequestResponse(msg);
                        }
                        if (either instanceof Right) {
                            return GravityResponse$.MODULE$.apply(GravityResponse$.MODULE$.$lessinit$greater$default$1(), GravityResponse$.MODULE$.$lessinit$greater$default$2(), GravityResponse$.MODULE$.$lessinit$greater$default$3());
                        }
                        throw new MatchError((Object)either);
                    });
                }
                return Gravity$.MODULE$.BadRequestResponseT("Missing field 'file'");
            }
            if (None$.MODULE$.equals(option)) {
                return Gravity$.MODULE$.BadRequestResponseT("Missing field 'name'");
            }
            throw new MatchError((Object)option);
        };
    }

    public Function1<GravityRequest, Task<GravityResponse>> getDownloadSeg(UserDB.User user) {
        return GravityHelper$.MODULE$.seg1((Function1 & Serializable)themeId -> (Function1 & Serializable)_$4 -> this.buildSource(user, ThemeId$.MODULE$.apply(themeId.value())).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Either either = x$1;
            if (either instanceof Left) {
                String msg = (String)((Left)either).value();
                return Gravity$.MODULE$.BadRequestResponse(msg);
            }
            if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
                String themeName = tuple2._1() == null ? null : ((ThemeName)tuple2._1()).value();
                DataBytes source = (DataBytes)tuple2._2();
                Gravity.Header cdType = GravityResponse.ContentDisposition$.MODULE$.attachment(themeName + ".theme.zip");
                Gravity.Headers headers = Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{cdType}));
                int n = GravityResponse$.MODULE$.$lessinit$greater$default$1();
                return GravityResponse$.MODULE$.apply(n, headers, source);
            }
            throw new MatchError((Object)either);
        }));
    }

    public Function1<GravityRequest, Task<GravityResponse>> getReloadCache(UserDB.User user) {
        return (Function1 & Serializable)_$5 -> ThemesModule$.MODULE$.themeAPI().loadCache(ThemesModule$.MODULE$.themeAPI().loadCache$default$1()).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                String msg = (String)((Left)either).value();
                return Gravity$.MODULE$.BadRequestResponse(msg);
            }
            if (either instanceof Right) {
                return GravityResponse$.MODULE$.apply(GravityResponse$.MODULE$.$lessinit$greater$default$1(), GravityResponse$.MODULE$.$lessinit$greater$default$2(), GravityResponse$.MODULE$.$lessinit$greater$default$3());
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<GravityResponse> doAdd(UserDB.User user, String name, String copyFrom) {
        boolean isCopy = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(copyFrom.trim()));
        return ((Task)EitherT$.MODULE$.apply(this.prepareNewTheme(user, name, copyFrom)).flatMap((Function1 & Serializable)themeJson -> EitherT$.MODULE$.apply((Object)this.themeManager().save(user, (Json)themeJson).onErrorHandle((Function1 & Serializable)ex -> package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply(ex.getMessage(), ex))).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Json json = (Json)((Right)either).value();
                Object object = DocManager$.MODULE$.IdLens().getOption((Object)json).map((Function1 & Serializable)value -> new ThemeId(ThemeId$.MODULE$.apply(value))).getOrElse((Function0 & Serializable)() -> new ThemeId(ThemesModule.$anonfun$4()));
                String newThemeId = object == null ? null : ((ThemeId)object).value();
                return package$.MODULE$.Right().apply((Object)Tuple2$.MODULE$.apply((Object)new ThemeId(newThemeId), (Object)json));
            }
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                return package$.MODULE$.Left().apply((Object)msg);
            }
            throw new MatchError((Object)either);
        })).flatMap((Function1 & Serializable)pair -> EitherT$.MODULE$.apply(this.doCopyWeb(isCopy, copyFrom, pair._1() == null ? null : ((ThemeId)pair._1()).value())).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return (Json)pair._2();
        }, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value()).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                return Gravity$.MODULE$.BadRequestResponse(msg.msg());
            }
            if (either instanceof Right) {
                Json json = (Json)((Right)either).value();
                return GravityResponse$.MODULE$.json(json);
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<Either<LogMessage, BoxedUnit>> doCopyWeb(boolean isCopy, String copyFrom, String to) {
        this.log().info(() -> ThemesModule.doCopyWeb$$anonfun$1(isCopy), Line$.MODULE$.apply(195), FullName$.MODULE$.apply("ambience.themes.management.ThemesModule.doCopyWeb"));
        if (isCopy) {
            this.log().info(() -> ThemesModule.doCopyWeb$$anonfun$2(copyFrom, to), Line$.MODULE$.apply(197), FullName$.MODULE$.apply("ambience.themes.management.ThemesModule.doCopyWeb"));
            return this.themeManager().copyWebFiles(copyFrom, to).flatMap((Function1 & Serializable)_$6 -> ThemesModule$.MODULE$.themeAPI().loadCache(ThemesModule$.MODULE$.themeAPI().loadCache$default$1())).map((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    String msg = (String)((Left)either).value();
                    return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply(msg));
                }
                if (either instanceof Right) {
                    return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                }
                throw new MatchError((Object)either);
            }).onErrorHandle((Function1 & Serializable)ex -> package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply(ex.getMessage(), ex)));
        }
        return Task$.MODULE$.unit().map((Function1 & Serializable)_$7 -> package$.MODULE$.Right().apply(_$7));
    }

    public Task<Either<LogMessage, Json>> prepareNewTheme(UserDB.User user, String name, String copyFrom) {
        if (copyFrom.isEmpty()) {
            return Task$.MODULE$.now((Object)package$.MODULE$.Right().apply((Object)ManagementUtil$.MODULE$.blankTheme(user, name)));
        }
        return this.themeManager().get(copyFrom).map((Function1 & Serializable)reply -> package$.MODULE$.Right().apply(reply.map(ManagementUtil$.MODULE$.copy(user, name)).getOrElse(() -> this.prepareNewTheme$$anonfun$1$$anonfun$1(copyFrom, user, name)))).onErrorHandle((Function1 & Serializable)ex -> package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply(ex.getMessage(), ex)));
    }

    public Task<Either<String, BoxedUnit>> upload(UserDB.User user, SyncDataBytes zipFile, String themeName, boolean overwrite) {
        return (Task)EitherT$.MODULE$.apply(this.overwriteTheme(overwrite, user, themeName)).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return EitherT$.MODULE$.apply(this.buildNewTheme(user, themeName)).flatMap((Function1 & Serializable)themeId -> this.upload$$anonfun$1$$anonfun$1(zipFile, themeId == null ? null : ((ThemeId)themeId).value()), (Monad)Task$.MODULE$.catsAsync());
        }, (Monad)Task$.MODULE$.catsAsync()).value();
    }

    public Task<Either<String, BoxedUnit>> overwriteTheme(boolean overwrite, UserDB.User user, String themeName) {
        if (overwrite) {
            return (Task)EitherT$.MODULE$.apply(this.deleteTheme(user, themeName)).flatMap((Function1 & Serializable)delInfoOpt -> EitherT$.MODULE$.apply(this.handleDeleteTheme(user, (Option<Tuple2<ThemeId, Object>>)delInfoOpt)).map((Function1)(JProcedure1 & Serializable)result -> {}, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value();
        }
        return Task$.MODULE$.now((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
    }

    public Task<Either<String, Option<Tuple2<ThemeId, Object>>>> deleteTheme(UserDB.User user, String themeName) {
        return this.themeManager().deleteByThemeName(themeName).map((Function1 & Serializable)_$8 -> _$8.map((Function1 & Serializable)doc -> Option$.MODULE$.apply(doc).flatMap((Function1 & Serializable)_$9 -> _$9.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class))).map((Function1 & Serializable)v -> new ThemeId(ThemeId$.MODULE$.apply(v.getValue()))).flatMap((Function1 & Serializable)themeId -> ThemesModule.deleteTheme$$anonfun$1$$anonfun$1$$anonfun$3(doc, themeId == null ? null : ((ThemeId)themeId).value()))).left().map((Function1 & Serializable)_$12 -> _$12.msg()));
    }

    public Task<Either<String, BoxedUnit>> handleDeleteTheme(UserDB.User user, Option<Tuple2<ThemeId, Object>> info) {
        Tuple2 tuple2;
        Option<Tuple2<ThemeId, Object>> option = info;
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.now((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
        }
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            String themeId = tuple2._1() == null ? null : ((ThemeId)tuple2._1()).value();
            return ThemesModule$.MODULE$.themeAPI().deleteAll(user, themeId);
        }
        throw new MatchError(option);
    }

    public Task<Either<String, ThemeId>> buildNewTheme(UserDB.User user, String themeName) {
        return this.themeManager().save(user, ManagementUtil$.MODULE$.blankTheme(user, themeName)).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                LogMessage m = (LogMessage)((Left)either).value();
                return package$.MODULE$.Left().apply((Object)m.msg());
            }
            if (either instanceof Right) {
                Json json = (Json)((Right)either).value();
                return (Either)this.getThemeId(json, this.getThemeId$default$2()).map((Function1 & Serializable)_$13 -> ThemesModule.buildNewTheme$$anonfun$1$$anonfun$1(_$13 == null ? null : ((ThemeId)_$13).value())).getOrElse(ThemesModule::buildNewTheme$$anonfun$1$$anonfun$2);
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<Either<String, Tuple2<ThemeName, DataBytes>>> buildSource(UserDB.User user, String themeId) {
        return (Task)EitherT$.MODULE$.apply(this.getFileInfo(user, themeId)).flatMap((Function1 & Serializable)di -> EitherT$.MODULE$.apply(DownloadHelper$.MODULE$.run((DownloadInfo)di)).flatMap((Function1 & Serializable)fi -> EitherT$.MODULE$.apply(this.buildDataBytesResult((DownloadHelper.DownloadFileInfo)fi)).map((Function1 & Serializable)result -> result, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value();
    }

    public Task<Either<String, Tuple2<ThemeName, DataBytes>>> buildDataBytesResult(DownloadHelper.DownloadFileInfo info) {
        return Task$.MODULE$.apply(() -> ThemesModule.buildDataBytesResult$$anonfun$1(info)).map((Function1 & Serializable)s -> package$.MODULE$.Right().apply((Object)Tuple2$.MODULE$.apply((Object)new ThemeName(info.themeName()), s)));
    }

    public Task<Either<String, DownloadInfo>> getFileInfo(UserDB.User user, String themeId) {
        return this.themeManager().get(themeId).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)("Theme not found with id " + new ThemeId(themeId)));
            }
            if (option instanceof Some) {
                Json json = (Json)((Some)option).value();
                Option<ThemeName> option2 = this.getName(json);
                if (option2 instanceof Some) {
                    Object object = ((Some)option2).value();
                    String themeName = object == null ? null : ((ThemeName)object).value();
                    return package$.MODULE$.Right().apply((Object)DownloadInfo$.MODULE$.apply(themeId, themeName));
                }
                if (None$.MODULE$.equals(option2)) {
                    return package$.MODULE$.Left().apply((Object)("Problem reading Theme name from json: " + json));
                }
                throw new MatchError(option2);
            }
            throw new MatchError((Object)option);
        });
    }

    public Option<ThemeName> getName(Json json) {
        return json.hcursor().downField("name").as(Decoder$.MODULE$.decodeString()).toOption().map((Function1 & Serializable)value -> new ThemeName(ThemeName$.MODULE$.apply(value)));
    }

    public Option<ThemeId> getThemeId(Json json, String field) {
        return json.hcursor().downField(field).as(Decoder$.MODULE$.decodeString()).toOption().map((Function1 & Serializable)value -> new ThemeId(ThemeId$.MODULE$.apply(value)));
    }

    public String getThemeId$default$2() {
        return "_id";
    }

    public Function1<GravityRequest, Task<GravityResponse>> all(UserDB.User user) {
        return (Function1 & Serializable)_$14 -> this.themeManager().get(user).map((Function1 & Serializable)j -> GravityResponse$.MODULE$.json(j));
    }

    public Function1<GravityRequest, Task<GravityResponse>> save(UserDB.User user) {
        return GravityHelper$.MODULE$.withJsonBody((Function1 & Serializable)json -> (Function1 & Serializable)_$15 -> this.themeManager().save(user, (Json)json).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Json json = (Json)((Right)either).value();
                return GravityResponse$.MODULE$.json(json);
            }
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                return this.toResponse(msg);
            }
            throw new MatchError((Object)either);
        }));
    }

    public Function1<GravityRequest, Task<GravityResponse>> delete(UserDB.User user) {
        return GravityHelper$.MODULE$.seg1((Function1 & Serializable)hexId -> (Function1 & Serializable)_$16 -> this.themeManager().delete(user, hexId.value()).map((Function1 & Serializable)msg -> this.toResponse((LogMessage)msg)));
    }

    public Function1<GravityRequest, Task<GravityResponse>> undelete(UserDB.User user) {
        return GravityHelper$.MODULE$.seg1((Function1 & Serializable)hexId -> (Function1 & Serializable)_$17 -> this.themeManager().undelete(user, hexId.value()).map((Function1 & Serializable)msg -> this.toResponse((LogMessage)msg)));
    }

    private GravityResponse toResponse(LogMessage msg) {
        LogMessage logMessage = msg;
        if (LogMessage$None$.MODULE$.equals(logMessage)) {
            return GravityResponse$.MODULE$.apply(GravityResponse$.MODULE$.$lessinit$greater$default$1(), GravityResponse$.MODULE$.$lessinit$greater$default$2(), GravityResponse$.MODULE$.$lessinit$greater$default$3());
        }
        return Gravity$.MODULE$.BadRequestResponse(msg.msg());
    }

    private String safeId(String s) {
        return StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)ch -> ThemesModule.safeId$$anonfun$1(BoxesRunTime.unboxToChar((Object)ch)));
    }

    private static final GravityResponse indexLauncher$$anonfun$1$$anonfun$1(Template template$3, PartialFunction lookup$1) {
        return GravityResponse$.MODULE$.javascript(template$3.substitute(lookup$1.lift()));
    }

    private static final Object postActivateSeg$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(boolean active$2, Gravity.Segment uuid$4) {
        return "active set to " + active$2 + " for id " + uuid$4;
    }

    private final /* synthetic */ Option $anonfun$1(Json json$2, String name) {
        return this.getThemeId(json$2, "copyFrom").map((Function1 & Serializable)copyFrom -> Tuple2$.MODULE$.apply((Object)new ThemeName(name), (Object)new ThemeId(copyFrom == null ? null : ((ThemeId)copyFrom).value())));
    }

    private static final Object postAdd$$anonfun$1$$anonfun$1$$anonfun$1(Json json$3) {
        return "Unable to add - bad json: " + json$3.noSpaces();
    }

    private static final String $anonfun$2() {
        return "false";
    }

    private static final Object postUpload$$anonfun$1$$anonfun$1(UserDB.User user$8, String name$2, boolean isOverwrite$1) {
        return "upload by " + user$8.name() + " parameters: name=" + name$2 + ", overwrite=" + isOverwrite$1;
    }

    private static final String $anonfun$4() {
        return ThemeId$.MODULE$.apply("");
    }

    private static final Object doCopyWeb$$anonfun$1(boolean isCopy$3) {
        return "doCopyWeb " + isCopy$3;
    }

    private static final Object doCopyWeb$$anonfun$2(String copyFrom$3, String to$1) {
        return "Copying Web files from " + new ThemeId(copyFrom$3) + " to " + new ThemeId(to$1);
    }

    private static final Object prepareNewTheme$$anonfun$1$$anonfun$1$$anonfun$1(String copyFrom$6) {
        return "Can't locate theme " + new ThemeId(copyFrom$6) + ", using blank";
    }

    private final Json prepareNewTheme$$anonfun$1$$anonfun$1(String copyFrom$5, UserDB.User user$13, String name$4) {
        this.log().warn(() -> ThemesModule.prepareNewTheme$$anonfun$1$$anonfun$1$$anonfun$1(copyFrom$5), Line$.MODULE$.apply(217), FullName$.MODULE$.apply("ambience.themes.management.ThemesModule.prepareNewTheme"));
        return ManagementUtil$.MODULE$.blankTheme(user$13, name$4);
    }

    private final /* synthetic */ EitherT upload$$anonfun$1$$anonfun$1(SyncDataBytes zipFile$2, String themeId) {
        return EitherT$.MODULE$.apply(this.uploadHelper().run(zipFile$2, themeId)).map((Function1)(JProcedure1 & Serializable)result -> {}, (Functor)Task$.MODULE$.catsAsync());
    }

    private static final /* synthetic */ Option deleteTheme$$anonfun$1$$anonfun$1$$anonfun$3(Document doc$1, String themeId) {
        return Option$.MODULE$.apply((Object)doc$1).flatMap((Function1 & Serializable)_$10 -> _$10.get("active", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBoolean.class))).map((Function1 & Serializable)_$11 -> _$11.getValue()).map((Function1 & Serializable)active -> Tuple2$.MODULE$.apply((Object)new ThemeId(themeId), (Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)active))));
    }

    private static final /* synthetic */ Right buildNewTheme$$anonfun$1$$anonfun$1(String _$13) {
        return package$.MODULE$.Right().apply((Object)new ThemeId(_$13));
    }

    private static final Either buildNewTheme$$anonfun$1$$anonfun$2() {
        return package$.MODULE$.Left().apply((Object)"ThemeId not found");
    }

    private static final DataBytes buildDataBytesResult$$anonfun$1(DownloadHelper.DownloadFileInfo info$1) {
        return DataBytes$.MODULE$.apply(info$1.path().toFile());
    }

    private static final /* synthetic */ boolean safeId$$anonfun$1(char ch) {
        return RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(ch)) || ch == '-';
    }
}

