/*
 * Decompiled with CFR 0.152.
 */
package ambience.themes.management;

import ambience.module.ProjectConfig;
import ambience.theme.FileId$;
import ambience.themes.designer.FileHelper$;
import ambience.themes.designer.WebDB$;
import ambience.themes.management.ManagementUtil$;
import ambience.themes.management.ThemeZip;
import ambience.themes.management.ThemeZip$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.SyncDataBytes;
import java.io.File;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function1;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Either;
import sourcecode.FullName$;
import sourcecode.Line$;

public class UploadHelper
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(UploadHelper.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final ProjectConfig projectConfig;

    public UploadHelper(ProjectConfig projectConfig) {
        this.projectConfig = projectConfig;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<Either<String, BoxedUnit>> run(SyncDataBytes zipFile, String themeId) {
        List files = ThemeZip$.MODULE$.apply(zipFile).filter((Function1 & Serializable)tf -> this.filter((ThemeZip.ThemeFile)tf));
        List docs = files.map((Function1 & Serializable)file -> this.toDocument(themeId, FileId$.MODULE$.apply(ManagementUtil$.MODULE$.newId()), (ThemeZip.ThemeFile)file));
        this.log().info(() -> UploadHelper.run$$anonfun$1(docs), Line$.MODULE$.apply(20), FullName$.MODULE$.apply("ambience.themes.management.UploadHelper.run"));
        Iterator tasks = docs.grouped(FileHelper$.MODULE$.batchSize()).map((Function1 & Serializable)_$1 -> WebDB$.MODULE$.batchInsert((List<Document>)_$1));
        return Task$.MODULE$.sequence((Iterable)tasks.toList(), BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1 & Serializable)_$2 -> package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).onErrorHandle((Function1 & Serializable)ex -> {
            this.log().error(() -> UploadHelper.run$$anonfun$3$$anonfun$1(ex), ex, Line$.MODULE$.apply(23), FullName$.MODULE$.apply("ambience.themes.management.UploadHelper.run"));
            return package$.MODULE$.Left().apply((Object)"Error inserting data");
        });
    }

    public Document toDocument(String themeId, String id, ThemeZip.ThemeFile tf) {
        BsonDocument doc = new BsonDocument();
        doc.append("_id", (BsonValue)new BsonString(id));
        doc.append("themeId", (BsonValue)new BsonString(themeId));
        doc.append("path", (BsonValue)new BsonString(tf.path().toRelativeString()));
        doc.append("bytes", (BsonValue)new BsonBinary(tf.content()));
        doc.append("inWebFolder", (BsonValue)new BsonBoolean(this.inWebFolder(tf)));
        return Document$.MODULE$.apply(doc);
    }

    public boolean inWebFolder(ThemeZip.ThemeFile tf) {
        return new File(this.projectConfig.WebRootDir(), tf.path().toRelativeString()).exists();
    }

    public boolean filter(ThemeZip.ThemeFile tf) {
        String p = tf.path().toString();
        this.log().info(() -> UploadHelper.filter$$anonfun$1(p), Line$.MODULE$.apply(44), FullName$.MODULE$.apply("ambience.themes.management.UploadHelper.filter"));
        return !tf.isDirectory() && !p.startsWith("/__MACOSX") && !p.endsWith(".DS_Store");
    }

    private static final Object run$$anonfun$1(List docs$1) {
        return "inserting " + docs$1.size() + " files";
    }

    private static final Object run$$anonfun$3$$anonfun$1(Throwable ex$1) {
        return "Error inserting data: " + ex$1;
    }

    private static final Object filter$$anonfun$1(String p$1) {
        return p$1;
    }
}

