/*
 * Decompiled with CFR 0.152.
 */
package ambience.scheduler;

import ambience.api.Jobs;
import ambience.api.Lifecycle;
import ambience.api.Notifications;
import ambience.api.Notifications$;
import ambience.api.ReportEngine;
import ambience.module.UserDB;
import ambience.module.UserDB$;
import ambience.notify.ProductionNotifications$;
import ambience.scheduler.Collections$;
import ambience.scheduler.ETLTriggerResult;
import ambience.scheduler.ETLTriggerResult$;
import ambience.scheduler.Firing$;
import ambience.scheduler.FiringComputer;
import ambience.scheduler.FiringComputer$;
import ambience.scheduler.Model;
import ambience.scheduler.ReportTriggerResult;
import ambience.scheduler.ReportTriggerResult$;
import ambience.scheduler.RunReportRequest;
import ambience.scheduler.RunReportRequest$;
import ambience.scheduler.TriggerResult;
import ambience.scheduler.WaitForDatabaseRecovery$;
import ambience.scheduler.report.ReportUtils$;
import com.elixirtech.arch.Clock;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.Finished;
import com.elixirtech.arch.Finished$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.codex.CodexDB;
import com.elixirtech.codex.CodexFilter;
import com.elixirtech.codex.CodexUpdate;
import com.mongodb.MongoTimeoutException;
import io.circe.Json;
import io.circe.ParsingFailure;
import io.circe.parser.package$;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class Firing
implements Runnable,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Firing.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final Clock clock;
    private final FiringComputer fc;
    private final Model.TriggerIdName tidn;
    private final Scheduler scheduler;

    public static DateTimeFormatter Formatter() {
        return Firing$.MODULE$.Formatter();
    }

    public static Notifications.Source NotificationsSource() {
        return Firing$.MODULE$.NotificationsSource();
    }

    public static Json condenseForUserConsumption(Jobs.JobDefinition jobDefinition) {
        return Firing$.MODULE$.condenseForUserConsumption(jobDefinition);
    }

    public static String formatTS(long l) {
        return Firing$.MODULE$.formatTS(l);
    }

    public Firing(Clock clock, FiringComputer fc, Model.TriggerIdName tidn) {
        this.clock = clock;
        this.fc = fc;
        this.tidn = tidn;
        this.scheduler = fc.scheduler();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public void run() {
        ((Lifecycle)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Lifecycle.class))).runJob(this.doRun()).runAsyncAndForget(this.scheduler());
    }

    public Task<BoxedUnit> doRun() {
        this.log().info(this::doRun$$anonfun$1, Line$.MODULE$.apply(60), FullName$.MODULE$.apply("ambience.scheduler.Firing.doRun"));
        return this.fc.okToStart(this.tidn).flatMap((Function1 & Serializable)okToStart -> this.doRun$$anonfun$2(BoxesRunTime.unboxToBoolean((Object)okToStart))).onErrorHandleWith((Function1 & Serializable)x$1 -> {
            Throwable throwable = x$1;
            if (throwable instanceof FiringException) {
                FiringException ex2 = (FiringException)throwable;
                this.log().error(() -> this.doRun$$anonfun$3$$anonfun$1(ex2), Line$.MODULE$.apply(79), FullName$.MODULE$.apply("ambience.scheduler.Firing.doRun"));
                return this.fc.forceInProgressFalse(this.tidn);
            }
            if (throwable instanceof MongoTimeoutException) {
                MongoTimeoutException ex3 = (MongoTimeoutException)throwable;
                this.log().error(this::doRun$$anonfun$3$$anonfun$2, Line$.MODULE$.apply(82), FullName$.MODULE$.apply("ambience.scheduler.Firing.doRun"));
                return WaitForDatabaseRecovery$.MODULE$.apply(this.fc, this.tidn, (Throwable)ex3);
            }
            if (throwable != null) {
                Throwable ex4 = throwable;
                this.log().error(() -> this.doRun$$anonfun$3$$anonfun$3(ex4), ex4, Line$.MODULE$.apply(85), FullName$.MODULE$.apply("ambience.scheduler.Firing.doRun"));
                return this.fc.forceInProgressFalse(this.tidn).onErrorHandle((Function1)(JProcedure1 & Serializable)ex -> {});
            }
            throw new MatchError((Object)throwable);
        });
    }

    public Task<Model.Trigger> getTrigger() {
        return Collections$.MODULE$.triggersCltnT().flatMap((Function1 & Serializable)_$1 -> _$1.findO((CodexFilter)CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(this.tidn._id()))).firstOptionL()).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Document doc = (Document)((Some)option).value();
                Option<Model.Trigger> option2 = FiringComputer$.MODULE$.toTrigger(doc);
                if (option2 instanceof Some) {
                    Model.Trigger trigger = (Model.Trigger)((Some)option2).value();
                    return Task$.MODULE$.now((Object)trigger);
                }
                if (None$.MODULE$.equals(option2)) {
                    return this.error("Can't parse trigger " + this.tidn._id());
                }
                throw new MatchError(option2);
            }
            if (None$.MODULE$.equals(option)) {
                return this.error("Can't load trigger " + this.tidn._id() + " (" + this.tidn.name() + ")");
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<BoxedUnit> handleTriggerResult(UserDB.User user, TriggerResult result) {
        TriggerResult triggerResult = result;
        if (triggerResult instanceof ETLTriggerResult) {
            Jobs.JobDefinition jobDefinition;
            ETLTriggerResult eTLTriggerResult = ETLTriggerResult$.MODULE$.unapply((ETLTriggerResult)triggerResult);
            Jobs.JobDefinition jobDef = jobDefinition = eTLTriggerResult._1();
            String string = jobDef.status();
            String string2 = "Completed";
            if (string == null ? string2 != null : !string.equals(string2)) {
                return this.notifyOwnerAndProductionManagers(user, jobDef);
            }
            return Task$.MODULE$.unit();
        }
        if (triggerResult instanceof ReportTriggerResult) {
            ReportTriggerResult reportTriggerResult = ReportTriggerResult$.MODULE$.unapply((ReportTriggerResult)triggerResult);
            Either<ReportEngine.Error, ReportEngine.Report> either = reportTriggerResult._1();
            Either<ReportEngine.Error, ReportEngine.Report> result2 = either;
            Either<ReportEngine.Error, ReportEngine.Report> either2 = result2;
            if (either2 instanceof Right) {
                return Task$.MODULE$.unit();
            }
            if (either2 instanceof Left) {
                ReportEngine.Error err = (ReportEngine.Error)((Left)either2).value();
                return Task$.MODULE$.unit();
            }
            throw new MatchError(either2);
        }
        throw new MatchError((Object)triggerResult);
    }

    public Task<BoxedUnit> notifyOwnerAndProductionManagers(UserDB.User user, Jobs.JobDefinition jobDef) {
        Notifications.SimpleMessage msg = Notifications.SimpleMessage$.MODULE$.apply("Scheduled ETL failed. Trigger: " + this.tidn.name(), String.valueOf(Firing$.MODULE$.condenseForUserConsumption(jobDef).spaces2()));
        return (!this.isProductionManager(user) ? Notifications$.MODULE$.notify(user, (Notifications.Level)Notifications.Error$.MODULE$, Firing$.MODULE$.NotificationsSource(), (Notifications.Message)msg) : Task$.MODULE$.unit()).flatMap((Function1 & Serializable)x$12 -> {
            Object object = x$12;
            return ProductionNotifications$.MODULE$.send((Notifications.Level)Notifications.Error$.MODULE$, Firing$.MODULE$.NotificationsSource(), (Notifications.Message)msg).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        });
    }

    public boolean isProductionManager(UserDB.User user) {
        if (!ProductionNotifications$.MODULE$.ProductionMode()) {
            return false;
        }
        return user.privileges().contains((Object)"mod-production-manager");
    }

    public Task<TriggerResult> runNow(UserDB.User user) {
        return ((Lifecycle)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Lifecycle.class))).runJob(this.doRunNow(user));
    }

    public Task<TriggerResult> doRunNow(UserDB.User user) {
        this.log().info(this::doRunNow$$anonfun$1, Line$.MODULE$.apply(145), FullName$.MODULE$.apply("ambience.scheduler.Firing.doRunNow"));
        return this.fc.okToRunNow(this.tidn).flatMap((Function1 & Serializable)okToRunNow -> this.doRunNow$$anonfun$2(user, BoxesRunTime.unboxToBoolean((Object)okToRunNow))).onErrorHandleWith((Function1 & Serializable)x$1 -> {
            Throwable throwable = x$1;
            if (throwable instanceof IllegalStateException) {
                IllegalStateException ex = (IllegalStateException)throwable;
                this.log().warn(() -> Firing.doRunNow$$anonfun$3$$anonfun$1(ex), Line$.MODULE$.apply(162), FullName$.MODULE$.apply("ambience.scheduler.Firing.doRunNow"));
                return Task$.MODULE$.raiseError((Throwable)ex);
            }
            if (throwable instanceof FiringException) {
                FiringException ex = (FiringException)throwable;
                this.log().error(() -> this.doRunNow$$anonfun$3$$anonfun$2(ex), Line$.MODULE$.apply(165), FullName$.MODULE$.apply("ambience.scheduler.Firing.doRunNow"));
                return this.fc.forceInProgressFalse(this.tidn).flatMap((Function1 & Serializable)_$2 -> Task$.MODULE$.raiseError((Throwable)ex));
            }
            if (throwable != null) {
                Throwable ex = throwable;
                this.log().error(() -> this.doRunNow$$anonfun$3$$anonfun$4(ex), ex, Line$.MODULE$.apply(168), FullName$.MODULE$.apply("ambience.scheduler.Firing.doRunNow"));
                return this.fc.forceInProgressFalse(this.tidn).flatMap((Function1 & Serializable)_$3 -> Task$.MODULE$.raiseError(ex));
            }
            throw new MatchError((Object)throwable);
        });
    }

    public <T> Task<T> error(String msg) {
        return Task$.MODULE$.raiseError((Throwable)new FiringException(msg));
    }

    public Task<Json> parseParams(Model.Trigger t) {
        Either either = package$.MODULE$.parse(t.job().parameters());
        if (either instanceof Right) {
            Json params = (Json)((Right)either).value();
            return Task$.MODULE$.now((Object)params);
        }
        if (either instanceof Left) {
            ParsingFailure err = (ParsingFailure)((Left)either).value();
            return this.error("Trigger " + t.name() + " has unparseable parameters: " + t.job().parameters() + ": " + err);
        }
        throw new MatchError((Object)either);
    }

    public Task<UserDB.User> getUser(Model.Trigger t) {
        return UserDB$.MODULE$.filterEnabled(((UserDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(UserDB.class))).getUserById(t.owner())).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                UserDB.User user = (UserDB.User)((Some)option).value();
                return Task$.MODULE$.now((Object)user);
            }
            if (None$.MODULE$.equals(option)) {
                return this.error("Trigger " + t.name() + " owner not available: " + t.owner());
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<TriggerResult> runJob(UserDB.User user, Model.Trigger t, Json params, String mode) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(t.job().report()))) {
            RunReportRequest runRequest = RunReportRequest$.MODULE$.apply(t.job().report(), t.job().mimeType(), params, mode);
            return ReportUtils$.MODULE$.runReportJob(user, t, runRequest);
        }
        Jobs.RunRequest runRequest = Jobs.RunRequest$.MODULE$.apply(t.job().chainset(), t.job().chain(), params, (Option)None$.MODULE$, mode);
        return this.runETLJob(user, runRequest);
    }

    public Task<TriggerResult> runETLJob(UserDB.User user, Jobs.RunRequest runRequest) {
        Jobs jobModule = (Jobs)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Jobs.class));
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.runETLJob$$anonfun$1();
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return jobModule.runBatch(user, runRequest, (Function1 & Serializable)jobDef -> this.addTriggerInfo((Jobs.JobDefinition)jobDef)).flatMap((Function1 & Serializable)jobDef -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
                this.runETLJob$$anonfun$2$$anonfun$2$$anonfun$1((Jobs.JobDefinition)jobDef);
                return BoxedUnit.UNIT;
            }).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.addTriggerInfo((Jobs.JobDefinition)jobDef).map((Function1 & Serializable)x$1 -> {
                    Finished finished = x$1;
                    return ETLTriggerResult$.MODULE$.apply((Jobs.JobDefinition)jobDef);
                });
            }));
        });
    }

    public Task<Finished> addTriggerInfo(Jobs.JobDefinition jobDef) {
        CodexUpdate.Combine updates = CodexUpdate.Combine$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{CodexUpdate.Set$.MODULE$.apply("triggerId", (BsonValue)BsonString$.MODULE$.apply(this.tidn._id())), CodexUpdate.Set$.MODULE$.apply("triggerName", (BsonValue)BsonString$.MODULE$.apply(this.tidn.name()))}));
        return Collections$.MODULE$.etlJobsCltnT().flatMap((Function1 & Serializable)_$4 -> _$4.updateOneT((CodexFilter)CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(jobDef.id())), (CodexUpdate)updates).map((Function1)(JProcedure1 & Serializable)reply -> {
            if (reply.getMatchedCount() != 1L) {
                this.log().warn(() -> Firing.addTriggerInfo$$anonfun$1$$anonfun$1$$anonfun$1(jobDef), Line$.MODULE$.apply(219), FullName$.MODULE$.apply("ambience.scheduler.Firing.addTriggerInfo"));
                this.log().info(() -> Firing.addTriggerInfo$$anonfun$1$$anonfun$1$$anonfun$2(reply), Line$.MODULE$.apply(220), FullName$.MODULE$.apply("ambience.scheduler.Firing.addTriggerInfo"));
                Task task = Collections$.MODULE$.etlJobsCltnT().flatMap((Function1 & Serializable)_$5 -> _$5.findO((CodexFilter)CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(jobDef.id()))).toListL());
                List docs = (List)Await$.MODULE$.result((Awaitable)task.runToFuture(this.scheduler()), (Duration)FiniteDuration$.MODULE$.apply(10L, scala.concurrent.duration.package$.MODULE$.SECONDS()));
                this.log().info(() -> Firing.addTriggerInfo$$anonfun$1$$anonfun$1$$anonfun$3(docs), Line$.MODULE$.apply(223), FullName$.MODULE$.apply("ambience.scheduler.Firing.addTriggerInfo"));
                return;
            }
        }).map((Function1 & Serializable)_$6 -> Finished$.MODULE$));
    }

    private final Object doRun$$anonfun$1() {
        return "Firing " + this.tidn.name();
    }

    private static final Object doRun$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(Model.Trigger trigger$3, UserDB.User user$2) {
        return "Trigger " + trigger$3.name() + " is ok to run for owner " + user$2.name();
    }

    private final void doRun$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(Model.Trigger trigger$2, UserDB.User user$1) {
        this.log().info(() -> Firing.doRun$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(trigger$2, user$1), Line$.MODULE$.apply(67), FullName$.MODULE$.apply("ambience.scheduler.Firing.doRun"));
    }

    private final long doRun$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1() {
        return this.clock.now();
    }

    private final /* synthetic */ Task doRun$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2(Model.Trigger trigger$5, UserDB.User user$4, long startTime) {
        return this.parseParams(trigger$5).flatMap((Function1 & Serializable)params -> this.runJob(user$4, trigger$5, (Json)params, "scheduled").flatMap((Function1 & Serializable)triggerResult -> this.fc.onStop(trigger$5, startTime).flatMap((Function1 & Serializable)x$12 -> {
            Finished finished = x$12;
            return this.handleTriggerResult(user$4, (TriggerResult)triggerResult).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        })));
    }

    private final /* synthetic */ Task doRun$$anonfun$2(boolean okToStart) {
        if (okToStart) {
            return this.getTrigger().flatMap((Function1 & Serializable)trigger -> this.getUser((Model.Trigger)trigger).flatMap((Function1 & Serializable)user -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
                this.doRun$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1((Model.Trigger)trigger, (UserDB.User)user);
                return BoxedUnit.UNIT;
            }).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Task$.MODULE$.apply(this::doRun$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1).flatMap((Function1 & Serializable)startTime -> this.doRun$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2((Model.Trigger)trigger, (UserDB.User)user, BoxesRunTime.unboxToLong((Object)startTime)));
            })));
        }
        return Task$.MODULE$.unit();
    }

    private final Object doRun$$anonfun$3$$anonfun$1(FiringException ex$1) {
        return "Trigger " + this.tidn.name() + " FiringException: " + ex$1.getMessage();
    }

    private final Object doRun$$anonfun$3$$anonfun$2() {
        return "Trigger " + this.tidn.name() + " [MongoTimeoutException]";
    }

    private final Object doRun$$anonfun$3$$anonfun$3(Throwable ex$2) {
        return "Trigger " + this.tidn.name() + " Unexpected exception: " + ex$2;
    }

    private final Object doRunNow$$anonfun$1() {
        return "Firing " + this.tidn.name() + " now";
    }

    private static final Object doRunNow$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(Model.Trigger trigger$9, UserDB.User user$9) {
        return "Trigger " + trigger$9.name() + " is ok to run now for user " + user$9.name();
    }

    private final void doRunNow$$anonfun$2$$anonfun$1$$anonfun$1(Model.Trigger trigger$8, UserDB.User user$8) {
        this.log().info(() -> Firing.doRunNow$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(trigger$8, user$8), Line$.MODULE$.apply(151), FullName$.MODULE$.apply("ambience.scheduler.Firing.doRunNow"));
    }

    private final long doRunNow$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1() {
        return this.clock.now();
    }

    private final /* synthetic */ Task doRunNow$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2(Model.Trigger trigger$11, UserDB.User user$13, long startTime) {
        return this.parseParams(trigger$11).flatMap((Function1 & Serializable)params -> this.runJob(user$13, trigger$11, (Json)params, "run-now").flatMap((Function1 & Serializable)result -> this.fc.onStop(trigger$11, startTime).map((Function1 & Serializable)x$1 -> {
            Finished finished = x$1;
            return result;
        })));
    }

    private final /* synthetic */ Task doRunNow$$anonfun$2(UserDB.User user$10, boolean okToRunNow) {
        if (okToRunNow) {
            return this.getTrigger().flatMap((Function1 & Serializable)trigger -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
                this.doRunNow$$anonfun$2$$anonfun$1$$anonfun$1((Model.Trigger)trigger, user$10);
                return BoxedUnit.UNIT;
            }).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Task$.MODULE$.apply(this::doRunNow$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1).flatMap((Function1 & Serializable)startTime -> this.doRunNow$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2((Model.Trigger)trigger, user$10, BoxesRunTime.unboxToLong((Object)startTime)));
            }));
        }
        return Task$.MODULE$.raiseError((Throwable)new IllegalStateException("Trigger " + this.tidn.name() + " okToRunNow check failed"));
    }

    private static final Object doRunNow$$anonfun$3$$anonfun$1(IllegalStateException ex$3) {
        return ex$3.getMessage();
    }

    private final Object doRunNow$$anonfun$3$$anonfun$2(FiringException ex$4) {
        return "Trigger " + this.tidn.name() + " FiringException: " + ex$4.getMessage();
    }

    private final Object doRunNow$$anonfun$3$$anonfun$4(Throwable ex$6) {
        return "Trigger " + this.tidn.name() + " Unexpected exception: " + ex$6;
    }

    private final Object runETLJob$$anonfun$1$$anonfun$1() {
        return "Trigger " + this.tidn.name() + " runBatch starting";
    }

    private final void runETLJob$$anonfun$1() {
        this.log().info(this::runETLJob$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(203), FullName$.MODULE$.apply("ambience.scheduler.Firing.runETLJob"));
    }

    private final Object runETLJob$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(Jobs.JobDefinition jobDef$2) {
        return "Trigger " + this.tidn.name() + " completed successfully jobId=" + new Jobs.JobId(jobDef$2.id());
    }

    private final void runETLJob$$anonfun$2$$anonfun$2$$anonfun$1(Jobs.JobDefinition jobDef$1) {
        this.log().info(() -> this.runETLJob$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(jobDef$1), Line$.MODULE$.apply(205), FullName$.MODULE$.apply("ambience.scheduler.Firing.runETLJob"));
    }

    private static final Object addTriggerInfo$$anonfun$1$$anonfun$1$$anonfun$1(Jobs.JobDefinition jobDef$7) {
        return "addTriggerInfo: unable to set trigger information into " + new Jobs.JobId(jobDef$7.id());
    }

    private static final Object addTriggerInfo$$anonfun$1$$anonfun$1$$anonfun$2(CodexDB.UpdateResult reply$1) {
        return "reply has matchedCount=" + reply$1.getMatchedCount() + " modifiedCount=" + reply$1.getModifiedCount();
    }

    private static final Object addTriggerInfo$$anonfun$1$$anonfun$1$$anonfun$3(List docs$1) {
        return "Check for id returns " + docs$1.size() + " records";
    }

    public static class FiringException
    extends Exception {
        public FiringException(String msg) {
            super(msg);
        }
    }
}

