/*
 * Decompiled with CFR 0.152.
 */
package ambience.scheduler;

import ambience.module.UserDB;
import ambience.scheduler.Firing;
import ambience.scheduler.Model;
import ambience.scheduler.SchedulerModule;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import scala.Function0;
import scala.Function1;
import scala.concurrent.duration.FiniteDuration$;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class RunNow$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(RunNow$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final Scheduler scheduler;
    public static final RunNow$ MODULE$;

    private RunNow$() {
    }

    static {
        MODULE$ = new RunNow$();
        scheduler = Scheduler$.MODULE$.global();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RunNow$.class);
    }

    public Scheduler scheduler() {
        return scheduler;
    }

    public Task<BoxedUnit> byId(SchedulerModule schedulerModule, UserDB.User user, String triggerId) {
        Task tTrigger = this.logInfo("Request to run with id " + triggerId + " by " + user.name()).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return schedulerModule.triggerManager().loadTrigger(triggerId).flatMap((Function1 & Serializable)trigger -> MODULE$.ensureNotInProgress((Model.Trigger)trigger).map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return trigger;
            }));
        }).memoize();
        this.run(schedulerModule, user, (Task<Model.Trigger>)tTrigger);
        return tTrigger.delayExecution(FiniteDuration$.MODULE$.apply(1L, package$.MODULE$.SECONDS())).map((Function1)(JProcedure1 & Serializable)_$1 -> {});
    }

    public Task<BoxedUnit> byName(SchedulerModule schedulerModule, UserDB.User user, String triggerName) {
        Task tTrigger = this.logInfo("Request to run with name " + triggerName + " by " + user.name()).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return schedulerModule.triggerManager().loadTriggerByName(triggerName).flatMap((Function1 & Serializable)trigger -> MODULE$.ensureNotInProgress((Model.Trigger)trigger).map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return trigger;
            }));
        }).memoize();
        this.run(schedulerModule, user, (Task<Model.Trigger>)tTrigger);
        return tTrigger.delayExecution(FiniteDuration$.MODULE$.apply(1L, package$.MODULE$.SECONDS())).map((Function1)(JProcedure1 & Serializable)_$2 -> {});
    }

    public void run(SchedulerModule schedulerModule, UserDB.User user, Task<Model.Trigger> tTrigger) {
        Task batchRun = tTrigger.flatMap((Function1 & Serializable)trigger -> MODULE$.logInfo("Running " + trigger.name() + " (" + trigger._id() + ") for " + user.name()).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Model.TriggerIdName tidn = Model.TriggerIdName$.MODULE$.apply((String)trigger._id().getOrElse(RunNow$::$anonfun$4), trigger.name());
            Firing firing = new Firing(schedulerModule.clock(), schedulerModule.firingComputer(), tidn);
            return firing.runNow(user).flatMap((Function1 & Serializable)triggerResult -> MODULE$.logInfo("Running " + trigger.name() + " " + triggerResult.optId().map((Function1 & Serializable)id -> "as job: " + id).getOrElse(RunNow$::$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$2)).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }));
        }));
        batchRun.runAsyncAndForget(this.scheduler());
    }

    public Task<BoxedUnit> ensureNotInProgress(Model.Trigger trigger) {
        if (trigger.status().inProgress()) {
            return Task$.MODULE$.raiseError((Throwable)new IllegalStateException("Trigger " + trigger.name() + " in progress"));
        }
        return Task$.MODULE$.now((Object)BoxedUnit.UNIT);
    }

    public Task<BoxedUnit> logInfo(String msg) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            RunNow$.logInfo$$anonfun$1(msg);
            return BoxedUnit.UNIT;
        });
    }

    private static final String $anonfun$4() {
        throw new RuntimeException("Trigger has no _id");
    }

    private static final String $anonfun$3$$anonfun$1$$anonfun$1$$anonfun$2() {
        return "";
    }

    private static final Object logInfo$$anonfun$1$$anonfun$1(String msg$2) {
        return msg$2;
    }

    private static final void logInfo$$anonfun$1(String msg$1) {
        MODULE$.log().info(() -> RunNow$.logInfo$$anonfun$1$$anonfun$1(msg$1), Line$.MODULE$.apply(55), FullName$.MODULE$.apply("ambience.scheduler.RunNow.logInfo"));
    }
}

