/*
 * Decompiled with CFR 0.152.
 */
package ambience.scheduler.trigger;

import ambience.scheduler.CalendarModel;
import ambience.scheduler.Model;
import ambience.scheduler.SchedulerModule$;
import ambience.scheduler.SchedulerUtil$;
import ambience.scheduler.calendar.CalendarState;
import ambience.scheduler.calendar.CalendarTester$;
import ambience.scheduler.trigger.TriggerCalc$;
import ambience.scheduler.trigger.TriggerCalc$Completed$;
import ambience.scheduler.trigger.TriggerCalc$CronError$;
import ambience.scheduler.trigger.TriggerCalc$NextTime$;
import ambience.scheduler.util.CronExp;
import com.elixirtech.arch.Clock;
import com.elixirtech.arch.LoggingInterface;
import java.io.Serializable;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class TriggerCalc {
    private final Clock clock;
    private final Model.Trigger trigger;
    private final CalendarState calendarState;
    private final List calendarsIn;
    private final List calendarsOut;
    private final ZoneId zoneId;
    private final ZonedDateTime startTime;
    private final ZonedDateTime endTime;
    private final String cronString;
    private final Either maybeCronExp;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(TriggerCalc$.class.getDeclaredField("log$lzy1"));

    public static LoggingInterface log() {
        return TriggerCalc$.MODULE$.log();
    }

    public TriggerCalc(Clock clock, Model.Trigger trigger, CalendarState calendarState) {
        this.clock = clock;
        this.trigger = trigger;
        this.calendarState = calendarState;
        this.calendarsIn = trigger.constraints().calendarsInclusive().flatMap((Function1 & Serializable)id -> calendarState.get((String)id));
        this.calendarsOut = trigger.constraints().calendarsExclusive().flatMap((Function1 & Serializable)id -> calendarState.get((String)id));
        this.zoneId = (ZoneId)this.opts(trigger.constraints().timeZone()).map((Function1 & Serializable)x$0 -> ZoneId.of(x$0)).getOrElse(TriggerCalc::$init$$$anonfun$4);
        this.startTime = this.getDateTime(clock.now());
        this.endTime = this.startTime().plusYears(Int$.MODULE$.int2long(SchedulerModule$.MODULE$.WindowYears()));
        this.cronString = SchedulerUtil$.MODULE$.cronExpression(trigger.info().cron());
        this.maybeCronExp = SchedulerUtil$.MODULE$.buildCronExpression(this.cronString(), this.zoneId());
    }

    public List<CalendarModel.Calendar> calendarsIn() {
        return this.calendarsIn;
    }

    public List<CalendarModel.Calendar> calendarsOut() {
        return this.calendarsOut;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    public ZonedDateTime startTime() {
        return this.startTime;
    }

    public ZonedDateTime endTime() {
        return this.endTime;
    }

    public String cronString() {
        return this.cronString;
    }

    public Either<ParseException, CronExp> maybeCronExp() {
        return this.maybeCronExp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result run() {
        Result result;
        TriggerCalc$.MODULE$.log().info(this::run$$anonfun$1, Line$.MODULE$.apply(42), FullName$.MODULE$.apply("ambience.scheduler.trigger.TriggerCalc.run"));
        if (!this.trigger.enabled()) return TriggerCalc$Completed$.MODULE$;
        ZonedDateTime afterTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.clock.now()), this.zoneId());
        Either<ParseException, CronExp> either = this.maybeCronExp();
        if (either instanceof Right) {
            CronExp cronExp = (CronExp)((Right)either).value();
            Option<ZonedDateTime> option = this.getFireTimeAfter(cronExp, afterTime);
            if (option instanceof Some) {
                ZonedDateTime result2 = (ZonedDateTime)((Some)option).value();
                result = TriggerCalc$NextTime$.MODULE$.apply(Model.Instant$.MODULE$.apply(result2.toInstant().toEpochMilli()));
                return result;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                result = TriggerCalc$Completed$.MODULE$;
            }
            return result;
        } else {
            if (!(either instanceof Left)) throw new MatchError(either);
            ParseException err = (ParseException)((Left)either).value();
            result = TriggerCalc$CronError$.MODULE$.apply(err.getMessage());
        }
        return result;
    }

    public final Option<ZonedDateTime> getFireTimeAfter(CronExp cronExp, ZonedDateTime afterTime) {
        Option option;
        while (true) {
            if (afterTime.isAfter(this.endTime())) {
                return None$.MODULE$;
            }
            Option solution = cronExp.getTimeAfter(this.constrain(afterTime)).flatMap((Function1 & Serializable)d -> {
                if (d.isAfter(this.endTime())) {
                    return None$.MODULE$;
                }
                return Some$.MODULE$.apply(d);
            });
            option = solution;
            if (!(option instanceof Some)) break;
            ZonedDateTime zdt = (ZonedDateTime)((Some)option).value();
            if (this.isTimeAllowed(zdt)) {
                return Some$.MODULE$.apply((Object)zdt);
            }
            afterTime = zdt;
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    private ZonedDateTime constrain(ZonedDateTime d) {
        if (this.startTime().isAfter(d)) {
            return this.startTime();
        }
        return d;
    }

    private boolean isTimeAllowed(ZonedDateTime timestamp) {
        return this.calendarsIn().forall((Function1 & Serializable)calendar -> CalendarTester$.MODULE$.matches((CalendarModel.Calendar)calendar, timestamp)) && this.calendarsOut().forall((Function1 & Serializable)calendar -> !CalendarTester$.MODULE$.matches((CalendarModel.Calendar)calendar, timestamp));
    }

    private ZonedDateTime getDateTime(long ms) {
        return Instant.ofEpochMilli(ms).atZone(this.zoneId());
    }

    private Option<String> opts(String s) {
        if (s.isEmpty()) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)s);
    }

    private static final ZoneId $init$$$anonfun$4() {
        return ZoneId.systemDefault();
    }

    private final Object run$$anonfun$1() {
        return "testing calendars" + (" in=" + ((IterableOnceOps)this.calendarsIn().map((Function1 & Serializable)_$1 -> _$1.name()).sorted((Ordering)Ordering.String$.MODULE$)).mkString(",")) + (" out=" + ((IterableOnceOps)this.calendarsOut().map((Function1 & Serializable)_$2 -> _$2.name()).sorted((Ordering)Ordering.String$.MODULE$)).mkString(","));
    }

    public static final class CronError
    implements Result,
    Product,
    Serializable {
        private final String msg;

        public static CronError apply(String string) {
            return TriggerCalc$CronError$.MODULE$.apply(string);
        }

        public static CronError fromProduct(Product product) {
            return TriggerCalc$CronError$.MODULE$.fromProduct(product);
        }

        public static CronError unapply(CronError cronError) {
            return TriggerCalc$CronError$.MODULE$.unapply(cronError);
        }

        public CronError(String msg) {
            this.msg = msg;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CronError)) return false;
            CronError cronError = (CronError)object;
            String string = this.msg();
            String string2 = cronError.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CronError;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "CronError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "msg";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String msg() {
            return this.msg;
        }

        public CronError copy(String msg) {
            return new CronError(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class NextTime
    implements Result,
    Product,
    Serializable {
        private final Model.Instant value;

        public static NextTime apply(Model.Instant instant) {
            return TriggerCalc$NextTime$.MODULE$.apply(instant);
        }

        public static NextTime fromProduct(Product product) {
            return TriggerCalc$NextTime$.MODULE$.fromProduct(product);
        }

        public static NextTime unapply(NextTime nextTime) {
            return TriggerCalc$NextTime$.MODULE$.unapply(nextTime);
        }

        public NextTime(Model.Instant value) {
            this.value = value;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NextTime)) return false;
            NextTime nextTime = (NextTime)object;
            Model.Instant instant = this.value();
            Model.Instant instant2 = nextTime.value();
            if (instant != null) {
                if (!instant.equals(instant2)) return false;
                return true;
            }
            if (instant2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof NextTime;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "NextTime";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Model.Instant value() {
            return this.value;
        }

        public NextTime copy(Model.Instant value) {
            return new NextTime(value);
        }

        public Model.Instant copy$default$1() {
            return this.value();
        }

        public Model.Instant _1() {
            return this.value();
        }
    }

    public static interface Result {
    }
}

