/*
 * Decompiled with CFR 0.152.
 */
package ambience.dataMixer.editing;

import ambience.api.Datasets;
import ambience.dataMixer.editing.DataAnalysis;
import ambience.datablend.DSPanelModel;
import ambience.datablend.parser.Parser$;
import ambience.datablend.proc.Model;
import ambience.datablend.proc.Token;
import ambience.datablend.proc.Tokenizer2;
import ambience.datablend.proc.WordFrequency;
import ambience.datablend.server.MixerData;
import ambience.datablend.server.MixerData$;
import ambience.module.UserDB;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.coredata.Data;
import io.circe.Json$;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonBoolean;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.deriving.Mirror;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Either;

public final class DataAnalysis$
implements LoggingHelper2,
Mirror.Product,
Serializable {
    private volatile Object log$lzy1;
    private volatile Object dsAPI$lzy1;
    public static final DataAnalysis$ MODULE$ = new DataAnalysis$();

    private DataAnalysis$() {
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, DataAnalysis.OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, DataAnalysis.OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, DataAnalysis.OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, DataAnalysis.OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DataAnalysis$.class);
    }

    public DataAnalysis apply(String columnDefinitions, List<String> headers, List<Model.Desc> records, int fieldCount, int rowCount, Vector<WordFrequency> wordFrequencies) {
        return new DataAnalysis(columnDefinitions, headers, records, fieldCount, rowCount, wordFrequencies);
    }

    public DataAnalysis unapply(DataAnalysis x$1) {
        return x$1;
    }

    private Datasets dsAPI() {
        Object object = this.dsAPI$lzy1;
        if (object instanceof Datasets) {
            return (Datasets)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Datasets)this.dsAPI$lzyINIT1();
    }

    private Object dsAPI$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.dsAPI$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, DataAnalysis.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Datasets datasets = null;
                    try {
                        datasets = (Datasets)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Datasets.class));
                        object2 = datasets == null ? LazyVals.NullValue$.MODULE$ : datasets;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, DataAnalysis.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.dsAPI$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, DataAnalysis.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return datasets;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, DataAnalysis.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<DataAnalysis> run(UserDB.User user, DSPanelModel.Request req) {
        return this.fetchData(user, req).flatMap((Function1 & Serializable)md -> MODULE$.analyze(req.columnDefinitions(), (MixerData)md));
    }

    public Task<List<String>> fetchSchema(UserDB.User user, String name) {
        return this.dsAPI().getSchema(user, name).map((Function1 & Serializable)schema -> schema.fields().filter((Function1 & Serializable)f -> MODULE$.keepField((Data.Field)f)).map((Function1 & Serializable)_$1 -> _$1.name()));
    }

    public Task<List<DSPanelModel.WFPair>> fetchFrequencies(UserDB.User user, String dsName, String column) {
        return this.dsAPI().buildRecords(user, dsName, Datasets.Parameters$.MODULE$.apply(Json$.MODULE$.fromValues((Iterable)package$.MODULE$.Nil()))).flatMap((Function1 & Serializable)rec -> {
            List row = rec.get(column, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(BsonValue x) {
                    BsonValue bsonValue = x;
                    if (bsonValue instanceof BsonString) {
                        BsonString s = (BsonString)bsonValue;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(BsonValue x, Function1 function1) {
                    BsonValue bsonValue = x;
                    if (bsonValue instanceof BsonString) {
                        BsonString s = (BsonString)bsonValue;
                        return s.getValue();
                    }
                    return function1.apply((Object)x);
                }
            }).toList().flatMap((Function1 & Serializable)_$2 -> Predef$.MODULE$.wrapRefArray((Object[])_$2.split(" ")));
            return Observable$.MODULE$.fromIterable((Iterable)row);
        }).toListL().map((Function1 & Serializable)words -> words.groupBy((Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x)).view().mapValues((Function1 & Serializable)_$3 -> _$3.size()).toList().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String w = (String)tuple2._1();
                int f = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return DSPanelModel.WFPair$.MODULE$.apply(w, f);
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    private Task<MixerData> fetchData(UserDB.User user, DSPanelModel.Request req) {
        String dsName = Datasets.Name$.MODULE$.apply(req.dataset());
        return this.getHeaders$1(user, dsName).flatMap((Function1 & Serializable)headers -> this.getRecords$1(user, dsName, (List)headers).map((Function1 & Serializable)records -> MixerData$.MODULE$.apply(headers, records)));
    }

    public Task<MixerData> extractData(Observable<Document> recordsO, List<String> headers) {
        return Task$.MODULE$.now(headers).flatMap((Function1 & Serializable)hdrs -> recordsO.map((Function1 & Serializable)doc -> this.extractColumns$1(headers, (Document)doc)).toListL().map((Function1 & Serializable)records -> MixerData$.MODULE$.apply(hdrs, records)));
    }

    public List<String> extractData$default$2() {
        return package$.MODULE$.List().empty();
    }

    private boolean keepField(Data.Field f) {
        if (!f.name().startsWith("_")) {
            Data.Type type = f.dataType();
            if (Data.StringType$.MODULE$.equals(type)) {
                return true;
            }
            if (Data.Int32Type$.MODULE$.equals(type)) {
                return true;
            }
            return Data.BooleanType$.MODULE$.equals(type);
        }
        return false;
    }

    private List<String> buildRecord(List<String> headers, Document document) {
        return headers.map((Function1 & Serializable)h -> {
            Option option = document.get(h, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
            if (option instanceof Some) {
                BsonValue bsonValue = (BsonValue)((Some)option).value();
                if (bsonValue instanceof BsonString) {
                    BsonString s = (BsonString)bsonValue;
                    return s.getValue();
                }
                if (bsonValue instanceof BsonInt32) {
                    BsonInt32 i = (BsonInt32)bsonValue;
                    return BoxesRunTime.boxToInteger((int)i.getValue()).toString();
                }
                if (bsonValue instanceof BsonBoolean) {
                    BsonBoolean b = (BsonBoolean)bsonValue;
                    return BoxesRunTime.boxToBoolean((boolean)b.getValue()).toString();
                }
            }
            return "";
        });
    }

    private Model.Desc describe(Tokenizer2 tok, WordFrequency[] wordFrequencies, Model.Record record) {
        Vector allTokens = (Vector)((StrictOptimizedIterableOps)record.values().zipWithIndex()).map((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                String field = (String)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                List tokens = tok.run(field);
                tokens.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Token token = x$1;
                    if (token instanceof Token.Word) {
                        String string;
                        Token.Word word = Token.Word$.MODULE$.unapply((Token.Word)token);
                        String s = string = word._1();
                        wordFrequencies[i].add(s);
                        return;
                    }
                });
                return tokens.toSet();
            }
            throw new MatchError((Object)tuple2);
        });
        return Model.Desc$.MODULE$.apply(record, allTokens);
    }

    public Task<DataAnalysis> analyze(String columnDefinitions, MixerData md) {
        int fieldCount = md.headers().size();
        WordFrequency[] wordFrequencies = (WordFrequency[])Array$.MODULE$.fill(fieldCount, DataAnalysis$::$anonfun$3, ClassTag$.MODULE$.apply(WordFrequency.class));
        Either results = Parser$.MODULE$.compile(columnDefinitions).left().map((Function1 & Serializable)errors -> {
            String msg = errors.items().mkString("[", ",", "]");
            return new RuntimeException(msg);
        });
        return Task$.MODULE$.fromEither(results).map((Function1 & Serializable)instructions -> {
            Tokenizer2 tokenizer = new Tokenizer2(instructions);
            List structure = ((List)md.rawRecords().zipWithIndex()).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    List r = (List)tuple2._1();
                    int id = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    return Model.Record$.MODULE$.apply(id, r.toVector());
                }
                throw new MatchError((Object)tuple2);
            });
            return structure.map((Function1 & Serializable)record -> MODULE$.describe(tokenizer, wordFrequencies, (Model.Record)record));
        }).map((Function1 & Serializable)rows -> MODULE$.apply(columnDefinitions, (List<String>)md.headers(), (List<Model.Desc>)rows, md.headers().size(), rows.size(), (Vector<WordFrequency>)Predef$.MODULE$.wrapRefArray((Object[])wordFrequencies).toVector()));
    }

    public DataAnalysis fromProduct(Product x$0) {
        return new DataAnalysis((String)x$0.productElement(0), (List<String>)((List)x$0.productElement(1)), (List<Model.Desc>)((List)x$0.productElement(2)), BoxesRunTime.unboxToInt((Object)x$0.productElement(3)), BoxesRunTime.unboxToInt((Object)x$0.productElement(4)), (Vector<WordFrequency>)((Vector)x$0.productElement(5)));
    }

    private final Task getHeaders$1(UserDB.User user$1, String dsName$1) {
        return this.dsAPI().getSchema(user$1, dsName$1).map((Function1 & Serializable)schema -> schema.fields().filter((Function1 & Serializable)f -> MODULE$.keepField((Data.Field)f)).map((Function1 & Serializable)_$4 -> _$4.name()));
    }

    private final Task getRecords$1(UserDB.User user$2, String dsName$2, List headers) {
        return this.dsAPI().buildRecords(user$2, dsName$2, Datasets.Parameters$.MODULE$.apply(Json$.MODULE$.fromValues((Iterable)package$.MODULE$.Nil()))).map((Function1 & Serializable)doc -> MODULE$.buildRecord((List<String>)headers, (Document)doc)).toListL();
    }

    private final List extractColumns$1(List cols, Document doc) {
        return this.buildRecord((List<String>)cols, doc);
    }

    private static final WordFrequency $anonfun$3() {
        return new WordFrequency();
    }
}

