/*
 * Decompiled with CFR 0.152.
 */
package ambience.dataMixer.mix;

import ambience.dataMixer.editing.DataAnalysis;
import ambience.dataMixer.mix.MixRunner$;
import ambience.dataMixer.mix.Sampler$;
import ambience.datablend.model.MixerModel;
import ambience.datablend.model.MixerModelSupport;
import ambience.datablend.proc.Calculation$;
import ambience.datablend.proc.Description$;
import ambience.datablend.proc.Model;
import ambience.datablend.proc.Patcher;
import ambience.datablend.proc.WordFrequency;
import ambience.datablend.proc.WordFrequencyBlend;
import ambience.module.UserDB;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.codex.CodexDB;
import com.elixirtech.mongodb.MongoDB;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class MixRunner
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MixRunner.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final DataAnalysis sourceAnalysis;
    private final DataAnalysis targetAnalysis;
    private final MixerModelSupport.MixerObject model;
    private final Patcher sourcePatcher;
    private final Patcher targetPatcher;
    private final Scheduler scheduler;

    public static Task<MixRunner> apply(MixerModel mixerModel, UserDB.User user) {
        return MixRunner$.MODULE$.apply(mixerModel, user);
    }

    public static Task<MixRunner> withSourceRecords(Observable<Document> observable, MongoDB mongoDB, MixerModel mixerModel, UserDB.User user) {
        return MixRunner$.MODULE$.withSourceRecords(observable, mongoDB, mixerModel, user);
    }

    public MixRunner(MixerModel record, DataAnalysis sourceAnalysis, DataAnalysis targetAnalysis) {
        this.sourceAnalysis = sourceAnalysis;
        this.targetAnalysis = targetAnalysis;
        this.model = record.mixer();
        this.sourcePatcher = new Patcher((Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.model.sourcePatches().first(), this.model.sourcePatches().second(), this.model.sourcePatches().third()})));
        this.targetPatcher = new Patcher((Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.model.targetPatches().first(), this.model.targetPatches().second(), this.model.targetPatches().third()})));
        this.scheduler = Scheduler$.MODULE$.global();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Patcher sourcePatcher() {
        return this.sourcePatcher;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Task<String> createMix() {
        String mixId = UUID.randomUUID().toString();
        return this.nextMix(mixId);
    }

    private Task<String> nextMix(String mixId) {
        return ((CodexDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(CodexDB.class))).getTempCodexCollection("Mix-" + mixId).flatMap((Function1 & Serializable)cltn -> this.run(this.run$default$1(), this.run$default$2()).toListL().flatMap((Function1 & Serializable)pds -> cltn.insertManyT((Seq)pds.map((Function1 & Serializable)pd -> {
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"data");
            Model.PairData pairData = (Model.PairData)io.circe.syntax.package$.MODULE$.EncoderOps(pd);
            String string2 = "source";
            String string3 = "target";
            String string4 = "certainty";
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonDocument$.MODULE$.apply(package.EncoderOps$.MODULE$.asJson$extension((Object)pairData, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(MixRunner::nextMix$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2), Configuration$.MODULE$.default())))).noSpaces())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            return org.mongodb.scala.bson.collection.package$.MODULE$.Document().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        })).flatMap((Function1 & Serializable)reply -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.nextMix$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1((CodexDB.InsertManyResult)reply, mixId);
            return BoxedUnit.UNIT;
        }).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return mixId;
        }))));
    }

    public Observable<Model.PairData> run(int start, int numToPull) {
        return Observable$.MODULE$.fromTask(this.makeBlend()).flatMap((Function1 & Serializable)blend -> {
            Observable recordsObs = Observable$.MODULE$.fromIterable((Iterable)this.sourceAnalysis.records().slice(start, start + numToPull));
            return Sampler$.MODULE$.sample((Observable<Model.Desc>)recordsObs, this.model.sample()).map((Function1 & Serializable)source -> this.sourcePatcher().patch(source)).map((Function1 & Serializable)in -> this.executeOn((WordFrequencyBlend)blend, (Model.Desc)in));
        });
    }

    public int run$default$1() {
        return 0;
    }

    public int run$default$2() {
        return 10;
    }

    public Observable<Model.PairData> runToEnd(int start) {
        return Observable$.MODULE$.fromTask(this.makeBlend()).flatMap((Function1 & Serializable)blend -> {
            Observable recordsObs = Observable$.MODULE$.fromIterable((Iterable)this.sourceAnalysis.records().drop(start));
            return Sampler$.MODULE$.sample((Observable<Model.Desc>)recordsObs, this.model.sample()).map((Function1 & Serializable)source -> this.sourcePatcher().patch(source)).map((Function1 & Serializable)in -> this.executeOn((WordFrequencyBlend)blend, (Model.Desc)in));
        });
    }

    public int runToEnd$default$1() {
        return 0;
    }

    public Observable<String> runProgressUpdates() {
        return this.run(this.run$default$1(), this.run$default$2()).zipWithIndex().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                long processed = BoxesRunTime.unboxToLong((Object)tuple2._2());
                return processed + "/" + this.targetAnalysis.rowCount();
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Task<WordFrequencyBlend> makeBlend() {
        return Task$.MODULE$.apply(this::makeBlend$$anonfun$1);
    }

    public Model.PairData executeOn(WordFrequencyBlend blend, Model.Desc in) {
        WordFrequencyBlend.Match result = blend.run(in);
        return Model.PairData$.MODULE$.apply(in.original(), result.desc().original(), result.certainty().serialize());
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$1() {
        void var3_2;
        void var1;
        Encoder encodeA = Encoder$.MODULE$.encodeInt();
        void var0_1 = var1;
        Encoder.AsArray encodeA2 = Encoder$.MODULE$.encodeVector(Encoder$.MODULE$.encodeString());
        void var2_3 = var3_2;
        return package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$2() {
        void var3_2;
        void var1;
        Encoder encodeA = Encoder$.MODULE$.encodeInt();
        void var0_1 = var1;
        Encoder.AsArray encodeA2 = Encoder$.MODULE$.encodeVector(Encoder$.MODULE$.encodeString());
        void var2_3 = var3_2;
        return package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$3() {
        Encoder encodeA;
        Encoder encodeA2;
        void var3_2;
        void var1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeDouble();
        void var0_1 = var1;
        Encoder encodeA4 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA2 = Calculation$.MODULE$.encoder();
        Encoder encoder2 = encodeA = Description$.MODULE$.encoder();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List nextMix$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        Encoder encodeA;
        Encoder encodeA2;
        void var1_2;
        String string = "idx";
        String string2 = "values";
        Encoder encodeA3 = Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(MixRunner::$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default())));
        void var0_3 = var1_2;
        String string3 = "idx";
        String string4 = "values";
        Encoder encoder = encodeA2 = Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(MixRunner::$anonfun$2, package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3), Configuration$.MODULE$.default())));
        String string5 = "value";
        String string6 = "origin";
        String string7 = "calculation";
        String string8 = "description";
        Encoder encoder2 = encodeA = Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(MixRunner::$anonfun$3, package$.MODULE$.Nil().$colon$colon((Object)string8).$colon$colon((Object)string7).$colon$colon((Object)string6).$colon$colon((Object)string5), Configuration$.MODULE$.default())));
        return package$.MODULE$.Nil().$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var0_3);
    }

    private static final Object nextMix$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(CodexDB.InsertManyResult reply$2, String mixId$3) {
        return "Inserted " + reply$2.getInsertedIds().size() + " records for <" + mixId$3 + ">";
    }

    private final void nextMix$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(CodexDB.InsertManyResult reply$1, String mixId$2) {
        this.log().info(() -> MixRunner.nextMix$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(reply$1, mixId$2), Line$.MODULE$.apply(56), FullName$.MODULE$.apply("ambience.dataMixer.mix.MixRunner.nextMix"));
    }

    private final WordFrequencyBlend makeBlend$$anonfun$1() {
        Predef$.MODULE$.println((Object)"MixRunner starting");
        List targetDesc = this.targetAnalysis.records().map((Function1 & Serializable)source -> this.targetPatcher.patch(source));
        WordFrequency[] sourceWFs = this.sourcePatcher().patch(this.sourceAnalysis.wordFrequencies());
        WordFrequency[] targetWFs = this.targetPatcher.patch(this.targetAnalysis.wordFrequencies());
        Vector columnPatches = (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MixerModelSupport.MixerColumn[]{this.model.columns().first(), this.model.columns().second(), this.model.columns().third()}));
        Vector columns = (Vector)((StrictOptimizedIterableOps)columnPatches.zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                WordFrequencyBlend.Weighting weighting;
                MixerModelSupport.MixerColumn mb = (MixerModelSupport.MixerColumn)tuple2._1();
                int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                WordFrequency wf = sourceWFs[idx].$plus(targetWFs[idx]);
                if (this.sourcePatcher().hasChannel(idx + 1) || this.targetPatcher.hasChannel(idx + 1)) {
                    double d = (double)mb.good() / 100.0;
                    double d2 = (double)mb.bad() / 100.0;
                    double d3 = WordFrequencyBlend.Weighting$.MODULE$.$lessinit$greater$default$2();
                    weighting = WordFrequencyBlend.Weighting$.MODULE$.apply(false, d3, d, d2);
                } else {
                    weighting = WordFrequencyBlend.Weighting$.MODULE$.apply(false, 0.0, 0.0, 0.0);
                }
                WordFrequencyBlend.Weighting weighting2 = weighting;
                return WordFrequencyBlend.Column$.MODULE$.apply(wf, weighting2);
            }
            throw new MatchError((Object)tuple2);
        });
        return new WordFrequencyBlend((Model.Desc[])targetDesc.toArray(ClassTag$.MODULE$.apply(Model.Desc.class)), (WordFrequencyBlend.Column[])columns.toArray(ClassTag$.MODULE$.apply(WordFrequencyBlend.Column.class)));
    }
}

