/*
 * Decompiled with CFR 0.152.
 */
package ambience.azure;

import ambience.api.BinaryStore;
import ambience.arch.EitherTELM;
import ambience.arch.EitherTELM$;
import ambience.etl.azure.AzureLogic$;
import ambience.etl.azure.BlobContainerInfo;
import ambience.etl.azure.BlobContainerInfo$;
import ambience.framework.BinaryStoreAPI;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobStorageException;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.FullDataBytes;
import com.elixirtech.arch.FullDataBytes$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.Decoder$;
import io.circe.Json;
import io.circe.parser.package$;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class BlobBinaryStoreLocation
implements BinaryStore.Location,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(BlobBinaryStoreLocation.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final BinaryStoreAPI.BSConfig bsConfig;
    private final String id;
    private final String sysref;
    private final String subPath;
    private final long maxSize;
    private final String MetadataSuffix;

    public BlobBinaryStoreLocation(BinaryStoreAPI.BSConfig bsConfig) {
        this.bsConfig = bsConfig;
        this.id = bsConfig.id();
        this.sysref = bsConfig.config().getString("systemReference");
        this.subPath = (String)Try$.MODULE$.apply(() -> BlobBinaryStoreLocation.$init$$$anonfun$1(bsConfig)).map((Function1 & Serializable)_$1 -> _$1.trim()).getOrElse(BlobBinaryStoreLocation::$init$$$anonfun$3);
        this.maxSize = bsConfig.config().getMemorySize("maxSize").toBytes();
        this.MetadataSuffix = "_metadata";
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String id() {
        return this.id;
    }

    public String sysref() {
        return this.sysref;
    }

    public String subPath() {
        return this.subPath;
    }

    public long maxSize() {
        return this.maxSize;
    }

    public String MetadataSuffix() {
        return this.MetadataSuffix;
    }

    public String description() {
        return "Azure BinaryStore using " + this.sysref();
    }

    public Task<BinaryStore.ContentId> add(BinaryStore.Content content) {
        EitherTELM result = EitherTELM$.MODULE$.apply(BlobContainerInfo$.MODULE$.load(this.sysref()).map((Function1 & Serializable)_$2 -> _$2.map((Function1 & Serializable)_$3 -> _$3.withSubPath(this.subPath())))).flatMap((Function1 & Serializable)bci -> EitherTELM$.MODULE$.apply(AzureLogic$.MODULE$.systemBuilder((BlobContainerInfo)bci)).flatMap((Function1 & Serializable)creds -> EitherTELM$.MODULE$.apply(AzureLogic$.MODULE$.clientT((BlobContainerInfo)bci, (BlobServiceClientBuilder)creds, (Function1 & Serializable)bcc -> this.putFile(content, (BlobContainerInfo)bci, (BlobContainerClient)bcc))).map((Function1 & Serializable)v1 -> new BinaryStore.ContentId(v1 == null ? null : ((BinaryStore.ContentId)v1).value()))));
        return result.value().map((Function1 & Serializable)x$1 -> new BinaryStore.ContentId(BlobBinaryStoreLocation.add$$anonfun$1(x$1)));
    }

    public Task<BinaryStore.ContentId> putFile(BinaryStore.Content content, BlobContainerInfo bci, BlobContainerClient bcc) {
        return DataBytes$.MODULE$.toFullT(content.bytes()).map((Function1 & Serializable)full -> new BinaryStore.ContentId(this.putFile$$anonfun$1(bci, bcc, content, (FullDataBytes)full)));
    }

    public Option<String> getMimeType(BinaryStore.Content content) {
        return content.metadata().hcursor().downField("mimeType").as(Decoder$.MODULE$.decodeString()).toOption();
    }

    public Observable<BinaryStore.ContentId> all() {
        EitherTELM result = EitherTELM$.MODULE$.apply(BlobContainerInfo$.MODULE$.load(this.sysref())).flatMap((Function1 & Serializable)bci -> EitherTELM$.MODULE$.apply(AzureLogic$.MODULE$.systemBuilder((BlobContainerInfo)bci)).flatMap((Function1 & Serializable)creds -> EitherTELM$.MODULE$.apply(Task$.MODULE$.apply(() -> this.$anonfun$3$$anonfun$1$$anonfun$1(bci, creds))).map((Function1 & Serializable)result -> result)));
        return Observable$.MODULE$.fromTask(result.value()).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                List cIds = (List)((Right)either).value();
                return Observable$.MODULE$.fromIterable((Iterable)cIds);
            }
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                throw new RuntimeException(msg.msg());
            }
            throw new MatchError((Object)either);
        });
    }

    public List<BinaryStore.ContentId> getList(BlobContainerInfo bci, BlobContainerClient bcc) {
        String location = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(bci.path().trim()), "/") + "/";
        return CollectionConverters$.MODULE$.IterableHasAsScala((java.lang.Iterable)bcc.listBlobs()).asScala().toList().filter((Function1 & Serializable)_$4 -> _$4.getName().startsWith(location)).filterNot((Function1 & Serializable)_$5 -> _$5.getName().endsWith(this.MetadataSuffix())).map((Function1 & Serializable)blob -> new BinaryStore.ContentId(BinaryStore.ContentId$.MODULE$.apply(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(blob.getName()), location))));
    }

    public Task<Option<BinaryStore.Content>> get(String id) {
        EitherTELM result = EitherTELM$.MODULE$.apply(BlobContainerInfo$.MODULE$.load(this.sysref())).flatMap((Function1 & Serializable)bci -> EitherTELM$.MODULE$.apply(AzureLogic$.MODULE$.systemBuilder((BlobContainerInfo)bci)).flatMap((Function1 & Serializable)creds -> EitherTELM$.MODULE$.apply(Task$.MODULE$.apply(() -> this.$anonfun$4$$anonfun$1$$anonfun$1(bci, creds, id))).map((Function1 & Serializable)result -> result)));
        return result.value().map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Option content = (Option)((Right)either).value();
                return content;
            }
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                this.log().apply(msg, Line$.MODULE$.apply(101), FullName$.MODULE$.apply("ambience.azure.BlobBinaryStoreLocation.get"));
                return None$.MODULE$;
            }
            throw new MatchError((Object)either);
        });
    }

    public Option<BinaryStore.Content> getFile(BlobContainerInfo bci, String id, BlobContainerClient bcc) {
        String location = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(bci.path().trim()), "/") + "/" + id;
        return this.tryGetBytes(bcc, location).flatMap((Function1 & Serializable)bytes -> this.tryGetBytes(bcc, location + this.MetadataSuffix()).flatMap((Function1 & Serializable)md -> this.parseJson(new String((byte[])md, StandardCharsets.UTF_8)).map((Function1 & Serializable)json -> BinaryStore.Content$.MODULE$.apply((DataBytes)FullDataBytes$.MODULE$.apply(bytes), json))));
    }

    public Option<byte[]> tryGetBytes(BlobContainerClient bcc, String location) {
        this.log().debug(() -> BlobBinaryStoreLocation.tryGetBytes$$anonfun$1(location), Line$.MODULE$.apply(115), FullName$.MODULE$.apply("ambience.azure.BlobBinaryStoreLocation.tryGetBytes"));
        Try<byte[]> try_ = this.getBytes(bcc, location);
        if (try_ instanceof Success) {
            byte[] bytes = (byte[])((Success)try_).value();
            return Some$.MODULE$.apply((Object)bytes);
        }
        if (try_ instanceof Failure) {
            BlobStorageException ex;
            Throwable throwable = ((Failure)try_).exception();
            if (throwable instanceof BlobStorageException && (ex = (BlobStorageException)throwable).getStatusCode() == 404) {
                this.log().warn(() -> BlobBinaryStoreLocation.tryGetBytes$$anonfun$2(location), Line$.MODULE$.apply(118), FullName$.MODULE$.apply("ambience.azure.BlobBinaryStoreLocation.tryGetBytes"));
                return None$.MODULE$;
            }
            Throwable ex2 = throwable;
            this.log().error(() -> BlobBinaryStoreLocation.tryGetBytes$$anonfun$3(ex2), Line$.MODULE$.apply(119), FullName$.MODULE$.apply("ambience.azure.BlobBinaryStoreLocation.tryGetBytes"));
            return None$.MODULE$;
        }
        throw new MatchError(try_);
    }

    public Try<byte[]> getBytes(BlobContainerClient bcc, String location) {
        return Try$.MODULE$.apply(() -> BlobBinaryStoreLocation.getBytes$$anonfun$1(bcc, location));
    }

    public Task<Option<Json>> getMetadata(String id) {
        EitherTELM result = EitherTELM$.MODULE$.apply(BlobContainerInfo$.MODULE$.load(this.sysref())).flatMap((Function1 & Serializable)bci -> EitherTELM$.MODULE$.apply(AzureLogic$.MODULE$.systemBuilder((BlobContainerInfo)bci)).flatMap((Function1 & Serializable)creds -> EitherTELM$.MODULE$.apply(Task$.MODULE$.apply(() -> this.$anonfun$5$$anonfun$1$$anonfun$1(bci, creds, id))).map((Function1 & Serializable)result -> result)));
        return result.value().map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Option content = (Option)((Right)either).value();
                return content;
            }
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                this.log().apply(msg, Line$.MODULE$.apply(138), FullName$.MODULE$.apply("ambience.azure.BlobBinaryStoreLocation.getMetadata"));
                return None$.MODULE$;
            }
            throw new MatchError((Object)either);
        });
    }

    public Option<Json> getMetadata(BlobContainerInfo bci, String id, BlobContainerClient bcc) {
        String location = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(bci.path().trim()), "/") + "/" + id + this.MetadataSuffix();
        return this.tryGetBytes(bcc, location).flatMap((Function1 & Serializable)md -> this.parseJson(new String((byte[])md, StandardCharsets.UTF_8)).map((Function1 & Serializable)json -> json));
    }

    public Task<BoxedUnit> remove(String id) {
        EitherTELM result = EitherTELM$.MODULE$.apply(BlobContainerInfo$.MODULE$.load(this.sysref())).flatMap((Function1 & Serializable)bci -> EitherTELM$.MODULE$.apply(AzureLogic$.MODULE$.systemBuilder((BlobContainerInfo)bci)).flatMap((Function1 & Serializable)creds -> EitherTELM$.MODULE$.apply(Task$.MODULE$.apply(() -> this.$anonfun$6$$anonfun$1$$anonfun$1(bci, creds, id))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        })));
        return result.value().map((Function1)(JProcedure1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                return;
            }
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                this.log().apply(msg, Line$.MODULE$.apply(158), FullName$.MODULE$.apply("ambience.azure.BlobBinaryStoreLocation.remove"));
                return;
            }
            throw new MatchError((Object)either);
        });
    }

    public void deleteFile(BlobContainerInfo bci, String id, BlobContainerClient bcc) {
        String location = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(bci.path().trim()), "/") + "/" + id;
        bcc.getBlobClient(location).deleteIfExists();
        bcc.getBlobClient(location + this.MetadataSuffix()).deleteIfExists();
    }

    private Option<Json> parseJson(String s) {
        return package$.MODULE$.parse(s).toOption();
    }

    private static final String $init$$$anonfun$1(BinaryStoreAPI.BSConfig bsConfig$1) {
        return bsConfig$1.config().getString("subPath");
    }

    private static final String $init$$$anonfun$3() {
        return "";
    }

    private static final /* synthetic */ String add$$anonfun$1(Either x$1) {
        Either either = x$1;
        if (either instanceof Right) {
            Object object = ((Right)either).value();
            String cId = object == null ? null : ((BinaryStore.ContentId)object).value();
            return cId;
        }
        if (either instanceof Left) {
            LogMessage msg = (LogMessage)((Left)either).value();
            throw new RuntimeException(msg.msg());
        }
        throw new MatchError((Object)either);
    }

    private final /* synthetic */ String putFile$$anonfun$1(BlobContainerInfo bci$3, BlobContainerClient bcc$1, BinaryStore.Content content$4, FullDataBytes full) {
        if ((long)full.bytes().length > this.maxSize()) {
            throw new BinaryStore.MaxSizeException(Int$.MODULE$.int2long(full.bytes().length), this.maxSize());
        }
        String uuid = UUID.randomUUID().toString();
        String location = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(bci$3.path().trim()), "/") + "/" + uuid;
        BlobClient bc = bcc$1.getBlobClient(location);
        bc.upload((InputStream)new ByteArrayInputStream(full.bytes()), full.length(), true);
        byte[] metadataBytes = content$4.metadata().noSpaces().getBytes(StandardCharsets.UTF_8);
        BlobClient bc2 = bcc$1.getBlobClient(location + this.MetadataSuffix());
        bc2.upload((InputStream)new ByteArrayInputStream(metadataBytes), Int$.MODULE$.int2long(metadataBytes.length), true);
        this.getMimeType(content$4).foreach((Function1)(JProcedure1 & Serializable)mimeType -> {
            BlobHttpHeaders headers = new BlobHttpHeaders();
            headers.setContentType(mimeType);
            bc.setHttpHeaders(headers);
        });
        return BinaryStore.ContentId$.MODULE$.apply(uuid);
    }

    private final Either $anonfun$3$$anonfun$1$$anonfun$1(BlobContainerInfo bci$5, BlobServiceClientBuilder creds$1) {
        return AzureLogic$.MODULE$.client(bci$5, creds$1, (Function1 & Serializable)bcc -> this.getList(bci$5, (BlobContainerClient)bcc));
    }

    private final Either $anonfun$4$$anonfun$1$$anonfun$1(BlobContainerInfo bci$8, BlobServiceClientBuilder creds$2, String id$2) {
        return AzureLogic$.MODULE$.client(bci$8, creds$2, (Function1 & Serializable)bcc -> this.getFile(bci$8, id$2, (BlobContainerClient)bcc));
    }

    private static final Object tryGetBytes$$anonfun$1(String location$4) {
        return "loading " + location$4;
    }

    private static final Object tryGetBytes$$anonfun$2(String location$5) {
        return "content " + location$5 + " not found";
    }

    private static final Object tryGetBytes$$anonfun$3(Throwable ex$1) {
        return "tryGetBytes: " + ex$1;
    }

    private static final byte[] getBytes$$anonfun$1(BlobContainerClient bcc$3, String location$6) {
        BlobClient bc = bcc$3.getBlobClient(location$6);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        bc.downloadStream((OutputStream)out);
        return out.toByteArray();
    }

    private final Either $anonfun$5$$anonfun$1$$anonfun$1(BlobContainerInfo bci$11, BlobServiceClientBuilder creds$3, String id$6) {
        return AzureLogic$.MODULE$.client(bci$11, creds$3, (Function1 & Serializable)bcc -> this.getMetadata(bci$11, id$6, (BlobContainerClient)bcc));
    }

    private final Either $anonfun$6$$anonfun$1$$anonfun$1(BlobContainerInfo bci$14, BlobServiceClientBuilder creds$4, String id$10) {
        return AzureLogic$.MODULE$.client(bci$14, creds$4, (JProcedure1 & Serializable)bcc -> this.deleteFile(bci$14, id$10, (BlobContainerClient)bcc));
    }
}

