/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.api;

import jakarta.json.JsonNumber;
import jakarta.json.JsonValue;
import java.util.Objects;

public enum InstanceType {
    NULL,
    BOOLEAN,
    OBJECT,
    ARRAY,
    NUMBER,
    STRING,
    INTEGER;


    public boolean isNumeric() {
        return this == NUMBER || this == INTEGER;
    }

    public boolean isContainer() {
        return this == OBJECT || this == ARRAY;
    }

    public static InstanceType of(JsonValue value) {
        Objects.requireNonNull(value, "value must not be null");
        switch (value.getValueType()) {
            case ARRAY: {
                return ARRAY;
            }
            case OBJECT: {
                return OBJECT;
            }
            case STRING: {
                return STRING;
            }
            case NUMBER: {
                return ((JsonNumber)value).isIntegral() ? INTEGER : NUMBER;
            }
            case TRUE: 
            case FALSE: {
                return BOOLEAN;
            }
            case NULL: {
                return NULL;
            }
        }
        throw new IllegalArgumentException();
    }
}

