/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.api;

import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParsingException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.leadpony.justify.api.Problem;

public class JsonValidatingException
extends JsonParsingException {
    private final List<Problem> problems;

    public JsonValidatingException(List<Problem> problems) {
        super(null, JsonValidatingException.extractFirstLocation(problems));
        this.problems = Collections.unmodifiableList(problems);
    }

    public List<Problem> getProblems() {
        return this.problems;
    }

    public String getMessage() {
        return this.problems.stream().map(Problem::getContextualMessage).collect(Collectors.joining("\n"));
    }

    public void printProblems(PrintStream stream) {
        Objects.requireNonNull(stream, "stream must not be null.");
        this.problems.stream().forEach(stream::println);
    }

    public void printProblems(PrintWriter writer) {
        Objects.requireNonNull(writer, "writer must not be null.");
        this.problems.stream().forEach(writer::println);
    }

    private static JsonLocation extractFirstLocation(List<Problem> problems) {
        if (problems.isEmpty()) {
            return null;
        }
        return problems.get(0).getLocation();
    }
}

