/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.api;

import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.JsonSchemaBuilderFactory;
import org.leadpony.justify.api.JsonSchemaReader;
import org.leadpony.justify.api.JsonSchemaReaderFactory;
import org.leadpony.justify.api.JsonSchemaReaderFactoryBuilder;
import org.leadpony.justify.api.ProblemHandler;
import org.leadpony.justify.api.ProblemHandlerFactory;
import org.leadpony.justify.api.ProblemPrinterBuilder;
import org.leadpony.justify.api.ValidationConfig;
import org.leadpony.justify.spi.JsonValidationProvider;

public interface JsonValidationService
extends JsonSchemaReaderFactory {
    public static JsonValidationService newInstance() {
        return JsonValidationProvider.provider().createService();
    }

    public static JsonValidationService newInstance(JsonProvider jsonProvider) {
        return JsonValidationProvider.provider().createService(jsonProvider);
    }

    public JsonSchemaReaderFactory createSchemaReaderFactory();

    public JsonSchemaReaderFactoryBuilder createSchemaReaderFactoryBuilder();

    default public JsonSchema readSchema(InputStream in) {
        try (JsonSchemaReader schemaReader = this.createSchemaReader(in);){
            JsonSchema jsonSchema = schemaReader.read();
            return jsonSchema;
        }
    }

    default public JsonSchema readSchema(InputStream in, Charset charset) {
        try (JsonSchemaReader schemaReader = this.createSchemaReader(in, charset);){
            JsonSchema jsonSchema = schemaReader.read();
            return jsonSchema;
        }
    }

    default public JsonSchema readSchema(Reader reader) {
        try (JsonSchemaReader schemaReader = this.createSchemaReader(reader);){
            JsonSchema jsonSchema = schemaReader.read();
            return jsonSchema;
        }
    }

    default public JsonSchema readSchema(Path path) {
        try (JsonSchemaReader schemaReader = this.createSchemaReader(path);){
            JsonSchema jsonSchema = schemaReader.read();
            return jsonSchema;
        }
    }

    default public JsonSchema readSchema(JsonParser parser) {
        try (JsonSchemaReader schemaReader = this.createSchemaReader(parser);){
            JsonSchema jsonSchema = schemaReader.read();
            return jsonSchema;
        }
    }

    public JsonSchemaBuilderFactory createSchemaBuilderFactory();

    public ValidationConfig createValidationConfig();

    public JsonParserFactory createParserFactory(Map<String, ?> var1);

    public JsonParserFactory createParserFactory(Map<String, ?> var1, JsonSchema var2, ProblemHandlerFactory var3);

    public JsonParser createParser(InputStream var1, JsonSchema var2, ProblemHandler var3);

    public JsonParser createParser(InputStream var1, Charset var2, JsonSchema var3, ProblemHandler var4);

    public JsonParser createParser(Reader var1, JsonSchema var2, ProblemHandler var3);

    public JsonParser createParser(Path var1, JsonSchema var2, ProblemHandler var3);

    public JsonParser createParser(JsonParser var1, JsonSchema var2, ProblemHandler var3);

    public JsonReaderFactory createReaderFactory(Map<String, ?> var1);

    public JsonReaderFactory createReaderFactory(Map<String, ?> var1, JsonSchema var2, ProblemHandlerFactory var3);

    public JsonReader createReader(InputStream var1, JsonSchema var2, ProblemHandler var3);

    public JsonReader createReader(InputStream var1, Charset var2, JsonSchema var3, ProblemHandler var4);

    public JsonReader createReader(Reader var1, JsonSchema var2, ProblemHandler var3);

    public JsonReader createReader(Path var1, JsonSchema var2, ProblemHandler var3);

    public JsonReader createReader(JsonParser var1, JsonSchema var2, ProblemHandler var3);

    public JsonProvider createJsonProvider(JsonSchema var1, ProblemHandlerFactory var2);

    public ProblemHandler createProblemPrinter(Consumer<String> var1);

    public ProblemHandler createProblemPrinter(Consumer<String> var1, Locale var2);

    public ProblemPrinterBuilder createProblemPrinterBuilder(Consumer<String> var1);

    public JsonProvider getJsonProvider();
}

