/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.base;

import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.leadpony.justify.api.Localizable;
import org.leadpony.justify.internal.base.MessageFormatter;

interface BaseMessage
extends Localizable {
    @Override
    default public String getLocalized(Locale locale) {
        return this.getBundle(locale).getString(this.name());
    }

    default public String format(Map<String, Object> arguments) {
        return this.format(arguments, Locale.getDefault());
    }

    default public String format(Map<String, Object> arguments, Locale locale) {
        ResourceBundle bundle = this.getBundle(locale);
        String pattern = bundle.getString(this.name());
        MessageFormatter formatter = new MessageFormatter(pattern, bundle);
        return formatter.format(arguments);
    }

    public String name();

    public ResourceBundle getBundle(Locale var1);
}

