/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.base.json;

import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonParser;
import org.leadpony.justify.internal.base.json.JsonParserDecorator;
import org.leadpony.justify.internal.base.json.PointerAwareJsonParser;

public class DefaultPointerAwareJsonParser
extends JsonParserDecorator
implements PointerAwareJsonParser {
    private static final PointerBuilder INITIAL_BUILDER = new InitialPointerBuilder();
    private static final PointerBuilder ROOT_BUILDER = new RootPointerBuilder();
    private PointerBuilder pointerBuilder = INITIAL_BUILDER;
    private String cachedPointer;

    public DefaultPointerAwareJsonParser(JsonParser parser, JsonProvider jsonProvider) {
        super(parser, jsonProvider);
        this.setCurrentParser(parser);
    }

    @Override
    public String getPointer() {
        if (this.cachedPointer != null) {
            return this.cachedPointer;
        }
        this.cachedPointer = this.pointerBuilder.toPointer();
        return this.cachedPointer;
    }

    @Override
    protected JsonParser.Event process(JsonParser.Event event) {
        this.pointerBuilder = this.pointerBuilder.withEvent(event, this.getCurrentParser());
        this.cachedPointer = null;
        return event;
    }

    @Override
    protected boolean isInCollection() {
        JsonParser.Event event = this.getCurrentEvent();
        if (event == JsonParser.Event.END_ARRAY || event == JsonParser.Event.END_OBJECT) {
            return true;
        }
        return this.pointerBuilder.isScoped();
    }

    private static interface PointerBuilder {
        default public boolean isScoped() {
            return false;
        }

        public PointerBuilder withEvent(JsonParser.Event var1, JsonParser var2);

        default public String toPointer() {
            StringBuilder builder = new StringBuilder();
            this.build(builder);
            return builder.toString();
        }

        default public void build(StringBuilder builder) {
        }
    }

    private static class InitialPointerBuilder
    implements PointerBuilder {
        private InitialPointerBuilder() {
        }

        @Override
        public PointerBuilder withEvent(JsonParser.Event event, JsonParser parser) {
            switch (event) {
                case START_ARRAY: {
                    return new ArrayPointerBuilder(ROOT_BUILDER);
                }
                case START_OBJECT: {
                    return new ObjectPointerBuilder(ROOT_BUILDER);
                }
                case END_ARRAY: 
                case END_OBJECT: {
                    throw new IllegalStateException();
                }
            }
            return ROOT_BUILDER;
        }

        @Override
        public String toPointer() {
            return null;
        }
    }

    private static class RootPointerBuilder
    implements PointerBuilder {
        private RootPointerBuilder() {
        }

        @Override
        public PointerBuilder withEvent(JsonParser.Event event, JsonParser parser) {
            throw new IllegalStateException();
        }
    }

    private static class ObjectPointerBuilder
    implements PointerBuilder {
        private final PointerBuilder parent;
        private String keyName;
        private JsonParser.Event lastEvent;

        ObjectPointerBuilder(PointerBuilder parent) {
            this.parent = parent;
        }

        @Override
        public boolean isScoped() {
            return true;
        }

        @Override
        public PointerBuilder withEvent(JsonParser.Event event, JsonParser parser) {
            this.lastEvent = event;
            switch (event) {
                case START_ARRAY: {
                    return new ArrayPointerBuilder(this);
                }
                case START_OBJECT: {
                    return new ObjectPointerBuilder(this);
                }
                case END_ARRAY: {
                    throw new IllegalStateException();
                }
                case END_OBJECT: {
                    return this.parent;
                }
                case KEY_NAME: {
                    this.keyName = parser.getString();
                }
            }
            return this;
        }

        @Override
        public void build(StringBuilder builder) {
            this.parent.build(builder);
            if (this.keyName != null && this.lastEvent != JsonParser.Event.KEY_NAME) {
                builder.append('/');
                int lastIndex = 0;
                int length = this.keyName.length();
                for (int i = 0; i < length; ++i) {
                    char c = this.keyName.charAt(i);
                    if (c == '~') {
                        builder.append(this.keyName, lastIndex, i).append("~0");
                        lastIndex = i + 1;
                        continue;
                    }
                    if (c != '/') continue;
                    builder.append(this.keyName, lastIndex, i).append("~1");
                    lastIndex = i + 1;
                }
                if (lastIndex < length) {
                    builder.append(this.keyName, lastIndex, length);
                }
            }
        }
    }

    private static class ArrayPointerBuilder
    implements PointerBuilder {
        private final PointerBuilder parent;
        private int index = -1;

        ArrayPointerBuilder(PointerBuilder parent) {
            this.parent = parent;
        }

        @Override
        public boolean isScoped() {
            return true;
        }

        @Override
        public PointerBuilder withEvent(JsonParser.Event event, JsonParser parser) {
            switch (event) {
                case START_ARRAY: {
                    ++this.index;
                    return new ArrayPointerBuilder(this);
                }
                case START_OBJECT: {
                    ++this.index;
                    return new ObjectPointerBuilder(this);
                }
                case END_ARRAY: {
                    return this.parent;
                }
                case END_OBJECT: {
                    throw new IllegalStateException();
                }
            }
            ++this.index;
            return this;
        }

        @Override
        public void build(StringBuilder builder) {
            this.parent.build(builder);
            if (this.index >= 0) {
                builder.append("/").append(this.index);
            }
        }
    }
}

