/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.base.json;

import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import org.leadpony.justify.internal.base.json.BigDecimalJsonNumber;

public final class JsonInstanceBuilder {
    private final RootScope rootScope = new RootScope();
    private final JsonBuilderFactory builderFactory;
    private Scope currentScope = this.rootScope;

    public JsonInstanceBuilder(JsonBuilderFactory builderFactory) {
        this.builderFactory = builderFactory;
    }

    public boolean append(JsonParser.Event event, JsonParser parser) {
        this.currentScope = this.currentScope.process(event, parser);
        return this.currentScope != this.rootScope;
    }

    public JsonValue build() {
        return this.rootScope.getRootValue();
    }

    private static JsonValue getLiteral(JsonParser.Event event, JsonParser parser) {
        switch (event) {
            case VALUE_TRUE: {
                return JsonValue.TRUE;
            }
            case VALUE_FALSE: {
                return JsonValue.FALSE;
            }
            case VALUE_NULL: {
                return JsonValue.NULL;
            }
            case VALUE_STRING: 
            case KEY_NAME: {
                return parser.getValue();
            }
            case VALUE_NUMBER: {
                return new BigDecimalJsonNumber(parser.getBigDecimal());
            }
        }
        assert (false);
        return null;
    }

    private final class RootScope
    implements Scope {
        private JsonValue value;

        private RootScope() {
        }

        @Override
        public Scope process(JsonParser.Event event, JsonParser parser) {
            switch (event) {
                case START_ARRAY: {
                    return new ArrayScope(this);
                }
                case START_OBJECT: {
                    return new ObjectScope(this);
                }
                case VALUE_TRUE: 
                case VALUE_FALSE: 
                case VALUE_NULL: 
                case VALUE_STRING: 
                case KEY_NAME: 
                case VALUE_NUMBER: {
                    this.append(JsonInstanceBuilder.getLiteral(event, parser));
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return this;
        }

        @Override
        public void append(JsonValue value) {
            this.value = value;
        }

        public JsonValue getRootValue() {
            return this.value;
        }
    }

    private static interface Scope {
        public Scope process(JsonParser.Event var1, JsonParser var2);

        public void append(JsonValue var1);
    }

    private final class ObjectScope
    implements Scope {
        private final Scope parent;
        private final JsonObjectBuilder builder;
        private String propertyName;

        ObjectScope(Scope parent) {
            this.parent = parent;
            this.builder = JsonInstanceBuilder.this.builderFactory.createObjectBuilder();
        }

        @Override
        public Scope process(JsonParser.Event event, JsonParser parser) {
            switch (event) {
                case START_ARRAY: {
                    return new ArrayScope(this);
                }
                case START_OBJECT: {
                    return new ObjectScope(this);
                }
                case KEY_NAME: {
                    this.propertyName = parser.getString();
                    break;
                }
                case VALUE_TRUE: 
                case VALUE_FALSE: 
                case VALUE_NULL: 
                case VALUE_STRING: 
                case VALUE_NUMBER: {
                    this.builder.add(this.propertyName, JsonInstanceBuilder.getLiteral(event, parser));
                    this.propertyName = null;
                    break;
                }
                case END_OBJECT: {
                    this.parent.append((JsonValue)this.builder.build());
                    return this.parent;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return this;
        }

        @Override
        public void append(JsonValue value) {
            assert (this.propertyName != null);
            this.builder.add(this.propertyName, value);
        }
    }

    private final class ArrayScope
    implements Scope {
        private final Scope parent;
        private final JsonArrayBuilder builder;

        ArrayScope(Scope parent) {
            this.parent = parent;
            this.builder = JsonInstanceBuilder.this.builderFactory.createArrayBuilder();
        }

        @Override
        public Scope process(JsonParser.Event event, JsonParser parser) {
            switch (event) {
                case START_ARRAY: {
                    return new ArrayScope(this);
                }
                case START_OBJECT: {
                    return new ObjectScope(this);
                }
                case VALUE_TRUE: 
                case VALUE_FALSE: 
                case VALUE_NULL: 
                case VALUE_STRING: 
                case VALUE_NUMBER: {
                    this.append(JsonInstanceBuilder.getLiteral(event, parser));
                    break;
                }
                case END_ARRAY: {
                    this.parent.append((JsonValue)this.builder.build());
                    return this.parent;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return this;
        }

        @Override
        public void append(JsonValue value) {
            this.builder.add(value);
        }
    }
}

