/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.evaluator;

import java.util.List;
import java.util.stream.Collectors;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.evaluator.AbstractLogicalEvaluator;
import org.leadpony.justify.internal.problem.ProblemBuilder;
import org.leadpony.justify.internal.problem.ProblemList;

abstract class AbstractExclusiveEvaluator
extends AbstractLogicalEvaluator {
    protected AbstractExclusiveEvaluator(EvaluatorContext context) {
        super(context);
    }

    protected void dispatchProblems(ProblemDispatcher dispatcher, List<ProblemList> problemLists) {
        List<Object> filteredLists = problemLists.stream().filter(ProblemList::isResolvable).collect(Collectors.toList());
        if (filteredLists.isEmpty()) {
            filteredLists = problemLists;
        }
        ProblemBuilder builder = this.createProblemBuilder(this.getContext()).withMessage(Message.INSTANCE_PROBLEM_ONEOF_FEW).withBranches(filteredLists);
        dispatcher.dispatchProblem(builder.build());
    }

    protected void dispatchNegatedProblems(ProblemDispatcher dispatcher, List<ProblemList> problemLists) {
        ProblemBuilder builder = this.createProblemBuilder(this.getContext()).withMessage(Message.INSTANCE_PROBLEM_ONEOF_MANY).withBranches(problemLists);
        dispatcher.dispatchProblem(builder.build());
    }
}

