/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.evaluator;

import jakarta.json.stream.JsonParser;
import java.util.Iterator;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.internal.evaluator.DeferredEvaluator;
import org.leadpony.justify.internal.evaluator.SimpleDisjunctiveEvaluator;

class DisjunctiveEvaluator
extends SimpleDisjunctiveEvaluator {
    private final JsonParser.Event closingEvent;

    DisjunctiveEvaluator(EvaluatorContext context, JsonParser.Event closingEvent) {
        super(context);
        this.closingEvent = closingEvent;
    }

    @Override
    public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
        if (this.invokeOperandEvaluators(event, depth, dispatcher) == Evaluator.Result.TRUE) {
            return Evaluator.Result.TRUE;
        }
        if (depth == 0 && event == this.closingEvent) {
            return this.dispatchProblems(dispatcher);
        }
        return Evaluator.Result.PENDING;
    }

    protected Evaluator.Result invokeOperandEvaluators(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
        Iterator<DeferredEvaluator> it = this.iterator();
        while (it.hasNext()) {
            DeferredEvaluator current = it.next();
            Evaluator.Result result = current.evaluate(event, depth, dispatcher);
            if (result == Evaluator.Result.TRUE) {
                return Evaluator.Result.TRUE;
            }
            if (result == Evaluator.Result.PENDING) continue;
            if (result == Evaluator.Result.FALSE) {
                this.addBadEvaluator(current);
            }
            it.remove();
        }
        return Evaluator.Result.PENDING;
    }
}

