/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.evaluator;

import jakarta.json.stream.JsonParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.internal.evaluator.AbstractLogicalEvaluator;
import org.leadpony.justify.internal.evaluator.DeferredEvaluator;

class SimpleNotExclusiveEvaluator
extends AbstractLogicalEvaluator
implements Iterable<DeferredEvaluator> {
    private final List<DeferredEvaluator> operands = new ArrayList<DeferredEvaluator>();
    private List<Problem> problemList;
    private int evaluationsAsFalse;

    SimpleNotExclusiveEvaluator(EvaluatorContext context) {
        super(context);
    }

    @Override
    public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
        for (DeferredEvaluator current : this.operands) {
            if (current.evaluate(event, depth, dispatcher) != Evaluator.Result.FALSE) continue;
            this.addBadEvaluator(current);
        }
        return this.finalizeResult(dispatcher);
    }

    @Override
    public void append(Evaluator evaluator) {
        if (evaluator == Evaluator.ALWAYS_TRUE) {
            return;
        }
        this.operands.add(new DeferredEvaluator(evaluator));
    }

    @Override
    public Iterator<DeferredEvaluator> iterator() {
        return this.operands.iterator();
    }

    protected void addBadEvaluator(DeferredEvaluator evaluator) {
        if (this.problemList == null) {
            this.problemList = evaluator.problems();
        }
        ++this.evaluationsAsFalse;
    }

    protected Evaluator.Result finalizeResult(ProblemDispatcher dispatcher) {
        if (this.evaluationsAsFalse == 1) {
            this.problemList.forEach(dispatcher::dispatchProblem);
            return Evaluator.Result.FALSE;
        }
        return Evaluator.Result.TRUE;
    }
}

