/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.applicator;

import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.internal.base.json.ParserEvents;
import org.leadpony.justify.internal.evaluator.AbstractConjunctivePropertiesEvaluator;
import org.leadpony.justify.internal.evaluator.AbstractDisjunctivePropertiesEvaluator;
import org.leadpony.justify.internal.keyword.Evaluatable;
import org.leadpony.justify.internal.keyword.ObjectKeyword;
import org.leadpony.justify.internal.keyword.SchemaKeyword;
import org.leadpony.justify.internal.keyword.applicator.AdditionalProperties;
import org.leadpony.justify.internal.keyword.applicator.Applicator;
import org.leadpony.justify.internal.keyword.applicator.RedundantPropertyEvaluator;

public abstract class AbstractProperties<K>
extends Applicator
implements ObjectKeyword {
    protected final Map<K, JsonSchema> propertyMap;
    private JsonSchema defaultSchema;

    protected AbstractProperties(JsonValue json, Map<K, JsonSchema> properties) {
        super(json);
        this.propertyMap = properties;
        this.defaultSchema = JsonSchema.TRUE;
    }

    @Override
    protected Evaluator doCreateEvaluator(EvaluatorContext context, InstanceType type) {
        return new PropertiesEvaluator(context, this.defaultSchema);
    }

    @Override
    protected Evaluator doCreateNegatedEvaluator(EvaluatorContext context, InstanceType type) {
        return new NegatedPropertiesEvaluator(context, this.defaultSchema);
    }

    @Override
    public void addToEvaluatables(List<Evaluatable> evaluatables, Map<String, SchemaKeyword> keywords) {
        if (keywords.containsKey("additionalProperties")) {
            AdditionalProperties additionalProperties = (AdditionalProperties)keywords.get("additionalProperties");
            this.defaultSchema = additionalProperties.getSubschema();
        }
    }

    @Override
    public boolean hasSubschemas() {
        return !this.propertyMap.isEmpty();
    }

    @Override
    public Stream<JsonSchema> getSubschemas() {
        return this.propertyMap.values().stream();
    }

    protected abstract boolean findSubschemas(String var1, Consumer<JsonSchema> var2);

    private class PropertiesEvaluator
    extends AbstractConjunctivePropertiesEvaluator
    implements Consumer<JsonSchema> {
        private final JsonSchema defaultSchema;
        private String currentKeyName;
        private InstanceType currentType;

        PropertiesEvaluator(EvaluatorContext context, JsonSchema defaultSchema) {
            super(context);
            this.defaultSchema = defaultSchema;
        }

        @Override
        public void updateChildren(JsonParser.Event event, JsonParser parser) {
            if (event == JsonParser.Event.KEY_NAME) {
                this.currentKeyName = parser.getString();
            } else if (ParserEvents.isValue(event)) {
                this.currentType = ParserEvents.toBroadInstanceType(event);
                if (!AbstractProperties.this.findSubschemas(this.currentKeyName, this)) {
                    this.accept(this.defaultSchema);
                }
            }
        }

        @Override
        public void accept(JsonSchema subschema) {
            if (subschema == JsonSchema.FALSE) {
                this.append(new RedundantPropertyEvaluator(this.getContext(), this.currentKeyName, JsonSchema.FALSE));
            } else {
                this.append(subschema.createEvaluator(this.getContext(), this.currentType));
            }
        }
    }

    private class NegatedPropertiesEvaluator
    extends AbstractDisjunctivePropertiesEvaluator
    implements Consumer<JsonSchema> {
        private final JsonSchema defaultSchema;
        private String currentKeyName;
        private InstanceType currentType;

        NegatedPropertiesEvaluator(EvaluatorContext context, JsonSchema defaultSchema) {
            super(context, AbstractProperties.this);
            this.defaultSchema = defaultSchema;
        }

        @Override
        public void updateChildren(JsonParser.Event event, JsonParser parser) {
            if (event == JsonParser.Event.KEY_NAME) {
                this.currentKeyName = parser.getString();
            } else if (ParserEvents.isValue(event)) {
                this.currentType = ParserEvents.toBroadInstanceType(event);
                if (!AbstractProperties.this.findSubschemas(this.currentKeyName, this)) {
                    this.accept(this.defaultSchema);
                }
            }
        }

        @Override
        public void accept(JsonSchema subschema) {
            if (subschema == JsonSchema.TRUE || subschema == JsonSchema.EMPTY) {
                this.append(new RedundantPropertyEvaluator(this.getContext(), this.currentKeyName, subschema));
            } else {
                this.append(subschema.createNegatedEvaluator(this.getContext(), this.currentType));
            }
        }
    }
}

