/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.applicator;

import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.annotation.Specs;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.base.json.ParserEvents;
import org.leadpony.justify.internal.evaluator.AbstractConjunctiveItemsEvaluator;
import org.leadpony.justify.internal.evaluator.AbstractDisjunctiveItemsEvaluator;
import org.leadpony.justify.internal.keyword.ArrayKeyword;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.applicator.UnaryCombiner;

@KeywordType(value="contains")
@Specs(value={@Spec(value=SpecVersion.DRAFT_06), @Spec(value=SpecVersion.DRAFT_07)})
public class Contains
extends UnaryCombiner
implements ArrayKeyword {
    public static KeywordMapper mapper() {
        KeywordMapper.FromSchema mapper = Contains::new;
        return mapper;
    }

    public Contains(JsonValue json, JsonSchema subschema) {
        super(subschema);
    }

    @Override
    protected Evaluator doCreateEvaluator(EvaluatorContext context, InstanceType type) {
        return this.createItemsEvaluator(context);
    }

    @Override
    protected Evaluator doCreateNegatedEvaluator(EvaluatorContext context, InstanceType type) {
        return this.createNegatedItemsEvaluator(context);
    }

    private Evaluator createItemsEvaluator(final EvaluatorContext context) {
        final JsonSchema subschema = this.getSubschema();
        return new AbstractDisjunctiveItemsEvaluator(context, this){

            @Override
            public void updateChildren(JsonParser.Event event, JsonParser parser) {
                if (ParserEvents.isValue(event)) {
                    InstanceType type = ParserEvents.toBroadInstanceType(event);
                    this.append(subschema.createEvaluator(context, type));
                }
            }

            @Override
            protected Message getMessage() {
                return Message.INSTANCE_PROBLEM_CONTAINS;
            }
        };
    }

    private Evaluator createNegatedItemsEvaluator(final EvaluatorContext context) {
        final JsonSchema subschema = this.getSubschema();
        return new AbstractConjunctiveItemsEvaluator(context){

            @Override
            public void updateChildren(JsonParser.Event event, JsonParser parser) {
                if (ParserEvents.isValue(event)) {
                    InstanceType type = ParserEvents.toBroadInstanceType(event);
                    this.append(subschema.createNegatedEvaluator(context, type));
                }
            }
        };
    }
}

