/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.applicator;

import jakarta.json.JsonValue;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.annotation.Specs;
import org.leadpony.justify.internal.keyword.Evaluatable;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.SchemaKeyword;
import org.leadpony.justify.internal.keyword.applicator.Applicator;

@KeywordType(value="definitions")
@Specs(value={@Spec(value=SpecVersion.DRAFT_04), @Spec(value=SpecVersion.DRAFT_06), @Spec(value=SpecVersion.DRAFT_07)})
public class Definitions
extends Applicator {
    private final Map<String, JsonSchema> definitionMap;

    public static KeywordMapper mapper() {
        KeywordMapper.FromSchemaMap mapper = Definitions::new;
        return mapper;
    }

    public Definitions(JsonValue json, Map<String, JsonSchema> definitionMap) {
        super(json);
        this.definitionMap = definitionMap;
    }

    @Override
    public void addToEvaluatables(List<Evaluatable> evaluatables, Map<String, SchemaKeyword> keywords) {
    }

    @Override
    public boolean hasSubschemas() {
        return !this.definitionMap.isEmpty();
    }

    @Override
    public Stream<JsonSchema> getSubschemas() {
        return this.definitionMap.values().stream();
    }

    @Override
    public JsonSchema getSubschema(Iterator<String> jsonPointer) {
        if (jsonPointer.hasNext()) {
            return this.definitionMap.get(jsonPointer.next());
        }
        return null;
    }
}

