/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.applicator;

import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.util.EnumSet;
import java.util.Set;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.annotation.Specs;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.evaluator.AbstractConjunctivePropertiesEvaluator;
import org.leadpony.justify.internal.evaluator.AbstractDisjunctivePropertiesEvaluator;
import org.leadpony.justify.internal.evaluator.Evaluators;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.applicator.UnaryCombiner;
import org.leadpony.justify.internal.problem.ProblemBuilder;

@KeywordType(value="propertyNames")
@Specs(value={@Spec(value=SpecVersion.DRAFT_06), @Spec(value=SpecVersion.DRAFT_07)})
public class PropertyNames
extends UnaryCombiner {
    public static KeywordMapper mapper() {
        KeywordMapper.FromSchema mapper = PropertyNames::new;
        return mapper;
    }

    public PropertyNames(JsonValue json, JsonSchema subschema) {
        super(subschema);
    }

    @Override
    public boolean supportsType(InstanceType type) {
        return type == InstanceType.OBJECT;
    }

    @Override
    public Set<InstanceType> getSupportedTypes() {
        return EnumSet.of(InstanceType.OBJECT);
    }

    @Override
    protected Evaluator doCreateEvaluator(EvaluatorContext context, InstanceType type) {
        JsonSchema subschema = this.getSubschema();
        if (subschema == JsonSchema.FALSE) {
            return this.createForbiddenPropertiesEvaluator(context, subschema);
        }
        return this.createPropertiesEvaluator(context, subschema);
    }

    @Override
    protected Evaluator doCreateNegatedEvaluator(EvaluatorContext context, InstanceType type) {
        JsonSchema subschema = this.getSubschema();
        if (subschema == JsonSchema.TRUE || subschema == JsonSchema.EMPTY) {
            return Evaluators.alwaysFalse(subschema, context);
        }
        return this.createNegatedPropertiesEvaluator(context, subschema);
    }

    private Evaluator createForbiddenPropertyEvaluator(EvaluatorContext context, JsonSchema subschema) {
        return (event, depth, dispatcher) -> {
            ProblemBuilder b = this.createProblemBuilder(context).withMessage(Message.INSTANCE_PROBLEM_OBJECT_NONEMPTY);
            dispatcher.dispatchProblem(b.build());
            return Evaluator.Result.FALSE;
        };
    }

    private Evaluator createForbiddenPropertiesEvaluator(final EvaluatorContext context, final JsonSchema subschema) {
        return new AbstractConjunctivePropertiesEvaluator(context){

            @Override
            public void updateChildren(JsonParser.Event event, JsonParser parser) {
                if (event == JsonParser.Event.KEY_NAME) {
                    this.append(PropertyNames.this.createForbiddenPropertyEvaluator(context, subschema));
                }
            }
        };
    }

    private Evaluator createPropertiesEvaluator(final EvaluatorContext context, final JsonSchema subschema) {
        return new AbstractConjunctivePropertiesEvaluator(context){

            @Override
            public void updateChildren(JsonParser.Event event, JsonParser parser) {
                if (event == JsonParser.Event.KEY_NAME) {
                    this.append(subschema.createEvaluator(context, InstanceType.STRING));
                }
            }
        };
    }

    private Evaluator createNegatedPropertiesEvaluator(final EvaluatorContext context, final JsonSchema subschema) {
        return new AbstractDisjunctivePropertiesEvaluator(context, this){

            @Override
            public void updateChildren(JsonParser.Event event, JsonParser parser) {
                if (event == JsonParser.Event.KEY_NAME) {
                    this.append(subschema.createNegatedEvaluator(context, InstanceType.STRING));
                }
            }
        };
    }
}

