/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion;

import jakarta.json.JsonValue;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.annotation.Specs;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.assertion.AbstractEqualityAssertion;
import org.leadpony.justify.internal.problem.ProblemBuilder;

@KeywordType(value="const")
@Specs(value={@Spec(value=SpecVersion.DRAFT_06), @Spec(value=SpecVersion.DRAFT_07)})
public class Const
extends AbstractEqualityAssertion {
    public static KeywordMapper mapper() {
        return (value, context) -> new Const(value);
    }

    public Const(JsonValue expected) {
        super(expected);
    }

    @Override
    protected boolean testValue(JsonValue value) {
        return value.equals(this.getValueAsJson());
    }

    @Override
    protected Problem createProblem(ProblemBuilder builder) {
        JsonValue expected = this.getValueAsJson();
        return builder.withMessage(Message.INSTANCE_PROBLEM_CONST).withParameter("expected", expected).withParameter("expectedType", (Object)InstanceType.of(expected)).build();
    }

    @Override
    protected Problem createNegatedProblem(ProblemBuilder builder) {
        JsonValue expected = this.getValueAsJson();
        return builder.withMessage(Message.INSTANCE_PROBLEM_NOT_CONST).withParameter("expected", expected).withParameter("expectedType", (Object)InstanceType.of(expected)).build();
    }
}

