/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion;

import jakarta.json.JsonValue;
import java.util.LinkedHashSet;
import java.util.Set;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.annotation.Specs;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.assertion.AbstractEqualityAssertion;
import org.leadpony.justify.internal.problem.ProblemBuilder;

@KeywordType(value="enum")
@Specs(value={@Spec(value=SpecVersion.DRAFT_04), @Spec(value=SpecVersion.DRAFT_06), @Spec(value=SpecVersion.DRAFT_07)})
public class Enum
extends AbstractEqualityAssertion {
    private final Set<JsonValue> expected;

    public static KeywordMapper mapper() {
        return (value, context) -> {
            if (value.getValueType() == JsonValue.ValueType.ARRAY) {
                LinkedHashSet<JsonValue> values = new LinkedHashSet<JsonValue>();
                for (JsonValue item : value.asJsonArray()) {
                    values.add(item);
                }
                return new Enum(value, values);
            }
            throw new IllegalArgumentException();
        };
    }

    public Enum(JsonValue json, Set<JsonValue> expected) {
        super(json);
        this.expected = expected;
    }

    @Override
    protected boolean testValue(JsonValue value) {
        for (JsonValue expected : this.expected) {
            if (!value.equals(expected)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Problem createProblem(ProblemBuilder builder) {
        return builder.withMessage(Message.INSTANCE_PROBLEM_ENUM).withParameter("expected", this.expected).build();
    }

    @Override
    protected Problem createNegatedProblem(ProblemBuilder builder) {
        return builder.withMessage(Message.INSTANCE_PROBLEM_NOT_ENUM).withParameter("expected", this.expected).build();
    }
}

