/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.content;

import jakarta.json.spi.JsonProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.leadpony.justify.internal.keyword.assertion.content.Base64;
import org.leadpony.justify.internal.keyword.assertion.content.JsonMimeType;
import org.leadpony.justify.spi.ContentEncodingScheme;
import org.leadpony.justify.spi.ContentMimeType;

public final class ContentAttributes {
    static final Base64 BASE64 = new Base64();

    public static Map<String, ContentEncodingScheme> encodingSchemes() {
        HashMap<String, ContentEncodingScheme> result = new HashMap<String, ContentEncodingScheme>();
        ContentAttributes.addEncodingScheme(result, BASE64);
        for (ContentEncodingScheme scheme : ServiceLoader.load(ContentEncodingScheme.class)) {
            ContentAttributes.addEncodingScheme(result, scheme);
        }
        return result;
    }

    public static Map<String, ContentMimeType> mimeTypes(JsonProvider jsonProvider) {
        HashMap<String, ContentMimeType> result = new HashMap<String, ContentMimeType>();
        ContentAttributes.addMimeType(result, new JsonMimeType(jsonProvider));
        for (ContentMimeType mimeType : ServiceLoader.load(ContentMimeType.class)) {
            ContentAttributes.addMimeType(result, mimeType);
        }
        return result;
    }

    private static void addEncodingScheme(Map<String, ContentEncodingScheme> schemes, ContentEncodingScheme scheme) {
        schemes.put(scheme.name().toLowerCase(), scheme);
    }

    private static void addMimeType(Map<String, ContentMimeType> mimeTypes, ContentMimeType mimeType) {
        mimeTypes.put(mimeType.toString().toLowerCase(), mimeType);
    }

    private ContentAttributes() {
    }
}

