/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.content;

import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.base.MediaType;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.keyword.Evaluatable;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.SchemaKeyword;
import org.leadpony.justify.internal.keyword.assertion.AbstractAssertion;
import org.leadpony.justify.internal.keyword.assertion.content.ContentEncoding;
import org.leadpony.justify.internal.keyword.assertion.content.UnknownContentMediaType;
import org.leadpony.justify.spi.ContentEncodingScheme;
import org.leadpony.justify.spi.ContentMimeType;

@KeywordType(value="contentMediaType")
@Spec(value=SpecVersion.DRAFT_07)
public class ContentMediaType
extends AbstractAssertion {
    private final ContentMimeType mimeType;
    private final Map<String, String> parameters;
    private ContentEncodingScheme encodingScheme;

    public static KeywordMapper mapper() {
        return (value, context) -> {
            if (value.getValueType() == JsonValue.ValueType.STRING) {
                String name = ((JsonString)value).getString();
                try {
                    MediaType mediaType = MediaType.valueOf(name);
                    ContentMimeType mimeType = context.getMimeType(mediaType.mimeType());
                    if (mimeType != null) {
                        return new ContentMediaType(value, mimeType, mediaType.parameters());
                    }
                    return new UnknownContentMediaType(value, name);
                }
                catch (IllegalArgumentException e) {
                    return new UnknownContentMediaType(value, name);
                }
            }
            throw new IllegalArgumentException();
        };
    }

    public ContentMediaType(JsonValue json, ContentMimeType mimeType, Map<String, String> parameters) {
        super(json);
        this.mimeType = mimeType;
        this.parameters = parameters;
    }

    @Override
    public boolean supportsType(InstanceType type) {
        return type == InstanceType.STRING;
    }

    @Override
    public Set<InstanceType> getSupportedTypes() {
        return EnumSet.of(InstanceType.STRING);
    }

    @Override
    protected Evaluator doCreateEvaluator(final EvaluatorContext context, InstanceType type) {
        String value = context.getParser().getString();
        if (this.testValue(value, true)) {
            return Evaluator.ALWAYS_TRUE;
        }
        return new Evaluator(){

            @Override
            public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
                dispatcher.dispatchProblem(ContentMediaType.this.buildProblem(context, Message.INSTANCE_PROBLEM_CONTENTMEDIATYPE));
                return Evaluator.Result.FALSE;
            }
        };
    }

    @Override
    protected Evaluator doCreateNegatedEvaluator(final EvaluatorContext context, InstanceType type) {
        String value = context.getParser().getString();
        if (!this.testValue(value, false)) {
            return Evaluator.ALWAYS_TRUE;
        }
        return new Evaluator(){

            @Override
            public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
                dispatcher.dispatchProblem(ContentMediaType.this.buildProblem(context, Message.INSTANCE_PROBLEM_NOT_CONTENTMEDIATYPE));
                return Evaluator.Result.FALSE;
            }
        };
    }

    @Override
    public void addToEvaluatables(List<Evaluatable> evaluatables, Map<String, SchemaKeyword> keywords) {
        if (keywords.containsKey("contentEncoding")) {
            SchemaKeyword keyword = keywords.get("contentEncoding");
            if (keyword instanceof ContentEncoding) {
                this.encodingScheme = ((ContentEncoding)keyword).scheme();
            } else {
                return;
            }
        }
        evaluatables.add(this);
    }

    private boolean testValue(String value, boolean defaultResult) {
        if (this.encodingScheme != null) {
            if (this.encodingScheme.canDecode(value)) {
                byte[] decoded = this.encodingScheme.decode(value);
                return this.mimeType.test(decoded, this.parameters);
            }
            return defaultResult;
        }
        return this.mimeType.test(value);
    }

    String value() {
        StringBuilder builder = new StringBuilder(this.mimeType.toString());
        this.parameters.forEach((key, value) -> builder.append("; ").append((String)key).append('=').append((String)value));
        return builder.toString();
    }

    private Problem buildProblem(EvaluatorContext context, Message message) {
        return this.createProblemBuilder(context).withMessage(message).withParameter("type", this.value()).build();
    }
}

