/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.format;

import java.util.NoSuchElementException;

abstract class AbstractFormatMatcher {
    private final CharSequence input;
    private final int length;
    private int index;

    protected AbstractFormatMatcher(CharSequence input) {
        this.input = input;
        this.length = input.length();
        this.index = 0;
    }

    protected AbstractFormatMatcher(CharSequence input, int start, int end) {
        this.input = input;
        this.length = end;
        this.index = start;
    }

    boolean matches() {
        try {
            return this.test();
        }
        catch (NoSuchElementException | FormatMismatchException e) {
            return false;
        }
    }

    abstract boolean test();

    final CharSequence input() {
        return this.input;
    }

    final int pos() {
        return this.index;
    }

    final boolean backtrack(int pos) {
        this.index = pos;
        return false;
    }

    final boolean hasNext() {
        return this.index < this.length;
    }

    final boolean hasNext(int expected) {
        return this.hasNext() && this.peek() == expected;
    }

    final int next() {
        if (this.hasNext()) {
            int codePoint = this.codePointAt(this.input, this.index);
            this.index = this.offsetByCodePoint(this.input, this.index);
            return codePoint;
        }
        throw new NoSuchElementException();
    }

    final int peek() {
        if (this.hasNext()) {
            return this.codePointAt(this.input, this.index);
        }
        throw new NoSuchElementException();
    }

    final String extract(int start) {
        return this.extract(start, this.pos());
    }

    final String extract(int start, int end) {
        return this.input.subSequence(start, end).toString();
    }

    public String toString() {
        return this.input.subSequence(this.index, this.length).toString();
    }

    static boolean fail() {
        throw new FormatMismatchException();
    }

    protected int codePointAt(CharSequence input, int index) {
        return Character.codePointAt(input, index);
    }

    protected int offsetByCodePoint(CharSequence input, int index) {
        return Character.offsetByCodePoints(input, index, 1);
    }

    private static class FormatMismatchException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private FormatMismatchException() {
        }
    }
}

