/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.format;

import java.util.BitSet;
import org.leadpony.justify.internal.base.text.AsciiCode;
import org.leadpony.justify.internal.keyword.assertion.format.AbstractFormatMatcher;
import org.leadpony.justify.internal.keyword.assertion.format.Ipv4Matcher;
import org.leadpony.justify.internal.keyword.assertion.format.Ipv6Matcher;
import org.leadpony.justify.internal.keyword.assertion.format.UriCode;

class UriMatcher
extends AbstractFormatMatcher {
    private static final int[] GEN_DELIMS = new int[]{58, 47, 63, 35, 91, 93, 64};
    private static final int[] SUB_DELIMS = new int[]{33, 36, 38, 39, 40, 41, 42, 43, 44, 59, 61};
    private static final BitSet GEN_DELIMS_SET = new BitSet();
    private static final BitSet SUB_DELIMS_SET = new BitSet();
    private static final BitSet RESERVED = new BitSet();

    UriMatcher(CharSequence input) {
        super(UriMatcher.decodeAllUnreserved(input));
    }

    @Override
    boolean test() {
        return this.uri();
    }

    boolean uri() {
        if (this.scheme() && this.hasNext(58)) {
            this.next();
            if (this.hierPart()) {
                if (this.hasNext(63)) {
                    this.next();
                    if (!this.query()) {
                        return false;
                    }
                }
                if (this.hasNext(35)) {
                    this.next();
                    if (!this.fragment()) {
                        return false;
                    }
                }
                return !this.hasNext();
            }
        }
        return false;
    }

    boolean scheme() {
        int c;
        int mark = this.pos();
        if (this.hasNext() && AsciiCode.isAlphabetic(c = this.next())) {
            while (this.hasNext() && this.peek() != 58) {
                c = this.next();
                if (AsciiCode.isAlphanumeric(c) || c == 43 || c == 45 || c == 46) continue;
                return this.backtrack(mark);
            }
            return true;
        }
        return this.backtrack(mark);
    }

    boolean hierPart() {
        if (this.hasNext(47)) {
            int mark = this.pos();
            this.next();
            if (this.hasNext(47)) {
                this.next();
                return this.authority() && this.pathAbempty();
            }
            this.backtrack(mark);
            return this.pathAbsolute();
        }
        return this.pathRootless() || this.pathEmpty();
    }

    boolean authority() {
        if (!this.hasNext()) {
            return false;
        }
        if (this.userinfo()) {
            this.next();
        }
        if (this.host()) {
            if (this.hasNext(58)) {
                this.next();
                this.port();
            }
            return true;
        }
        return false;
    }

    boolean userinfo() {
        int start = this.pos();
        while (this.hasNext()) {
            if (this.unreserved() || this.pctEncoded()) continue;
            int c = this.peek();
            if (c == 64) {
                return true;
            }
            if (!UriCode.isSubDelim(c) && c != 58) break;
            this.next();
        }
        return this.backtrack(start);
    }

    boolean host() {
        return this.ipLiteral() || this.ipv4Address() || this.regName();
    }

    boolean ipLiteral() {
        if (this.hasNext(91)) {
            this.next();
            if ((this.ipvFuture() || this.ipv6Address()) && this.next() == 93) {
                return true;
            }
            UriMatcher.fail();
        }
        return false;
    }

    boolean ipvFuture() {
        if (this.hasNext(118) || this.hasNext(86)) {
            this.next();
            if (AsciiCode.isHexDigit(this.next())) {
                int c;
                while (AsciiCode.isHexDigit(this.peek())) {
                    this.next();
                }
                if (this.next() == 46 && (UriCode.isUnreserved(c = this.next()) || UriCode.isSubDelim(c) || c == 58)) {
                    while (this.hasNext()) {
                        c = this.peek();
                        if (UriCode.isUnreserved(c) || UriCode.isSubDelim(c) || c == 58) {
                            this.next();
                            continue;
                        }
                        return true;
                    }
                }
            }
            UriMatcher.fail();
        }
        return false;
    }

    boolean ipv6Address() {
        int start = this.pos();
        while (this.hasNext()) {
            if (this.peek() == 93) {
                Ipv6Matcher m = new Ipv6Matcher(this.input(), start, this.pos());
                return m.matches();
            }
            this.next();
        }
        return false;
    }

    boolean ipv4Address() {
        int start = this.pos();
        while (this.hasNext() && !UriCode.isReserved(this.peek())) {
            this.next();
        }
        Ipv4Matcher m = new Ipv4Matcher(this.input(), start, this.pos());
        if (m.matches()) {
            return true;
        }
        return this.backtrack(start);
    }

    boolean regName() {
        while (this.hasNext()) {
            if (this.unreserved() || this.pctEncoded()) continue;
            if (!UriCode.isSubDelim(this.peek())) break;
            this.next();
        }
        return true;
    }

    void port() {
        while (this.hasNext() && AsciiCode.isDigit(this.peek())) {
            this.next();
        }
    }

    boolean pathAbempty() {
        while (this.hasNext(47)) {
            this.next();
            this.segment();
        }
        return true;
    }

    boolean pathNoscheme() {
        if (this.segmentNzNc()) {
            while (this.hasNext(47)) {
                this.next();
                this.segment();
            }
            return true;
        }
        return false;
    }

    boolean pathAbsolute() {
        if (this.hasNext(47)) {
            this.next();
            if (this.segmentNz()) {
                while (this.hasNext(47)) {
                    this.next();
                    this.segment();
                }
            }
            return true;
        }
        return false;
    }

    boolean pathRootless() {
        if (this.segmentNz()) {
            while (this.hasNext(47)) {
                this.next();
                this.segment();
            }
            return true;
        }
        return false;
    }

    boolean pathEmpty() {
        int c;
        return !this.hasNext() || (c = this.peek()) == 63 || c == 35;
    }

    boolean segment() {
        while (this.pchar()) {
        }
        return true;
    }

    boolean segmentNz() {
        if (this.pchar()) {
            while (this.pchar()) {
            }
            return true;
        }
        return false;
    }

    boolean segmentNzNc() {
        int length = 0;
        while (this.hasNext()) {
            if (this.unreserved() || this.pctEncoded()) {
                ++length;
                continue;
            }
            int c = this.peek();
            if (!UriCode.isSubDelim(c) && c != 64) break;
            this.next();
            ++length;
        }
        return length > 0;
    }

    boolean pchar() {
        if (this.hasNext()) {
            if (this.unreserved() || this.pctEncoded()) {
                return true;
            }
            int c = this.peek();
            if (UriCode.isSubDelim(c) || c == 58 || c == 64) {
                this.next();
                return true;
            }
        }
        return false;
    }

    boolean query() {
        while (this.hasNext() && this.peek() != 35) {
            if (this.pchar()) continue;
            int c = this.peek();
            if (c == 47 || c == 63) {
                this.next();
                continue;
            }
            return UriMatcher.fail();
        }
        return true;
    }

    boolean fragment() {
        while (this.hasNext()) {
            if (this.pchar()) continue;
            int c = this.peek();
            if (c == 47 || c == 63) {
                this.next();
                continue;
            }
            return UriMatcher.fail();
        }
        return true;
    }

    boolean unreserved() {
        if (this.hasNext() && UriCode.isUnreserved(this.peek())) {
            this.next();
            return true;
        }
        return false;
    }

    boolean pctEncoded() {
        if (this.hasNext(37)) {
            this.next();
            if (AsciiCode.isHexDigit(this.next()) && AsciiCode.isHexDigit(this.next())) {
                return true;
            }
            return UriMatcher.fail();
        }
        return false;
    }

    boolean relativeRef() {
        if (this.relativePart()) {
            if (this.hasNext(63)) {
                this.next();
                if (!this.query()) {
                    return false;
                }
            }
            if (this.hasNext(35)) {
                this.next();
                if (!this.fragment()) {
                    return false;
                }
            }
            return !this.hasNext();
        }
        return false;
    }

    boolean relativePart() {
        if (this.hasNext(47)) {
            int mark = this.pos();
            this.next();
            if (this.hasNext(47)) {
                this.next();
                return this.authority() && this.pathAbempty();
            }
            this.backtrack(mark);
            return this.pathAbsolute();
        }
        return this.pathNoscheme() || this.pathEmpty();
    }

    private static CharSequence decodeAllUnreserved(CharSequence input) {
        StringBuilder b = new StringBuilder();
        int length = input.length();
        int startIndex = 0;
        int index = 0;
        while (index < length) {
            if (input.charAt(index) == '%' && index + 2 < length) {
                char low;
                char high = input.charAt(index + 1);
                int codePoint = UriMatcher.decodePercentEncoded(high, low = input.charAt(index + 2));
                if (codePoint >= 0 && UriCode.isUnreserved(codePoint)) {
                    b.append(input, startIndex, index).appendCodePoint(codePoint);
                    startIndex = index + 3;
                }
                index += 3;
                continue;
            }
            ++index;
        }
        if (startIndex == 0) {
            return input;
        }
        if (startIndex < length) {
            b.append(input, startIndex, length);
        }
        return b.toString();
    }

    private static int decodePercentEncoded(int high, int low) {
        int codePoint = -1;
        if (AsciiCode.isHexDigit(high) && AsciiCode.isHexDigit(low)) {
            codePoint = AsciiCode.hexDigitToValue(high) * 16 + AsciiCode.hexDigitToValue(low);
        }
        return codePoint;
    }

    static {
        for (int c : GEN_DELIMS) {
            GEN_DELIMS_SET.set(c);
        }
        for (int c : SUB_DELIMS) {
            SUB_DELIMS_SET.set(c);
        }
        RESERVED.or(GEN_DELIMS_SET);
        RESERVED.or(SUB_DELIMS_SET);
    }
}

