/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.problem;

import jakarta.json.stream.JsonLocation;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.internal.base.Message;

enum LineFormat {
    MINIMAL{

        @Override
        String format(Problem problem, Locale locale) {
            return problem.getMessage(locale);
        }
    }
    ,
    LOCATION_ONLY{

        @Override
        String format(Problem problem, Locale locale) {
            return Message.LINE_WITH_LOCATION.format(LineFormat.formatArgs(problem, locale), locale);
        }
    }
    ,
    POINTER_ONLY{

        @Override
        String format(Problem problem, Locale locale) {
            return Message.LINE_WITH_POINTER.format(LineFormat.formatArgs(problem, locale), locale);
        }
    }
    ,
    FULL{

        @Override
        String format(Problem problem, Locale locale) {
            return Message.LINE_WITH_BOTH.format(LineFormat.formatArgs(problem, locale), locale);
        }
    };


    static LineFormat get(boolean location, boolean pointer) {
        if (location) {
            if (pointer) {
                return FULL;
            }
            return LOCATION_ONLY;
        }
        if (pointer) {
            return POINTER_ONLY;
        }
        return MINIMAL;
    }

    abstract String format(Problem var1, Locale var2);

    private static Map<String, Object> formatArgs(Problem problem, Locale locale) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("message", problem.getMessage(locale));
        JsonLocation location = problem.getLocation();
        if (location == null) {
            args.put("row", "?");
            args.put("col", "?");
        } else {
            args.put("row", location.getLineNumber());
            args.put("col", location.getColumnNumber());
        }
        String pointer = problem.getPointer();
        if (pointer == null) {
            pointer = "?";
        }
        args.put("pointer", pointer);
        return args;
    }
}

