/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.provider;

import java.util.Map;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.keyword.KeywordFactory;
import org.leadpony.justify.internal.schema.SchemaSpec;
import org.leadpony.justify.spi.ContentEncodingScheme;
import org.leadpony.justify.spi.ContentMimeType;
import org.leadpony.justify.spi.FormatAttribute;

class CustomSchemaSpec
implements SchemaSpec {
    private final SchemaSpec baseSpec;
    private final Map<String, FormatAttribute> customFormatAttributes;

    CustomSchemaSpec(SchemaSpec baseSpec, Map<String, FormatAttribute> formatAttributes) {
        this.baseSpec = baseSpec;
        this.customFormatAttributes = formatAttributes;
    }

    @Override
    public SpecVersion getVersion() {
        return this.baseSpec.getVersion();
    }

    @Override
    public JsonSchema getMetaschema() {
        return this.baseSpec.getMetaschema();
    }

    @Override
    public KeywordFactory getKeywordFactory() {
        return this.baseSpec.getKeywordFactory();
    }

    @Override
    public FormatAttribute getFormatAttribute(String name) {
        FormatAttribute attribute = this.customFormatAttributes.get(name);
        if (attribute == null) {
            attribute = this.baseSpec.getFormatAttribute(name);
        }
        return attribute;
    }

    @Override
    public ContentEncodingScheme getEncodingScheme(String name) {
        return this.baseSpec.getEncodingScheme(name);
    }

    @Override
    public ContentMimeType getMimeType(String value) {
        return this.baseSpec.getMimeType(value);
    }
}

