/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.provider;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.base.json.JsonService;
import org.leadpony.justify.internal.provider.CustomSchemaSpec;
import org.leadpony.justify.internal.provider.StandardSchemaSpec;
import org.leadpony.justify.internal.schema.SchemaCatalog;
import org.leadpony.justify.internal.schema.SchemaSpec;
import org.leadpony.justify.internal.schema.SchemaSpecRegistry;
import org.leadpony.justify.spi.FormatAttribute;

final class DefaultSchemaSpecRegistry
implements SchemaSpecRegistry {
    private final Map<SpecVersion, SchemaSpec> specs = new HashMap<SpecVersion, SchemaSpec>();
    private final SchemaCatalog catalog = new SchemaCatalog();
    private static final Map<String, FormatAttribute> CUSTOM_FORMAT_ATTRIBUTES = DefaultSchemaSpecRegistry.findFormatAttributes();

    static SchemaSpecRegistry load(JsonService jsonService) {
        DefaultSchemaSpecRegistry registry = new DefaultSchemaSpecRegistry();
        registry.installSpecs(jsonService);
        return registry;
    }

    private DefaultSchemaSpecRegistry() {
    }

    @Override
    public SchemaSpec getSpec(SpecVersion version, boolean full) {
        SchemaSpec spec = this.specs.get((Object)version);
        if (full) {
            spec = new CustomSchemaSpec(spec, CUSTOM_FORMAT_ATTRIBUTES);
        }
        return spec;
    }

    @Override
    public SchemaCatalog getMetaschemaCatalog() {
        return this.catalog;
    }

    private void installSpecs(JsonService jsonService) {
        for (SchemaSpec spec : StandardSchemaSpec.values(jsonService)) {
            this.specs.put(spec.getVersion(), spec);
            this.catalog.addSchema(spec.getMetaschema());
        }
    }

    private static Map<String, FormatAttribute> findFormatAttributes() {
        HashMap map = new HashMap();
        ServiceLoader.load(FormatAttribute.class).forEach(a -> map.put(a.name(), a));
        return Collections.unmodifiableMap(map);
    }
}

