/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.schema;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.net.URI;
import java.util.Map;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.Keyword;
import org.leadpony.justify.api.ObjectJsonSchema;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.internal.base.AbstractEmptyMap;
import org.leadpony.justify.internal.base.Arguments;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.keyword.SchemaKeyword;
import org.leadpony.justify.internal.keyword.core.Ref;
import org.leadpony.justify.internal.problem.ProblemBuilderFactory;
import org.leadpony.justify.internal.schema.AbstractJsonSchema;

public class SchemaReference
extends AbstractJsonSchema {
    private URI targetId;
    private JsonSchema referencedSchema = new NonexistentSchema();

    public SchemaReference(URI id, JsonObject json, Map<String, SchemaKeyword> keywords) {
        super(id, (JsonValue)json, keywords);
        this.targetId = this.hasAbsoluteId() ? this.id().resolve(this.ref()) : this.ref();
    }

    public URI ref() {
        Ref ref = (Ref)this.getKeyword("$ref");
        return (URI)ref.value();
    }

    public URI getTargetId() {
        return this.targetId;
    }

    public boolean hasReferencedSchema() {
        return this.referencedSchema != null;
    }

    public JsonSchema getReferencedSchema() {
        return this.referencedSchema;
    }

    public void setReferencedSchema(JsonSchema schema) {
        Arguments.requireNonNull(schema, "schema");
        this.referencedSchema = schema;
    }

    @Override
    public Evaluator createEvaluator(EvaluatorContext context, InstanceType type) {
        return this.referencedSchema.createEvaluator(context, type);
    }

    @Override
    public Evaluator createNegatedEvaluator(EvaluatorContext context, InstanceType type) {
        return this.referencedSchema.createNegatedEvaluator(context, type);
    }

    @Override
    public void resolve(URI baseUri) {
        super.resolve(baseUri);
        if (!this.targetId.isAbsolute()) {
            if (this.hasId()) {
                baseUri = this.id();
            }
            this.targetId = baseUri.resolve(this.targetId);
        }
    }

    private class NonexistentSchema
    extends AbstractEmptyMap<String, Keyword>
    implements ObjectJsonSchema {
        private NonexistentSchema() {
        }

        @Override
        public Evaluator createEvaluator(final EvaluatorContext context, InstanceType type) {
            return new Evaluator(){

                @Override
                public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
                    Problem p = ProblemBuilderFactory.DEFAULT.createProblemBuilder(context).withKeyword("$ref").withMessage(Message.SCHEMA_PROBLEM_REFERENCE).withParameter("ref", SchemaReference.this.ref()).withParameter("targetId", SchemaReference.this.getTargetId()).build();
                    dispatcher.dispatchProblem(p);
                    return Evaluator.Result.FALSE;
                }
            };
        }

        @Override
        public Evaluator createNegatedEvaluator(EvaluatorContext context, InstanceType type) {
            return this.createEvaluator(context, type);
        }

        @Override
        public JsonValue toJson() {
            return JsonValue.EMPTY_JSON_OBJECT;
        }
    }
}

